/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql.test;

import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.flight.sql.example.FlightSqlStatelessExample;
import org.apache.arrow.flight.sql.test.TestFlightSql;
import org.apache.arrow.flight.sql.util.FlightStreamUtils;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class TestFlightSqlStateless
extends TestFlightSql {
    @BeforeAll
    public static void setUp() throws Exception {
        TestFlightSqlStateless.setUpClientServer();
        TestFlightSqlStateless.setUpExpectedResultsMap();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{sqlClient, server, allocator});
        FlightSqlStatelessExample.removeDerbyDatabaseIfExists("derbyStatelessDB");
    }

    private static void setUpClientServer() throws Exception {
        allocator = new RootAllocator(Integer.MAX_VALUE);
        Location serverLocation = Location.forGrpcInsecure((String)"localhost", (int)0);
        server = FlightServer.builder((BufferAllocator)allocator, (Location)serverLocation, (FlightProducer)new FlightSqlStatelessExample(serverLocation, "derbyStatelessDB")).build().start();
        Location clientLocation = Location.forGrpcInsecure((String)"localhost", (int)server.getPort());
        sqlClient = new FlightSqlClient(FlightClient.builder((BufferAllocator)allocator, (Location)clientLocation).build());
    }

    @Override
    @Test
    public void testSimplePreparedStatementResultsWithParameterBinding() throws Exception {
        try (FlightSqlClient.PreparedStatement prepare = sqlClient.prepare("SELECT * FROM intTable WHERE id = ?", new CallOption[0]);){
            Schema parameterSchema = prepare.getParameterSchema();
            try (VectorSchemaRoot insertRoot = VectorSchemaRoot.create((Schema)parameterSchema, (BufferAllocator)allocator);){
                insertRoot.allocateNew();
                IntVector valueVector = (IntVector)insertRoot.getVector(0);
                valueVector.setSafe(0, 1);
                insertRoot.setRowCount(1);
                prepare.setParameters(insertRoot);
                FlightInfo flightInfo = prepare.execute(new CallOption[0]);
                for (FlightEndpoint endpoint : flightInfo.getEndpoints()) {
                    FlightStream stream = sqlClient.getStream(endpoint.getTicket(), new CallOption[0]);
                    try {
                        Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)SCHEMA_INT_TABLE)), () -> MatcherAssert.assertThat(FlightStreamUtils.getResults(stream), (Matcher)CoreMatchers.is((Object)EXPECTED_RESULTS_FOR_PARAMETER_BINDING))});
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
            }
        }
    }
}

