/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql.example;

import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcParameterBinder;
import org.apache.arrow.adapter.jdbc.JdbcToArrow;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.sql.example.DoPutPreparedStatementResultPOJO;
import org.apache.arrow.flight.sql.example.FlightSqlExample;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.SeekableReadChannel;
import org.apache.arrow.vector.ipc.message.ArrowBlock;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightSqlStatelessExample
extends FlightSqlExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlightSqlStatelessExample.class);
    public static final String DB_NAME = "derbyStatelessDB";

    public FlightSqlStatelessExample(Location location, String dbName) {
        super(location, dbName);
    }

    @Override
    public Runnable acceptPutPreparedStatementQuery(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        return () -> {
            String query = new String(command.getPreparedStatementHandle().toStringUtf8());
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = this.createPreparedStatement(connection, query);){
                while (flightStream.next()) {
                    VectorSchemaRoot root = flightStream.getRoot();
                    JdbcParameterBinder binder = JdbcParameterBinder.builder((PreparedStatement)preparedStatement, (VectorSchemaRoot)root).bindAll().build();
                    while (binder.next()) {
                    }
                    ByteArrayOutputStream parametersStream = new ByteArrayOutputStream();
                    try (ArrowFileWriter writer = new ArrowFileWriter(root, null, Channels.newChannel(parametersStream));){
                        writer.start();
                        writer.writeBatch();
                    }
                    if (parametersStream.size() <= 0) continue;
                    DoPutPreparedStatementResultPOJO doPutPreparedStatementResultPOJO = new DoPutPreparedStatementResultPOJO(query, parametersStream.toByteArray());
                    byte[] doPutPreparedStatementResultPOJOArr = this.serializePOJO(doPutPreparedStatementResultPOJO);
                    FlightSql.DoPutPreparedStatementResult doPutPreparedStatementResult = FlightSql.DoPutPreparedStatementResult.newBuilder().setPreparedStatementHandle(ByteString.copyFrom((ByteBuffer)ByteBuffer.wrap(doPutPreparedStatementResultPOJOArr))).build();
                    ArrowBuf buffer = this.rootAllocator.buffer((long)doPutPreparedStatementResult.getSerializedSize());
                    try {
                        buffer.writeBytes(doPutPreparedStatementResult.toByteArray());
                        ackStream.onNext((Object)PutResult.metadata((ArrowBuf)buffer));
                    }
                    finally {
                        if (buffer == null) continue;
                        buffer.close();
                    }
                }
            }
            catch (IOException | SQLException e) {
                ackStream.onError((Throwable)CallStatus.INTERNAL.withDescription("Failed to bind parameters: " + e.getMessage()).withCause((Throwable)e).toRuntimeException());
                return;
            }
            ackStream.onCompleted();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStreamPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        byte[] handle = command.getPreparedStatementHandle().toByteArray();
        try {
            try {
                DoPutPreparedStatementResultPOJO doPutPreparedStatementResultPOJO = this.deserializePOJO(handle);
                String query = doPutPreparedStatementResultPOJO.getQuery();
                try (Connection connection = this.dataSource.getConnection();
                     PreparedStatement statement = this.createPreparedStatement(connection, query);
                     ArrowFileReader reader = new ArrowFileReader(new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(doPutPreparedStatementResultPOJO.getParameters())), this.rootAllocator);){
                    for (ArrowBlock arrowBlock : reader.getRecordBlocks()) {
                        reader.loadRecordBatch(arrowBlock);
                        VectorSchemaRoot vectorSchemaRootRecover = reader.getVectorSchemaRoot();
                        JdbcParameterBinder binder = JdbcParameterBinder.builder((PreparedStatement)statement, (VectorSchemaRoot)vectorSchemaRootRecover).bindAll().build();
                        while (binder.next()) {
                            this.executeQuery(statement, listener);
                        }
                    }
                }
            }
            catch (StreamCorruptedException e) {
                String query = new String(command.getPreparedStatementHandle().toStringUtf8());
                try (Connection connection = this.dataSource.getConnection();
                     PreparedStatement preparedStatement = this.createPreparedStatement(connection, query);){
                    this.executeQuery(preparedStatement, listener);
                }
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            LOGGER.error(String.format("Failed to getStreamPreparedStatement: <%s>.", e.getMessage()), (Throwable)e);
            listener.error((Throwable)CallStatus.INTERNAL.withDescription("Failed to prepare statement: " + String.valueOf(e)).toRuntimeException());
        }
        finally {
            listener.completed();
        }
    }

    private void executeQuery(PreparedStatement statement, FlightProducer.ServerStreamListener listener) throws IOException, SQLException {
        try (ResultSet resultSet = statement.executeQuery();){
            Schema schema = JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)resultSet.getMetaData(), (Calendar)DEFAULT_CALENDAR);
            try (VectorSchemaRoot vectorSchemaRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.rootAllocator);){
                VectorSchemaRoot batch;
                VectorLoader loader = new VectorLoader(vectorSchemaRoot);
                listener.start(vectorSchemaRoot);
                ArrowVectorIterator iterator = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)resultSet, (BufferAllocator)this.rootAllocator);
                while (iterator.hasNext() && (batch = iterator.next()).getRowCount() != 0) {
                    VectorUnloader unloader = new VectorUnloader(batch);
                    loader.load(unloader.getRecordBatch());
                    listener.putNext();
                    vectorSchemaRoot.clear();
                }
                listener.putNext();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public FlightInfo getFlightInfoPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        byte[] handle = command.getPreparedStatementHandle().toByteArray();
        try {
            String query;
            try {
                query = this.deserializePOJO(handle).getQuery();
            }
            catch (StreamCorruptedException e) {
                query = new String(command.getPreparedStatementHandle().toStringUtf8());
            }
            try (Connection connection = this.dataSource.getConnection();){
                FlightInfo flightInfo;
                block16: {
                    PreparedStatement statement = this.createPreparedStatement(connection, query);
                    try {
                        ResultSetMetaData metaData = statement.getMetaData();
                        flightInfo = this.getFlightInfoForSchema(command, descriptor, JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)metaData, (Calendar)DEFAULT_CALENDAR));
                        if (statement == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return flightInfo;
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            LOGGER.error(String.format("There was a problem executing the prepared statement: <%s>.", e.getMessage()), (Throwable)e);
            throw CallStatus.INTERNAL.withCause((Throwable)e).toRuntimeException();
        }
    }

    private DoPutPreparedStatementResultPOJO deserializePOJO(byte[] handle) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(handle);){
            DoPutPreparedStatementResultPOJO doPutPreparedStatementResultPOJO;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                doPutPreparedStatementResultPOJO = (DoPutPreparedStatementResultPOJO)ois.readObject();
            }
            return doPutPreparedStatementResultPOJO;
        }
    }

    private byte[] serializePOJO(DoPutPreparedStatementResultPOJO doPutPreparedStatementResultPOJO) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(doPutPreparedStatementResultPOJO);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    private PreparedStatement createPreparedStatement(Connection connection, String query) throws SQLException {
        return connection.prepareStatement(query, 1004, 1007);
    }
}

