/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql.example;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Objects;
import org.apache.arrow.util.AutoCloseables;

public final class StatementContext<T extends Statement>
implements AutoCloseable {
    private final T statement;
    private final String query;

    public StatementContext(T statement, String query) {
        this.statement = (Statement)Objects.requireNonNull(statement, "statement cannot be null.");
        this.query = query;
    }

    public T getStatement() {
        return this.statement;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public void close() throws Exception {
        Connection connection = this.statement.getConnection();
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.statement, connection});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StatementContext)) {
            return false;
        }
        StatementContext that = (StatementContext)other;
        return this.statement.equals(that.statement);
    }

    public int hashCode() {
        return Objects.hash(this.statement);
    }
}

