/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.sql.BasicFlightSqlProducer;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.flight.sql.util.FlightStreamUtils;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class TestFlightSqlStreams {
    private static BufferAllocator allocator;
    private static FlightServer server;
    private static FlightSqlClient sqlClient;

    @BeforeAll
    public static void setUp() throws Exception {
        allocator = new RootAllocator(Integer.MAX_VALUE);
        Location serverLocation = Location.forGrpcInsecure((String)"localhost", (int)0);
        server = FlightServer.builder((BufferAllocator)allocator, (Location)serverLocation, (FlightProducer)new FlightSqlTestProducer(allocator)).build().start();
        Location clientLocation = Location.forGrpcInsecure((String)"localhost", (int)server.getPort());
        sqlClient = new FlightSqlClient(FlightClient.builder((BufferAllocator)allocator, (Location)clientLocation).build());
    }

    @AfterAll
    public static void tearDown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{sqlClient, server, allocator});
    }

    @Test
    public void testGetTablesResultNoSchema() throws Exception {
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.getTables(null, null, null, null, false, new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_TABLES_SCHEMA_NO_SCHEMA)), () -> {
                List<List<String>> results = FlightStreamUtils.getResults(stream);
                ImmutableList expectedResults = ImmutableList.of(Arrays.asList(null, null, "test_table", "TABLE"));
                MatcherAssert.assertThat(results, (Matcher)CoreMatchers.is((Object)expectedResults));
            }});
        }
    }

    @Test
    public void testGetTableTypesResult() throws Exception {
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.getTableTypes(new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA)), () -> {
                List<List<String>> tableTypes = FlightStreamUtils.getResults(stream);
                ImmutableList expectedTableTypes = ImmutableList.of(Collections.singletonList("TABLE"));
                MatcherAssert.assertThat(tableTypes, (Matcher)CoreMatchers.is((Object)expectedTableTypes));
            }});
        }
    }

    @Test
    public void testGetSqlInfoResults() throws Exception {
        FlightInfo info = sqlClient.getSqlInfo(new FlightSql.SqlInfo[0]);
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)info.getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA)), () -> MatcherAssert.assertThat(FlightStreamUtils.getResults(stream), (Matcher)CoreMatchers.is(Collections.emptyList()))});
        }
    }

    @Test
    public void testGetTypeInfo() throws Exception {
        FlightInfo flightInfo = sqlClient.getXdbcTypeInfo(new CallOption[0]);
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)flightInfo.getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            List<List<String>> results = FlightStreamUtils.getResults(stream);
            ImmutableList matchers = ImmutableList.of(Arrays.asList("Integer", "4", "400", null, null, "3", "true", null, "true", null, "true", "Integer", null, null, "4", null, "10", null));
            MatcherAssert.assertThat(results, (Matcher)CoreMatchers.is((Object)matchers));
        }
    }

    @Test
    public void testExecuteQuery() throws Exception {
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.execute("SELECT 1 AS c1 FROM test_table", new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlTestProducer.FIXED_SCHEMA)), () -> MatcherAssert.assertThat(FlightStreamUtils.getResults(stream), (Matcher)CoreMatchers.is(Collections.singletonList(Collections.singletonList("1"))))});
        }
    }

    private static class FlightSqlTestProducer
    extends BasicFlightSqlProducer {
        private static final String FIXED_QUERY = "SELECT 1 AS c1 FROM test_table";
        private static final Schema FIXED_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"c1", (ArrowType)Types.MinorType.INT.getType())));
        private BufferAllocator allocator;

        FlightSqlTestProducer(BufferAllocator allocator) {
            this.allocator = allocator;
        }

        protected <T extends Message> List<FlightEndpoint> determineEndpoints(T request, FlightDescriptor flightDescriptor, Schema schema) {
            if (request instanceof FlightSql.CommandGetTables || request instanceof FlightSql.CommandGetTableTypes || request instanceof FlightSql.CommandGetXdbcTypeInfo || request instanceof FlightSql.CommandGetSqlInfo) {
                return Collections.singletonList(new FlightEndpoint(new Ticket(Any.pack(request).toByteArray()), new Location[0]));
            }
            if (request instanceof FlightSql.CommandStatementQuery && ((FlightSql.CommandStatementQuery)request).getQuery().equals(FIXED_QUERY)) {
                FlightSql.TicketStatementQuery ticketStatementQuery = FlightSql.TicketStatementQuery.newBuilder().setStatementHandle(((FlightSql.CommandStatementQuery)request).getQueryBytes()).build();
                return Collections.singletonList(new FlightEndpoint(new Ticket(Any.pack((Message)ticketStatementQuery).toByteArray()), new Location[0]));
            }
            throw CallStatus.UNIMPLEMENTED.withDescription("Not implemented.").toRuntimeException();
        }

        public FlightInfo getFlightInfoStatement(FlightSql.CommandStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
            return this.generateFlightInfo((Message)command, descriptor, FIXED_SCHEMA);
        }

        public void getStreamStatement(FlightSql.TicketStatementQuery ticket, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
            String query = ticket.getStatementHandle().toStringUtf8();
            if (!query.equals(FIXED_QUERY)) {
                listener.error((Throwable)CallStatus.UNIMPLEMENTED.withDescription("Not implemented.").toRuntimeException());
            }
            try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FIXED_SCHEMA, (BufferAllocator)this.allocator);){
                root.setRowCount(1);
                ((IntVector)root.getVector("c1")).setSafe(0, 1);
                listener.start(root);
                listener.putNext();
                listener.completed();
            }
        }

        public void getStreamSqlInfo(FlightSql.CommandGetSqlInfo command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
            try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA, (BufferAllocator)this.allocator);){
                root.setRowCount(0);
                listener.start(root);
                listener.putNext();
                listener.completed();
            }
        }

        public void getStreamTypeInfo(FlightSql.CommandGetXdbcTypeInfo request, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
            try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_TYPE_INFO_SCHEMA, (BufferAllocator)this.allocator);){
                root.setRowCount(1);
                ((VarCharVector)root.getVector("type_name")).setSafe(0, new Text("Integer"));
                ((IntVector)root.getVector("data_type")).setSafe(0, Types.MinorType.INT.ordinal());
                ((IntVector)root.getVector("column_size")).setSafe(0, 400);
                root.getVector("literal_prefix").setNull(0);
                root.getVector("literal_suffix").setNull(0);
                root.getVector("create_params").setNull(0);
                ((IntVector)root.getVector("nullable")).setSafe(0, FlightSql.Nullable.NULLABILITY_NULLABLE.getNumber());
                ((BitVector)root.getVector("case_sensitive")).setSafe(0, 1);
                ((IntVector)root.getVector("nullable")).setSafe(0, FlightSql.Searchable.SEARCHABLE_FULL.getNumber());
                ((BitVector)root.getVector("unsigned_attribute")).setSafe(0, 1);
                root.getVector("fixed_prec_scale").setNull(0);
                ((BitVector)root.getVector("auto_increment")).setSafe(0, 1);
                ((VarCharVector)root.getVector("local_type_name")).setSafe(0, new Text("Integer"));
                root.getVector("minimum_scale").setNull(0);
                root.getVector("maximum_scale").setNull(0);
                ((IntVector)root.getVector("sql_data_type")).setSafe(0, Types.MinorType.INT.ordinal());
                root.getVector("datetime_subcode").setNull(0);
                ((IntVector)root.getVector("num_prec_radix")).setSafe(0, 10);
                root.getVector("interval_precision").setNull(0);
                listener.start(root);
                listener.putNext();
                listener.completed();
            }
        }

        public void getStreamTables(FlightSql.CommandGetTables command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
            try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_TABLES_SCHEMA_NO_SCHEMA, (BufferAllocator)this.allocator);){
                root.setRowCount(1);
                root.getVector("catalog_name").setNull(0);
                root.getVector("db_schema_name").setNull(0);
                ((VarCharVector)root.getVector("table_name")).setSafe(0, new Text("test_table"));
                ((VarCharVector)root.getVector("table_type")).setSafe(0, new Text("TABLE"));
                listener.start(root);
                listener.putNext();
                listener.completed();
            }
        }

        public void getStreamTableTypes(FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
            try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA, (BufferAllocator)this.allocator);){
                root.setRowCount(1);
                ((VarCharVector)root.getVector("table_type")).setSafe(0, new Text("TABLE"));
                listener.start(root);
                listener.putNext();
                listener.completed();
            }
        }
    }
}

