/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql.example;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcParameterBinder;
import org.apache.arrow.adapter.jdbc.JdbcToArrow;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.Criteria;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.sql.FlightSqlColumnMetadata;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.SqlInfoBuilder;
import org.apache.arrow.flight.sql.example.StatementContext;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightSqlExample
implements FlightSqlProducer,
AutoCloseable {
    private static final String DATABASE_URI = "jdbc:derby:target/derbyDB";
    private static final Logger LOGGER = LoggerFactory.getLogger(FlightSqlExample.class);
    private static final Calendar DEFAULT_CALENDAR = JdbcToArrowUtils.getUtcCalendar();
    private final ExecutorService executorService = Executors.newFixedThreadPool(10);
    private final Location location;
    private final PoolingDataSource<PoolableConnection> dataSource;
    private final BufferAllocator rootAllocator = new RootAllocator();
    private final Cache<ByteString, StatementContext<PreparedStatement>> preparedStatementLoadingCache;
    private final Cache<ByteString, StatementContext<Statement>> statementLoadingCache;
    private final SqlInfoBuilder sqlInfoBuilder;

    public static void main(String[] args) throws Exception {
        Location location = Location.forGrpcInsecure((String)"localhost", (int)55555);
        FlightSqlExample example = new FlightSqlExample(location);
        Location listenLocation = Location.forGrpcInsecure((String)"0.0.0.0", (int)55555);
        try (RootAllocator allocator = new RootAllocator();
             FlightServer server = FlightServer.builder((BufferAllocator)allocator, (Location)listenLocation, (FlightProducer)example).build();){
            server.start();
            server.awaitTermination();
        }
    }

    public FlightSqlExample(Location location) {
        Preconditions.checkState((FlightSqlExample.removeDerbyDatabaseIfExists() && FlightSqlExample.populateDerbyDatabase() ? 1 : 0) != 0, (Object)"Failed to reset Derby database!");
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(DATABASE_URI, new Properties());
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        this.dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        this.preparedStatementLoadingCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).removalListener(new StatementRemovalListener()).build();
        this.statementLoadingCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).removalListener(new StatementRemovalListener()).build();
        this.location = location;
        this.sqlInfoBuilder = new SqlInfoBuilder();
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            this.sqlInfoBuilder.withFlightSqlServerName(metaData.getDatabaseProductName()).withFlightSqlServerVersion(metaData.getDatabaseProductVersion()).withFlightSqlServerArrowVersion(metaData.getDriverVersion()).withFlightSqlServerReadOnly(metaData.isReadOnly()).withFlightSqlServerSql(true).withFlightSqlServerSubstrait(false).withFlightSqlServerTransaction(FlightSql.SqlSupportedTransaction.SQL_SUPPORTED_TRANSACTION_NONE).withSqlIdentifierQuoteChar(metaData.getIdentifierQuoteString()).withSqlDdlCatalog(metaData.supportsCatalogsInDataManipulation()).withSqlDdlSchema(metaData.supportsSchemasInDataManipulation()).withSqlDdlTable(metaData.allTablesAreSelectable()).withSqlIdentifierCase(metaData.storesMixedCaseIdentifiers() ? FlightSql.SqlSupportedCaseSensitivity.SQL_CASE_SENSITIVITY_CASE_INSENSITIVE : (metaData.storesUpperCaseIdentifiers() ? FlightSql.SqlSupportedCaseSensitivity.SQL_CASE_SENSITIVITY_UPPERCASE : (metaData.storesLowerCaseIdentifiers() ? FlightSql.SqlSupportedCaseSensitivity.SQL_CASE_SENSITIVITY_LOWERCASE : FlightSql.SqlSupportedCaseSensitivity.SQL_CASE_SENSITIVITY_UNKNOWN))).withSqlQuotedIdentifierCase(metaData.storesMixedCaseQuotedIdentifiers() ? FlightSql.SqlSupportedCaseSensitivity.SQL_CASE_SENSITIVITY_CASE_INSENSITIVE : (metaData.storesUpperCaseQuotedIdentifiers() ? FlightSql.SqlSupportedCaseSensitivity.SQL_CASE_SENSITIVITY_UPPERCASE : (metaData.storesLowerCaseQuotedIdentifiers() ? FlightSql.SqlSupportedCaseSensitivity.SQL_CASE_SENSITIVITY_LOWERCASE : FlightSql.SqlSupportedCaseSensitivity.SQL_CASE_SENSITIVITY_UNKNOWN)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean removeDerbyDatabaseIfExists() {
        boolean wasSuccess;
        block8: {
            Path path = Paths.get("target" + File.separator + "derbyDB", new String[0]);
            try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
                wasSuccess = walk.sorted(Comparator.reverseOrder()).map(Path::toFile).map(File::delete).reduce(Boolean::logicalAnd).orElseThrow(IOException::new);
            }
            catch (IOException e) {
                wasSuccess = e instanceof NoSuchFileException;
                if (wasSuccess) break block8;
                LOGGER.error(String.format("Failed attempt to clear DerbyDB: <%s>", e.getMessage()), (Throwable)e);
            }
        }
        return wasSuccess;
    }

    private static boolean populateDerbyDatabase() {
        try (Connection connection = DriverManager.getConnection("jdbc:derby:target/derbyDB;create=true");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE foreignTable (id INT not null primary key GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), foreignName varchar(100), value int)");
            statement.execute("CREATE TABLE intTable (id INT not null primary key GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), keyName varchar(100), value int, foreignId int references foreignTable(id))");
            statement.execute("INSERT INTO foreignTable (foreignName, value) VALUES ('keyOne', 1)");
            statement.execute("INSERT INTO foreignTable (foreignName, value) VALUES ('keyTwo', 0)");
            statement.execute("INSERT INTO foreignTable (foreignName, value) VALUES ('keyThree', -1)");
            statement.execute("INSERT INTO intTable (keyName, value, foreignId) VALUES ('one', 1, 1)");
            statement.execute("INSERT INTO intTable (keyName, value, foreignId) VALUES ('zero', 0, 1)");
            statement.execute("INSERT INTO intTable (keyName, value, foreignId) VALUES ('negative one', -1, 1)");
        }
        catch (SQLException e) {
            LOGGER.error(String.format("Failed attempt to populate DerbyDB: <%s>", e.getMessage()), (Throwable)e);
            return false;
        }
        return true;
    }

    private static ArrowType getArrowTypeFromJdbcType(int jdbcDataType, int precision, int scale) {
        ArrowType type = JdbcToArrowUtils.getArrowTypeFromJdbcType((JdbcFieldInfo)new JdbcFieldInfo(jdbcDataType, precision, scale), (Calendar)DEFAULT_CALENDAR);
        return Objects.isNull(type) ? ArrowType.Utf8.INSTANCE : type;
    }

    private static void saveToVector(Byte data, UInt1Vector vector, int index) {
        FlightSqlExample.vectorConsumer(data, vector, fieldVector -> fieldVector.setNull(index), (theData, fieldVector) -> fieldVector.setSafe(index, theData.byteValue()));
    }

    private static void saveToVector(Byte data, BitVector vector, int index) {
        FlightSqlExample.vectorConsumer(data, vector, fieldVector -> fieldVector.setNull(index), (theData, fieldVector) -> fieldVector.setSafe(index, (int)theData.byteValue()));
    }

    private static void saveToVector(String data, VarCharVector vector, int index) {
        FlightSqlExample.preconditionCheckSaveToVector((FieldVector)vector, index);
        FlightSqlExample.vectorConsumer(data, vector, fieldVector -> fieldVector.setNull(index), (theData, fieldVector) -> fieldVector.setSafe(index, new Text(theData)));
    }

    private static void saveToVector(Integer data, IntVector vector, int index) {
        FlightSqlExample.preconditionCheckSaveToVector((FieldVector)vector, index);
        FlightSqlExample.vectorConsumer(data, vector, fieldVector -> fieldVector.setNull(index), (theData, fieldVector) -> fieldVector.setSafe(index, theData.intValue()));
    }

    private static void saveToVector(byte[] data, VarBinaryVector vector, int index) {
        FlightSqlExample.preconditionCheckSaveToVector((FieldVector)vector, index);
        FlightSqlExample.vectorConsumer(data, vector, fieldVector -> fieldVector.setNull(index), (theData, fieldVector) -> fieldVector.setSafe(index, theData));
    }

    private static void preconditionCheckSaveToVector(FieldVector vector, int index) {
        Objects.requireNonNull(vector, "vector cannot be null.");
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (Object)"Index must be a positive number!");
    }

    private static <T, V extends FieldVector> void vectorConsumer(T data, V vector, Consumer<V> consumerIfNullable, BiConsumer<T, V> defaultConsumer) {
        if (Objects.isNull(data)) {
            consumerIfNullable.accept(vector);
            return;
        }
        defaultConsumer.accept(data, vector);
    }

    private static VectorSchemaRoot getSchemasRoot(ResultSet data, BufferAllocator allocator) throws SQLException {
        VarCharVector catalogs = new VarCharVector("catalog_name", allocator);
        VarCharVector schemas = new VarCharVector("db_schema_name", FieldType.notNullable((ArrowType)Types.MinorType.VARCHAR.getType()), allocator);
        ImmutableList vectors = ImmutableList.of((Object)catalogs, (Object)schemas);
        vectors.forEach(ValueVector::allocateNew);
        ImmutableMap vectorToColumnName = ImmutableMap.of((Object)catalogs, (Object)"TABLE_CATALOG", (Object)schemas, (Object)"TABLE_SCHEM");
        FlightSqlExample.saveToVectors(vectorToColumnName, data);
        int rows = vectors.stream().map(ValueVector::getValueCount).findAny().orElseThrow(IllegalStateException::new);
        vectors.forEach(vector -> vector.setValueCount(rows));
        return new VectorSchemaRoot((Iterable)vectors);
    }

    private static <T extends FieldVector> int saveToVectors(Map<T, String> vectorToColumnName, ResultSet data, boolean emptyToNull) throws SQLException {
        Predicate<ResultSet> alwaysTrue = resultSet -> true;
        return FlightSqlExample.saveToVectors(vectorToColumnName, data, emptyToNull, alwaysTrue);
    }

    private static <T extends FieldVector> int saveToVectors(Map<T, String> vectorToColumnName, ResultSet data, boolean emptyToNull, Predicate<ResultSet> resultSetPredicate) throws SQLException {
        Objects.requireNonNull(vectorToColumnName, "vectorToColumnName cannot be null.");
        Objects.requireNonNull(data, "data cannot be null.");
        Set<Map.Entry<T, String>> entrySet = vectorToColumnName.entrySet();
        int rows = 0;
        while (data.next()) {
            if (!resultSetPredicate.test(data)) continue;
            for (Map.Entry<T, String> vectorToColumn : entrySet) {
                FieldVector vector = (FieldVector)vectorToColumn.getKey();
                String columnName = vectorToColumn.getValue();
                if (vector instanceof VarCharVector) {
                    String thisData = data.getString(columnName);
                    FlightSqlExample.saveToVector(emptyToNull ? Strings.emptyToNull((String)thisData) : thisData, (VarCharVector)vector, rows);
                    continue;
                }
                if (vector instanceof IntVector) {
                    int intValue = data.getInt(columnName);
                    FlightSqlExample.saveToVector(data.wasNull() ? null : Integer.valueOf(intValue), (IntVector)vector, rows);
                    continue;
                }
                if (vector instanceof UInt1Vector) {
                    byte byteValue = data.getByte(columnName);
                    FlightSqlExample.saveToVector(data.wasNull() ? null : Byte.valueOf(byteValue), (UInt1Vector)vector, rows);
                    continue;
                }
                if (vector instanceof BitVector) {
                    byte byteValue = data.getByte(columnName);
                    FlightSqlExample.saveToVector(data.wasNull() ? null : Byte.valueOf(byteValue), (BitVector)vector, rows);
                    continue;
                }
                if (vector instanceof ListVector) {
                    String createParamsValues = data.getString(columnName);
                    UnionListWriter writer = ((ListVector)vector).getWriter();
                    BufferAllocator allocator = vector.getAllocator();
                    ArrowBuf buf = allocator.buffer(1024L);
                    writer.setPosition(rows);
                    writer.startList();
                    if (createParamsValues != null) {
                        String[] split = createParamsValues.split(",");
                        IntStream.range(0, split.length).forEach(i -> {
                            byte[] bytes = split[i].getBytes(StandardCharsets.UTF_8);
                            Preconditions.checkState((bytes.length < 1024 ? 1 : 0) != 0, (Object)"The amount of bytes is greater than what the ArrowBuf supports");
                            buf.setBytes(0L, bytes);
                            writer.varChar().writeVarChar(0, bytes.length, buf);
                        });
                    }
                    buf.close();
                    writer.endList();
                    continue;
                }
                throw CallStatus.INVALID_ARGUMENT.withDescription("Provided vector not supported").toRuntimeException();
            }
            ++rows;
        }
        for (Map.Entry<T, String> vectorToColumn : entrySet) {
            ((FieldVector)vectorToColumn.getKey()).setValueCount(rows);
        }
        return rows;
    }

    private static <T extends FieldVector> void saveToVectors(Map<T, String> vectorToColumnName, ResultSet data) throws SQLException {
        FlightSqlExample.saveToVectors(vectorToColumnName, data, false);
    }

    private static VectorSchemaRoot getTableTypesRoot(ResultSet data, BufferAllocator allocator) throws SQLException {
        return FlightSqlExample.getRoot(data, allocator, "table_type", "TABLE_TYPE");
    }

    private static VectorSchemaRoot getCatalogsRoot(ResultSet data, BufferAllocator allocator) throws SQLException {
        return FlightSqlExample.getRoot(data, allocator, "catalog_name", "TABLE_CATALOG");
    }

    private static VectorSchemaRoot getRoot(ResultSet data, BufferAllocator allocator, String fieldVectorName, String columnName) throws SQLException {
        VarCharVector dataVector = new VarCharVector(fieldVectorName, FieldType.notNullable((ArrowType)Types.MinorType.VARCHAR.getType()), allocator);
        FlightSqlExample.saveToVectors(ImmutableMap.of((Object)dataVector, (Object)columnName), data);
        int rows = dataVector.getValueCount();
        dataVector.setValueCount(rows);
        return new VectorSchemaRoot(Collections.singletonList(dataVector));
    }

    private static VectorSchemaRoot getTypeInfoRoot(FlightSql.CommandGetXdbcTypeInfo request, ResultSet typeInfo, BufferAllocator allocator) throws SQLException {
        Preconditions.checkNotNull((Object)allocator, (Object)"BufferAllocator cannot be null.");
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)FlightSqlProducer.Schemas.GET_TYPE_INFO_SCHEMA, (BufferAllocator)allocator);
        HashMap<FieldVector, String> mapper = new HashMap<FieldVector, String>();
        mapper.put(root.getVector("type_name"), "TYPE_NAME");
        mapper.put(root.getVector("data_type"), "DATA_TYPE");
        mapper.put(root.getVector("column_size"), "PRECISION");
        mapper.put(root.getVector("literal_prefix"), "LITERAL_PREFIX");
        mapper.put(root.getVector("literal_suffix"), "LITERAL_SUFFIX");
        mapper.put(root.getVector("create_params"), "CREATE_PARAMS");
        mapper.put(root.getVector("nullable"), "NULLABLE");
        mapper.put(root.getVector("case_sensitive"), "CASE_SENSITIVE");
        mapper.put(root.getVector("searchable"), "SEARCHABLE");
        mapper.put(root.getVector("unsigned_attribute"), "UNSIGNED_ATTRIBUTE");
        mapper.put(root.getVector("fixed_prec_scale"), "FIXED_PREC_SCALE");
        mapper.put(root.getVector("auto_increment"), "AUTO_INCREMENT");
        mapper.put(root.getVector("local_type_name"), "LOCAL_TYPE_NAME");
        mapper.put(root.getVector("minimum_scale"), "MINIMUM_SCALE");
        mapper.put(root.getVector("maximum_scale"), "MAXIMUM_SCALE");
        mapper.put(root.getVector("sql_data_type"), "SQL_DATA_TYPE");
        mapper.put(root.getVector("datetime_subcode"), "SQL_DATETIME_SUB");
        mapper.put(root.getVector("num_prec_radix"), "NUM_PREC_RADIX");
        Predicate<ResultSet> predicate = request.hasDataType() ? resultSet -> {
            try {
                return resultSet.getInt("DATA_TYPE") == request.getDataType();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        } : resultSet -> true;
        int rows = FlightSqlExample.saveToVectors(mapper, typeInfo, true, predicate);
        root.setRowCount(rows);
        return root;
    }

    private static VectorSchemaRoot getTablesRoot(DatabaseMetaData databaseMetaData, BufferAllocator allocator, boolean includeSchema, String catalog, String schemaFilterPattern, String tableFilterPattern, String ... tableTypes) throws SQLException, IOException {
        ArrayList<Object> vectors;
        block14: {
            Objects.requireNonNull(allocator, "BufferAllocator cannot be null.");
            VarCharVector catalogNameVector = new VarCharVector("catalog_name", allocator);
            VarCharVector schemaNameVector = new VarCharVector("db_schema_name", allocator);
            VarCharVector tableNameVector = new VarCharVector("table_name", FieldType.notNullable((ArrowType)Types.MinorType.VARCHAR.getType()), allocator);
            VarCharVector tableTypeVector = new VarCharVector("table_type", FieldType.notNullable((ArrowType)Types.MinorType.VARCHAR.getType()), allocator);
            vectors = new ArrayList<Object>(4);
            vectors.add(catalogNameVector);
            vectors.add(schemaNameVector);
            vectors.add(tableNameVector);
            vectors.add(tableTypeVector);
            vectors.forEach(ValueVector::allocateNew);
            ImmutableMap vectorToColumnName = ImmutableMap.of((Object)catalogNameVector, (Object)"TABLE_CAT", (Object)schemaNameVector, (Object)"TABLE_SCHEM", (Object)tableNameVector, (Object)"TABLE_NAME", (Object)tableTypeVector, (Object)"TABLE_TYPE");
            try (ResultSet data = Objects.requireNonNull(databaseMetaData, String.format("%s cannot be null.", databaseMetaData.getClass().getName())).getTables(catalog, schemaFilterPattern, tableFilterPattern, tableTypes);){
                FlightSqlExample.saveToVectors(vectorToColumnName, data, true);
                int rows = vectors.stream().map(ValueVector::getValueCount).findAny().orElseThrow(IllegalStateException::new);
                vectors.forEach(vector -> vector.setValueCount(rows));
                if (!includeSchema) break block14;
                VarBinaryVector tableSchemaVector = new VarBinaryVector("table_schema", FieldType.notNullable((ArrowType)Types.MinorType.VARBINARY.getType()), allocator);
                tableSchemaVector.allocateNew(rows);
                try (ResultSet columnsData = databaseMetaData.getColumns(catalog, schemaFilterPattern, tableFilterPattern, null);){
                    HashMap<String, List> tableToFields = new HashMap<String, List>();
                    while (columnsData.next()) {
                        String catalogName = columnsData.getString("TABLE_CAT");
                        String schemaName = columnsData.getString("TABLE_SCHEM");
                        String tableName = columnsData.getString("TABLE_NAME");
                        String typeName = columnsData.getString("TYPE_NAME");
                        String fieldName = columnsData.getString("COLUMN_NAME");
                        int dataType = columnsData.getInt("DATA_TYPE");
                        boolean isNullable = columnsData.getInt("NULLABLE") != 0;
                        int precision = columnsData.getInt("COLUMN_SIZE");
                        int scale = columnsData.getInt("DECIMAL_DIGITS");
                        boolean isAutoIncrement = Objects.equals(columnsData.getString("IS_AUTOINCREMENT"), "YES");
                        List fields = tableToFields.computeIfAbsent(tableName, tableName_ -> new ArrayList());
                        FlightSqlColumnMetadata columnMetadata = new FlightSqlColumnMetadata.Builder().catalogName(catalogName).schemaName(schemaName).tableName(tableName).typeName(typeName).precision(precision).scale(scale).isAutoIncrement(isAutoIncrement).build();
                        Field field = new Field(fieldName, new FieldType(isNullable, FlightSqlExample.getArrowTypeFromJdbcType(dataType, precision, scale), null, columnMetadata.getMetadataMap()), null);
                        fields.add(field);
                    }
                    for (int index = 0; index < rows; ++index) {
                        String tableName = tableNameVector.getObject(index).toString();
                        Schema schema = new Schema((Iterable)tableToFields.get(tableName));
                        FlightSqlExample.saveToVector(ByteString.copyFrom((ByteBuffer)FlightSqlExample.serializeMetadata(schema)).toByteArray(), tableSchemaVector, index);
                    }
                }
                tableSchemaVector.setValueCount(rows);
                vectors.add(tableSchemaVector);
            }
        }
        return new VectorSchemaRoot(vectors);
    }

    private static ByteBuffer serializeMetadata(Schema schema) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(outputStream)), (Schema)schema);
            return ByteBuffer.wrap(outputStream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize schema", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        ByteString handle = command.getPreparedStatementHandle();
        StatementContext statementContext = (StatementContext)this.preparedStatementLoadingCache.getIfPresent((Object)handle);
        Objects.requireNonNull(statementContext);
        PreparedStatement statement = (PreparedStatement)statementContext.getStatement();
        try (ResultSet resultSet = statement.executeQuery();){
            Schema schema = JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)resultSet.getMetaData(), (Calendar)DEFAULT_CALENDAR);
            try (VectorSchemaRoot vectorSchemaRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.rootAllocator);){
                VectorSchemaRoot batch;
                VectorLoader loader = new VectorLoader(vectorSchemaRoot);
                listener.start(vectorSchemaRoot);
                ArrowVectorIterator iterator = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)resultSet, (BufferAllocator)this.rootAllocator);
                while (iterator.hasNext() && (batch = iterator.next()).getRowCount() != 0) {
                    VectorUnloader unloader = new VectorUnloader(batch);
                    loader.load(unloader.getRecordBatch());
                    listener.putNext();
                    vectorSchemaRoot.clear();
                }
                listener.putNext();
            }
        }
        catch (IOException | SQLException e) {
            LOGGER.error(String.format("Failed to getStreamPreparedStatement: <%s>.", e.getMessage()), (Throwable)e);
            listener.error((Throwable)CallStatus.INTERNAL.withDescription("Failed to prepare statement: " + e).toRuntimeException());
        }
        finally {
            listener.completed();
        }
    }

    public void closePreparedStatement(FlightSql.ActionClosePreparedStatementRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        this.executorService.submit(() -> {
            try {
                this.preparedStatementLoadingCache.invalidate((Object)request.getPreparedStatementHandle());
            }
            catch (Exception e) {
                listener.onError((Throwable)e);
                return;
            }
            listener.onCompleted();
        });
    }

    public FlightInfo getFlightInfoStatement(FlightSql.CommandStatementQuery request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        ByteString handle = ByteString.copyFrom((byte[])UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
        try {
            Connection connection = this.dataSource.getConnection();
            Statement statement = connection.createStatement(1004, 1007);
            String query = request.getQuery();
            StatementContext<Statement> statementContext = new StatementContext<Statement>(statement, query);
            this.statementLoadingCache.put((Object)handle, statementContext);
            ResultSet resultSet = statement.executeQuery(query);
            FlightSql.TicketStatementQuery ticket = FlightSql.TicketStatementQuery.newBuilder().setStatementHandle(handle).build();
            return this.getFlightInfoForSchema(ticket, descriptor, JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)resultSet.getMetaData(), (Calendar)DEFAULT_CALENDAR));
        }
        catch (SQLException e) {
            LOGGER.error(String.format("There was a problem executing the prepared statement: <%s>.", e.getMessage()), (Throwable)e);
            throw CallStatus.INTERNAL.withCause((Throwable)e).toRuntimeException();
        }
    }

    public FlightInfo getFlightInfoPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        ByteString preparedStatementHandle = command.getPreparedStatementHandle();
        StatementContext statementContext = (StatementContext)this.preparedStatementLoadingCache.getIfPresent((Object)preparedStatementHandle);
        try {
            assert (statementContext != null);
            PreparedStatement statement = (PreparedStatement)statementContext.getStatement();
            ResultSetMetaData metaData = statement.getMetaData();
            return this.getFlightInfoForSchema(command, descriptor, JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)metaData, (Calendar)DEFAULT_CALENDAR));
        }
        catch (SQLException e) {
            LOGGER.error(String.format("There was a problem executing the prepared statement: <%s>.", e.getMessage()), (Throwable)e);
            throw CallStatus.INTERNAL.withCause((Throwable)e).toRuntimeException();
        }
    }

    public SchemaResult getSchemaStatement(FlightSql.CommandStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        throw CallStatus.UNIMPLEMENTED.toRuntimeException();
    }

    @Override
    public void close() throws Exception {
        try {
            this.preparedStatementLoadingCache.cleanUp();
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Failed to close resources: <%s>", t.getMessage()), t);
        }
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.dataSource, this.rootAllocator});
    }

    public void listFlights(FlightProducer.CallContext context, Criteria criteria, FlightProducer.StreamListener<FlightInfo> listener) {
        throw CallStatus.UNIMPLEMENTED.toRuntimeException();
    }

    public void createPreparedStatement(FlightSql.ActionCreatePreparedStatementRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        this.executorService.submit(() -> {
            try {
                ByteString preparedStatementHandle = ByteString.copyFrom((byte[])UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
                Connection connection = this.dataSource.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement(request.getQuery(), 1004, 1007);
                StatementContext<PreparedStatement> preparedStatementContext = new StatementContext<PreparedStatement>(preparedStatement, request.getQuery());
                this.preparedStatementLoadingCache.put((Object)preparedStatementHandle, preparedStatementContext);
                Schema parameterSchema = JdbcToArrowUtils.jdbcToArrowSchema((ParameterMetaData)preparedStatement.getParameterMetaData(), (Calendar)DEFAULT_CALENDAR);
                ResultSetMetaData metaData = preparedStatement.getMetaData();
                ByteString bytes = Objects.isNull(metaData) ? ByteString.EMPTY : ByteString.copyFrom((ByteBuffer)FlightSqlExample.serializeMetadata(JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)metaData, (Calendar)DEFAULT_CALENDAR)));
                FlightSql.ActionCreatePreparedStatementResult result = FlightSql.ActionCreatePreparedStatementResult.newBuilder().setDatasetSchema(bytes).setParameterSchema(ByteString.copyFrom((ByteBuffer)FlightSqlExample.serializeMetadata(parameterSchema))).setPreparedStatementHandle(preparedStatementHandle).build();
                listener.onNext((Object)new Result(Any.pack((Message)result).toByteArray()));
            }
            catch (SQLException e) {
                listener.onError((Throwable)CallStatus.INTERNAL.withDescription("Failed to create prepared statement: " + e).toRuntimeException());
                return;
            }
            catch (Throwable t) {
                listener.onError((Throwable)CallStatus.INTERNAL.withDescription("Unknown error: " + t).toRuntimeException());
                return;
            }
            listener.onCompleted();
        });
    }

    public void doExchange(FlightProducer.CallContext context, FlightStream reader, FlightProducer.ServerStreamListener writer) {
        throw CallStatus.UNIMPLEMENTED.toRuntimeException();
    }

    public Runnable acceptPutStatement(FlightSql.CommandStatementUpdate command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        String query = command.getQuery();
        return () -> {
            try {
                Connection connection = this.dataSource.getConnection();
                Throwable throwable = null;
                try {
                    Statement statement = connection.createStatement();
                    Throwable throwable2 = null;
                    try {
                        int result = statement.executeUpdate(query);
                        FlightSql.DoPutUpdateResult build = FlightSql.DoPutUpdateResult.newBuilder().setRecordCount((long)result).build();
                        ArrowBuf buffer = this.rootAllocator.buffer((long)build.getSerializedSize());
                        Throwable throwable3 = null;
                        try {
                            buffer.writeBytes(build.toByteArray());
                            ackStream.onNext((Object)PutResult.metadata((ArrowBuf)buffer));
                            ackStream.onCompleted();
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (buffer != null) {
                                FlightSqlExample.$closeResource(throwable3, (AutoCloseable)buffer);
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (statement != null) {
                            FlightSqlExample.$closeResource(throwable2, statement);
                        }
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (connection != null) {
                        FlightSqlExample.$closeResource(throwable, connection);
                    }
                }
            }
            catch (SQLSyntaxErrorException e) {
                ackStream.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Failed to execute statement (invalid syntax): " + e).toRuntimeException());
            }
            catch (SQLException e) {
                ackStream.onError((Throwable)CallStatus.INTERNAL.withDescription("Failed to execute statement: " + e).toRuntimeException());
            }
        };
    }

    public Runnable acceptPutPreparedStatementUpdate(FlightSql.CommandPreparedStatementUpdate command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        StatementContext statement = (StatementContext)this.preparedStatementLoadingCache.getIfPresent((Object)command.getPreparedStatementHandle());
        return () -> {
            if (statement == null) {
                ackStream.onError((Throwable)CallStatus.NOT_FOUND.withDescription("Prepared statement does not exist").toRuntimeException());
                return;
            }
            try {
                PreparedStatement preparedStatement = (PreparedStatement)statement.getStatement();
                while (flightStream.next()) {
                    int recordCount;
                    VectorSchemaRoot root = flightStream.getRoot();
                    int rowCount = root.getRowCount();
                    if (rowCount == 0) {
                        preparedStatement.execute();
                        recordCount = preparedStatement.getUpdateCount();
                    } else {
                        JdbcParameterBinder binder = JdbcParameterBinder.builder((PreparedStatement)preparedStatement, (VectorSchemaRoot)root).bindAll().build();
                        while (binder.next()) {
                            preparedStatement.addBatch();
                        }
                        int[] recordCounts = preparedStatement.executeBatch();
                        recordCount = Arrays.stream(recordCounts).sum();
                    }
                    FlightSql.DoPutUpdateResult build = FlightSql.DoPutUpdateResult.newBuilder().setRecordCount((long)recordCount).build();
                    ArrowBuf buffer = this.rootAllocator.buffer((long)build.getSerializedSize());
                    Throwable throwable = null;
                    try {
                        buffer.writeBytes(build.toByteArray());
                        ackStream.onNext((Object)PutResult.metadata((ArrowBuf)buffer));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (buffer == null) continue;
                        FlightSqlExample.$closeResource(throwable, (AutoCloseable)buffer);
                    }
                }
            }
            catch (SQLException e) {
                ackStream.onError((Throwable)CallStatus.INTERNAL.withDescription("Failed to execute update: " + e).toRuntimeException());
                return;
            }
            ackStream.onCompleted();
        };
    }

    public Runnable acceptPutPreparedStatementQuery(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        StatementContext statementContext = (StatementContext)this.preparedStatementLoadingCache.getIfPresent((Object)command.getPreparedStatementHandle());
        return () -> {
            assert (statementContext != null);
            PreparedStatement preparedStatement = (PreparedStatement)statementContext.getStatement();
            try {
                while (flightStream.next()) {
                    VectorSchemaRoot root = flightStream.getRoot();
                    JdbcParameterBinder binder = JdbcParameterBinder.builder((PreparedStatement)preparedStatement, (VectorSchemaRoot)root).bindAll().build();
                    while (binder.next()) {
                    }
                }
            }
            catch (SQLException e) {
                ackStream.onError((Throwable)CallStatus.INTERNAL.withDescription("Failed to bind parameters: " + e.getMessage()).withCause((Throwable)e).toRuntimeException());
                return;
            }
            ackStream.onCompleted();
        };
    }

    public FlightInfo getFlightInfoSqlInfo(FlightSql.CommandGetSqlInfo request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA);
    }

    public void getStreamSqlInfo(FlightSql.CommandGetSqlInfo command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        this.sqlInfoBuilder.send(command.getInfoList(), listener);
    }

    public FlightInfo getFlightInfoTypeInfo(FlightSql.CommandGetXdbcTypeInfo request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_TYPE_INFO_SCHEMA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamTypeInfo(FlightSql.CommandGetXdbcTypeInfo request, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        try (Connection connection = this.dataSource.getConnection();
             ResultSet typeInfo = connection.getMetaData().getTypeInfo();
             VectorSchemaRoot vectorSchemaRoot = FlightSqlExample.getTypeInfoRoot(request, typeInfo, this.rootAllocator);){
            listener.start(vectorSchemaRoot);
            listener.putNext();
        }
        catch (SQLException e) {
            LOGGER.error(String.format("Failed to getStreamCatalogs: <%s>.", e.getMessage()), (Throwable)e);
            listener.error((Throwable)e);
        }
        finally {
            listener.completed();
        }
    }

    public FlightInfo getFlightInfoCatalogs(FlightSql.CommandGetCatalogs request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamCatalogs(FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        try (Connection connection = this.dataSource.getConnection();
             ResultSet catalogs = connection.getMetaData().getCatalogs();
             VectorSchemaRoot vectorSchemaRoot = FlightSqlExample.getCatalogsRoot(catalogs, this.rootAllocator);){
            listener.start(vectorSchemaRoot);
            listener.putNext();
        }
        catch (SQLException e) {
            LOGGER.error(String.format("Failed to getStreamCatalogs: <%s>.", e.getMessage()), (Throwable)e);
            listener.error((Throwable)e);
        }
        finally {
            listener.completed();
        }
    }

    public FlightInfo getFlightInfoSchemas(FlightSql.CommandGetDbSchemas request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamSchemas(FlightSql.CommandGetDbSchemas command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        String catalog = command.hasCatalog() ? command.getCatalog() : null;
        String schemaFilterPattern = command.hasDbSchemaFilterPattern() ? command.getDbSchemaFilterPattern() : null;
        try (Connection connection = this.dataSource.getConnection();
             ResultSet schemas = connection.getMetaData().getSchemas(catalog, schemaFilterPattern);
             VectorSchemaRoot vectorSchemaRoot = FlightSqlExample.getSchemasRoot(schemas, this.rootAllocator);){
            listener.start(vectorSchemaRoot);
            listener.putNext();
        }
        catch (SQLException e) {
            LOGGER.error(String.format("Failed to getStreamSchemas: <%s>.", e.getMessage()), (Throwable)e);
            listener.error((Throwable)e);
        }
        finally {
            listener.completed();
        }
    }

    public FlightInfo getFlightInfoTables(FlightSql.CommandGetTables request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        Schema schemaToUse = FlightSqlProducer.Schemas.GET_TABLES_SCHEMA;
        if (!request.getIncludeSchema()) {
            schemaToUse = FlightSqlProducer.Schemas.GET_TABLES_SCHEMA_NO_SCHEMA;
        }
        return this.getFlightInfoForSchema(request, descriptor, schemaToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamTables(FlightSql.CommandGetTables command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        String catalog = command.hasCatalog() ? command.getCatalog() : null;
        String schemaFilterPattern = command.hasDbSchemaFilterPattern() ? command.getDbSchemaFilterPattern() : null;
        String tableFilterPattern = command.hasTableNameFilterPattern() ? command.getTableNameFilterPattern() : null;
        ProtocolStringList protocolStringList = command.getTableTypesList();
        int protocolSize = protocolStringList.size();
        String[] tableTypes = protocolSize == 0 ? null : (String[])protocolStringList.toArray((Object[])new String[protocolSize]);
        try (Connection connection = DriverManager.getConnection(DATABASE_URI);
             VectorSchemaRoot vectorSchemaRoot = FlightSqlExample.getTablesRoot(connection.getMetaData(), this.rootAllocator, command.getIncludeSchema(), catalog, schemaFilterPattern, tableFilterPattern, tableTypes);){
            listener.start(vectorSchemaRoot);
            listener.putNext();
        }
        catch (IOException | SQLException e) {
            LOGGER.error(String.format("Failed to getStreamTables: <%s>.", e.getMessage()), (Throwable)e);
            listener.error((Throwable)e);
        }
        finally {
            listener.completed();
        }
    }

    public FlightInfo getFlightInfoTableTypes(FlightSql.CommandGetTableTypes request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamTableTypes(FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        try (Connection connection = this.dataSource.getConnection();
             ResultSet tableTypes = connection.getMetaData().getTableTypes();
             VectorSchemaRoot vectorSchemaRoot = FlightSqlExample.getTableTypesRoot(tableTypes, this.rootAllocator);){
            listener.start(vectorSchemaRoot);
            listener.putNext();
        }
        catch (SQLException e) {
            LOGGER.error(String.format("Failed to getStreamTableTypes: <%s>.", e.getMessage()), (Throwable)e);
            listener.error((Throwable)e);
        }
        finally {
            listener.completed();
        }
    }

    public FlightInfo getFlightInfoPrimaryKeys(FlightSql.CommandGetPrimaryKeys request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_PRIMARY_KEYS_SCHEMA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamPrimaryKeys(FlightSql.CommandGetPrimaryKeys command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        String catalog = command.hasCatalog() ? command.getCatalog() : null;
        String schema = command.hasDbSchema() ? command.getDbSchema() : null;
        String table = command.getTable();
        try (Connection connection = DriverManager.getConnection(DATABASE_URI);){
            ResultSet primaryKeys = connection.getMetaData().getPrimaryKeys(catalog, schema, table);
            VarCharVector catalogNameVector = new VarCharVector("catalog_name", this.rootAllocator);
            VarCharVector schemaNameVector = new VarCharVector("db_schema_name", this.rootAllocator);
            VarCharVector tableNameVector = new VarCharVector("table_name", this.rootAllocator);
            VarCharVector columnNameVector = new VarCharVector("column_name", this.rootAllocator);
            IntVector keySequenceVector = new IntVector("key_sequence", this.rootAllocator);
            VarCharVector keyNameVector = new VarCharVector("key_name", this.rootAllocator);
            ArrayList vectors = new ArrayList(ImmutableList.of((Object)catalogNameVector, (Object)schemaNameVector, (Object)tableNameVector, (Object)columnNameVector, (Object)keySequenceVector, (Object)keyNameVector));
            vectors.forEach(ValueVector::allocateNew);
            int rows = 0;
            while (primaryKeys.next()) {
                FlightSqlExample.saveToVector(primaryKeys.getString("TABLE_CAT"), catalogNameVector, rows);
                FlightSqlExample.saveToVector(primaryKeys.getString("TABLE_SCHEM"), schemaNameVector, rows);
                FlightSqlExample.saveToVector(primaryKeys.getString("TABLE_NAME"), tableNameVector, rows);
                FlightSqlExample.saveToVector(primaryKeys.getString("COLUMN_NAME"), columnNameVector, rows);
                int key_seq = primaryKeys.getInt("KEY_SEQ");
                FlightSqlExample.saveToVector(primaryKeys.wasNull() ? null : Integer.valueOf(key_seq), keySequenceVector, rows);
                FlightSqlExample.saveToVector(primaryKeys.getString("PK_NAME"), keyNameVector, rows);
                ++rows;
            }
            try (VectorSchemaRoot vectorSchemaRoot = new VectorSchemaRoot(vectors);){
                vectorSchemaRoot.setRowCount(rows);
                listener.start(vectorSchemaRoot);
                listener.putNext();
            }
        }
        catch (SQLException e) {
            listener.error((Throwable)e);
        }
        finally {
            listener.completed();
        }
    }

    public FlightInfo getFlightInfoExportedKeys(FlightSql.CommandGetExportedKeys request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_EXPORTED_KEYS_SCHEMA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamExportedKeys(FlightSql.CommandGetExportedKeys command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        String catalog = command.hasCatalog() ? command.getCatalog() : null;
        String schema = command.hasDbSchema() ? command.getDbSchema() : null;
        String table = command.getTable();
        try (Connection connection = DriverManager.getConnection(DATABASE_URI);
             ResultSet keys = connection.getMetaData().getExportedKeys(catalog, schema, table);
             VectorSchemaRoot vectorSchemaRoot = this.createVectors(keys);){
            listener.start(vectorSchemaRoot);
            listener.putNext();
        }
        catch (SQLException e) {
            listener.error((Throwable)e);
        }
        finally {
            listener.completed();
        }
    }

    public FlightInfo getFlightInfoImportedKeys(FlightSql.CommandGetImportedKeys request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_IMPORTED_KEYS_SCHEMA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamImportedKeys(FlightSql.CommandGetImportedKeys command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        String catalog = command.hasCatalog() ? command.getCatalog() : null;
        String schema = command.hasDbSchema() ? command.getDbSchema() : null;
        String table = command.getTable();
        try (Connection connection = DriverManager.getConnection(DATABASE_URI);
             ResultSet keys = connection.getMetaData().getImportedKeys(catalog, schema, table);
             VectorSchemaRoot vectorSchemaRoot = this.createVectors(keys);){
            listener.start(vectorSchemaRoot);
            listener.putNext();
        }
        catch (SQLException e) {
            listener.error((Throwable)e);
        }
        finally {
            listener.completed();
        }
    }

    public FlightInfo getFlightInfoCrossReference(FlightSql.CommandGetCrossReference request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfoForSchema(request, descriptor, FlightSqlProducer.Schemas.GET_CROSS_REFERENCE_SCHEMA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamCrossReference(FlightSql.CommandGetCrossReference command, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        String pkCatalog = command.hasPkCatalog() ? command.getPkCatalog() : null;
        String pkSchema = command.hasPkDbSchema() ? command.getPkDbSchema() : null;
        String fkCatalog = command.hasFkCatalog() ? command.getFkCatalog() : null;
        String fkSchema = command.hasFkDbSchema() ? command.getFkDbSchema() : null;
        String pkTable = command.getPkTable();
        String fkTable = command.getFkTable();
        try (Connection connection = DriverManager.getConnection(DATABASE_URI);
             ResultSet keys = connection.getMetaData().getCrossReference(pkCatalog, pkSchema, pkTable, fkCatalog, fkSchema, fkTable);
             VectorSchemaRoot vectorSchemaRoot = this.createVectors(keys);){
            listener.start(vectorSchemaRoot);
            listener.putNext();
        }
        catch (SQLException e) {
            listener.error((Throwable)e);
        }
        finally {
            listener.completed();
        }
    }

    private VectorSchemaRoot createVectors(ResultSet keys) throws SQLException {
        VarCharVector pkCatalogNameVector = new VarCharVector("pk_catalog_name", this.rootAllocator);
        VarCharVector pkSchemaNameVector = new VarCharVector("pk_db_schema_name", this.rootAllocator);
        VarCharVector pkTableNameVector = new VarCharVector("pk_table_name", this.rootAllocator);
        VarCharVector pkColumnNameVector = new VarCharVector("pk_column_name", this.rootAllocator);
        VarCharVector fkCatalogNameVector = new VarCharVector("fk_catalog_name", this.rootAllocator);
        VarCharVector fkSchemaNameVector = new VarCharVector("fk_db_schema_name", this.rootAllocator);
        VarCharVector fkTableNameVector = new VarCharVector("fk_table_name", this.rootAllocator);
        VarCharVector fkColumnNameVector = new VarCharVector("fk_column_name", this.rootAllocator);
        IntVector keySequenceVector = new IntVector("key_sequence", this.rootAllocator);
        VarCharVector fkKeyNameVector = new VarCharVector("fk_key_name", this.rootAllocator);
        VarCharVector pkKeyNameVector = new VarCharVector("pk_key_name", this.rootAllocator);
        UInt1Vector updateRuleVector = new UInt1Vector("update_rule", this.rootAllocator);
        UInt1Vector deleteRuleVector = new UInt1Vector("delete_rule", this.rootAllocator);
        HashMap<Object, String> vectorToColumnName = new HashMap<Object, String>();
        vectorToColumnName.put(pkCatalogNameVector, "PKTABLE_CAT");
        vectorToColumnName.put(pkSchemaNameVector, "PKTABLE_SCHEM");
        vectorToColumnName.put(pkTableNameVector, "PKTABLE_NAME");
        vectorToColumnName.put(pkColumnNameVector, "PKCOLUMN_NAME");
        vectorToColumnName.put(fkCatalogNameVector, "FKTABLE_CAT");
        vectorToColumnName.put(fkSchemaNameVector, "FKTABLE_SCHEM");
        vectorToColumnName.put(fkTableNameVector, "FKTABLE_NAME");
        vectorToColumnName.put(fkColumnNameVector, "FKCOLUMN_NAME");
        vectorToColumnName.put(keySequenceVector, "KEY_SEQ");
        vectorToColumnName.put(updateRuleVector, "UPDATE_RULE");
        vectorToColumnName.put(deleteRuleVector, "DELETE_RULE");
        vectorToColumnName.put(fkKeyNameVector, "FK_NAME");
        vectorToColumnName.put(pkKeyNameVector, "PK_NAME");
        VectorSchemaRoot vectorSchemaRoot = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{pkCatalogNameVector, pkSchemaNameVector, pkTableNameVector, pkColumnNameVector, fkCatalogNameVector, fkSchemaNameVector, fkTableNameVector, fkColumnNameVector, keySequenceVector, fkKeyNameVector, pkKeyNameVector, updateRuleVector, deleteRuleVector});
        vectorSchemaRoot.allocateNew();
        int rowCount = FlightSqlExample.saveToVectors(vectorToColumnName, keys, true);
        vectorSchemaRoot.setRowCount(rowCount);
        return vectorSchemaRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamStatement(FlightSql.TicketStatementQuery ticketStatementQuery, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        ByteString handle = ticketStatementQuery.getStatementHandle();
        StatementContext statementContext = Objects.requireNonNull((StatementContext)this.statementLoadingCache.getIfPresent((Object)handle));
        try (ResultSet resultSet = statementContext.getStatement().getResultSet();){
            Schema schema = JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)resultSet.getMetaData(), (Calendar)DEFAULT_CALENDAR);
            try (VectorSchemaRoot vectorSchemaRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.rootAllocator);){
                VectorLoader loader = new VectorLoader(vectorSchemaRoot);
                listener.start(vectorSchemaRoot);
                ArrowVectorIterator iterator = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)resultSet, (BufferAllocator)this.rootAllocator);
                while (iterator.hasNext()) {
                    VectorUnloader unloader = new VectorUnloader(iterator.next());
                    loader.load(unloader.getRecordBatch());
                    listener.putNext();
                    vectorSchemaRoot.clear();
                }
                listener.putNext();
            }
        }
        catch (IOException | SQLException e) {
            LOGGER.error(String.format("Failed to getStreamPreparedStatement: <%s>.", e.getMessage()), (Throwable)e);
            listener.error((Throwable)e);
        }
        finally {
            listener.completed();
            this.statementLoadingCache.invalidate((Object)handle);
        }
    }

    private <T extends Message> FlightInfo getFlightInfoForSchema(T request, FlightDescriptor descriptor, Schema schema) {
        Ticket ticket = new Ticket(Any.pack(request).toByteArray());
        List<FlightEndpoint> endpoints = Collections.singletonList(new FlightEndpoint(ticket, new Location[]{this.location}));
        return new FlightInfo(schema, descriptor, endpoints, -1L, -1L);
    }

    private static class StatementRemovalListener<T extends Statement>
    implements RemovalListener<ByteString, StatementContext<T>> {
        private StatementRemovalListener() {
        }

        public void onRemoval(RemovalNotification<ByteString, StatementContext<T>> notification) {
            try {
                AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{(AutoCloseable)notification.getValue()});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

