/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CancelFlightInfoRequest;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightStatusCode;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.RenewFlightEndpointRequest;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.flight.sql.FlightSqlColumnMetadata;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.example.FlightSqlExample;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.flight.sql.util.TableRef;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class TestFlightSql {
    protected static final Schema SCHEMA_INT_TABLE = new Schema(Arrays.asList(new Field("ID", new FieldType(false, Types.MinorType.INT.getType(), null), null), Field.nullable((String)"KEYNAME", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"VALUE", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"FOREIGNID", (ArrowType)Types.MinorType.INT.getType())));
    private static final List<List<String>> EXPECTED_RESULTS_FOR_STAR_SELECT_QUERY = ImmutableList.of(Arrays.asList("1", "one", "1", "1"), Arrays.asList("2", "zero", "0", "1"), Arrays.asList("3", "negative one", "-1", "1"));
    private static final List<List<String>> EXPECTED_RESULTS_FOR_PARAMETER_BINDING = ImmutableList.of(Arrays.asList("1", "one", "1", "1"));
    private static final Map<String, String> GET_SQL_INFO_EXPECTED_RESULTS_MAP = new LinkedHashMap<String, String>();
    private static final String LOCALHOST = "localhost";
    private static BufferAllocator allocator;
    private static FlightServer server;
    private static FlightSqlClient sqlClient;

    @BeforeAll
    public static void setUp() throws Exception {
        allocator = new RootAllocator(Integer.MAX_VALUE);
        Location serverLocation = Location.forGrpcInsecure((String)LOCALHOST, (int)0);
        server = FlightServer.builder((BufferAllocator)allocator, (Location)serverLocation, (FlightProducer)new FlightSqlExample(serverLocation)).build().start();
        Location clientLocation = Location.forGrpcInsecure((String)LOCALHOST, (int)server.getPort());
        sqlClient = new FlightSqlClient(FlightClient.builder((BufferAllocator)allocator, (Location)clientLocation).build());
        GET_SQL_INFO_EXPECTED_RESULTS_MAP.put(Integer.toString(0), "Apache Derby");
        GET_SQL_INFO_EXPECTED_RESULTS_MAP.put(Integer.toString(1), "10.14.2.0 - (1828579)");
        GET_SQL_INFO_EXPECTED_RESULTS_MAP.put(Integer.toString(2), "10.14.2.0 - (1828579)");
        GET_SQL_INFO_EXPECTED_RESULTS_MAP.put(Integer.toString(3), "false");
        GET_SQL_INFO_EXPECTED_RESULTS_MAP.put(Integer.toString(500), "false");
        GET_SQL_INFO_EXPECTED_RESULTS_MAP.put(Integer.toString(501), "true");
        GET_SQL_INFO_EXPECTED_RESULTS_MAP.put(Integer.toString(502), "true");
        GET_SQL_INFO_EXPECTED_RESULTS_MAP.put(Integer.toString(503), Integer.toString(2));
        GET_SQL_INFO_EXPECTED_RESULTS_MAP.put(Integer.toString(504), "\"");
        GET_SQL_INFO_EXPECTED_RESULTS_MAP.put(Integer.toString(505), Integer.toString(1));
    }

    @AfterAll
    public static void tearDown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{sqlClient, server, allocator});
    }

    private static List<List<String>> getNonConformingResultsForGetSqlInfo(List<? extends List<String>> results) {
        return TestFlightSql.getNonConformingResultsForGetSqlInfo(results, FlightSql.SqlInfo.FLIGHT_SQL_SERVER_NAME, FlightSql.SqlInfo.FLIGHT_SQL_SERVER_VERSION, FlightSql.SqlInfo.FLIGHT_SQL_SERVER_ARROW_VERSION, FlightSql.SqlInfo.FLIGHT_SQL_SERVER_READ_ONLY, FlightSql.SqlInfo.SQL_DDL_CATALOG, FlightSql.SqlInfo.SQL_DDL_SCHEMA, FlightSql.SqlInfo.SQL_DDL_TABLE, FlightSql.SqlInfo.SQL_IDENTIFIER_CASE, FlightSql.SqlInfo.SQL_IDENTIFIER_QUOTE_CHAR, FlightSql.SqlInfo.SQL_QUOTED_IDENTIFIER_CASE);
    }

    private static List<List<String>> getNonConformingResultsForGetSqlInfo(List<? extends List<String>> results, FlightSql.SqlInfo ... args) {
        ArrayList<List<String>> nonConformingResults = new ArrayList<List<String>>();
        if (results.size() == args.length) {
            for (int index = 0; index < results.size(); ++index) {
                List<String> result = results.get(index);
                String providedName = result.get(0);
                String expectedName = Integer.toString(args[index].getNumber());
                if (GET_SQL_INFO_EXPECTED_RESULTS_MAP.get(providedName).equals(result.get(1)) && providedName.equals(expectedName)) continue;
                nonConformingResults.add(result);
                break;
            }
        }
        return nonConformingResults;
    }

    @Test
    public void testGetTablesSchema() {
        FlightInfo info = sqlClient.getTables(null, null, null, null, true, new CallOption[0]);
        MatcherAssert.assertThat((Object)info.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_TABLES_SCHEMA));
    }

    @Test
    public void testGetTablesSchemaExcludeSchema() {
        FlightInfo info = sqlClient.getTables(null, null, null, null, false, new CallOption[0]);
        MatcherAssert.assertThat((Object)info.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_TABLES_SCHEMA_NO_SCHEMA));
    }

    @Test
    public void testGetTablesResultNoSchema() throws Exception {
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.getTables(null, null, null, null, false, new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_TABLES_SCHEMA_NO_SCHEMA)), () -> {
                List<List<String>> results = this.getResults(stream);
                ImmutableList expectedResults = ImmutableList.of(Arrays.asList(null, "SYS", "SYSALIASES", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSCHECKS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSCOLPERMS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSCOLUMNS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSCONGLOMERATES", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSCONSTRAINTS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSDEPENDS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSFILES", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSFOREIGNKEYS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSKEYS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSPERMS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSROLES", "SYSTEM TABLE"), (Object[])new List[]{Arrays.asList(null, "SYS", "SYSROUTINEPERMS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSSCHEMAS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSSEQUENCES", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSSTATEMENTS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSSTATISTICS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSTABLEPERMS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSTABLES", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSTRIGGERS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSUSERS", "SYSTEM TABLE"), Arrays.asList(null, "SYS", "SYSVIEWS", "SYSTEM TABLE"), Arrays.asList(null, "SYSIBM", "SYSDUMMY1", "SYSTEM TABLE"), Arrays.asList(null, "APP", "FOREIGNTABLE", "TABLE"), Arrays.asList(null, "APP", "INTTABLE", "TABLE")});
                MatcherAssert.assertThat(results, (Matcher)CoreMatchers.is((Object)expectedResults));
            }});
        }
    }

    @Test
    public void testGetTablesResultFilteredNoSchema() throws Exception {
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.getTables(null, null, null, Collections.singletonList("TABLE"), false, new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_TABLES_SCHEMA_NO_SCHEMA)), () -> {
                List<List<String>> results = this.getResults(stream);
                ImmutableList expectedResults = ImmutableList.of(Arrays.asList(null, "APP", "FOREIGNTABLE", "TABLE"), Arrays.asList(null, "APP", "INTTABLE", "TABLE"));
                MatcherAssert.assertThat(results, (Matcher)CoreMatchers.is((Object)expectedResults));
            }});
        }
    }

    @Test
    public void testGetTablesResultFilteredWithSchema() throws Exception {
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.getTables(null, null, null, Collections.singletonList("TABLE"), true, new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_TABLES_SCHEMA)), () -> {
                MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_TABLES_SCHEMA));
                List<List<String>> results = this.getResults(stream);
                ImmutableList expectedResults = ImmutableList.of(Arrays.asList(null, "APP", "FOREIGNTABLE", "TABLE", new Schema(Arrays.asList(new Field("ID", new FieldType(false, Types.MinorType.INT.getType(), null, new FlightSqlColumnMetadata.Builder().catalogName("").typeName("INTEGER").schemaName("APP").tableName("FOREIGNTABLE").precision(10).scale(0).isAutoIncrement(true).build().getMetadataMap()), null), new Field("FOREIGNNAME", new FieldType(true, Types.MinorType.VARCHAR.getType(), null, new FlightSqlColumnMetadata.Builder().catalogName("").typeName("VARCHAR").schemaName("APP").tableName("FOREIGNTABLE").precision(100).scale(0).isAutoIncrement(false).build().getMetadataMap()), null), new Field("VALUE", new FieldType(true, Types.MinorType.INT.getType(), null, new FlightSqlColumnMetadata.Builder().catalogName("").typeName("INTEGER").schemaName("APP").tableName("FOREIGNTABLE").precision(10).scale(0).isAutoIncrement(false).build().getMetadataMap()), null))).toJson()), Arrays.asList(null, "APP", "INTTABLE", "TABLE", new Schema(Arrays.asList(new Field("ID", new FieldType(false, Types.MinorType.INT.getType(), null, new FlightSqlColumnMetadata.Builder().catalogName("").typeName("INTEGER").schemaName("APP").tableName("INTTABLE").precision(10).scale(0).isAutoIncrement(true).build().getMetadataMap()), null), new Field("KEYNAME", new FieldType(true, Types.MinorType.VARCHAR.getType(), null, new FlightSqlColumnMetadata.Builder().catalogName("").typeName("VARCHAR").schemaName("APP").tableName("INTTABLE").precision(100).scale(0).isAutoIncrement(false).build().getMetadataMap()), null), new Field("VALUE", new FieldType(true, Types.MinorType.INT.getType(), null, new FlightSqlColumnMetadata.Builder().catalogName("").typeName("INTEGER").schemaName("APP").tableName("INTTABLE").precision(10).scale(0).isAutoIncrement(false).build().getMetadataMap()), null), new Field("FOREIGNID", new FieldType(true, Types.MinorType.INT.getType(), null, new FlightSqlColumnMetadata.Builder().catalogName("").typeName("INTEGER").schemaName("APP").tableName("INTTABLE").precision(10).scale(0).isAutoIncrement(false).build().getMetadataMap()), null))).toJson()));
                MatcherAssert.assertThat(results, (Matcher)CoreMatchers.is((Object)expectedResults));
            }});
        }
    }

    @Test
    public void testSimplePreparedStatementSchema() throws Exception {
        try (FlightSqlClient.PreparedStatement preparedStatement = sqlClient.prepare("SELECT * FROM intTable", new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> {
                Schema actualSchema = preparedStatement.getResultSetSchema();
                MatcherAssert.assertThat((Object)actualSchema, (Matcher)CoreMatchers.is((Object)SCHEMA_INT_TABLE));
            }, () -> {
                FlightInfo info = preparedStatement.execute(new CallOption[0]);
                MatcherAssert.assertThat((Object)info.getSchema(), (Matcher)CoreMatchers.is((Object)SCHEMA_INT_TABLE));
            }});
        }
    }

    @Test
    public void testSimplePreparedStatementResults() throws Exception {
        try (FlightSqlClient.PreparedStatement preparedStatement = sqlClient.prepare("SELECT * FROM intTable", new CallOption[0]);
             FlightStream stream = sqlClient.getStream(((FlightEndpoint)preparedStatement.execute(new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)SCHEMA_INT_TABLE)), () -> MatcherAssert.assertThat(this.getResults(stream), (Matcher)CoreMatchers.is(EXPECTED_RESULTS_FOR_STAR_SELECT_QUERY))});
        }
    }

    @Test
    public void testSimplePreparedStatementResultsWithParameterBinding() throws Exception {
        try (FlightSqlClient.PreparedStatement prepare = sqlClient.prepare("SELECT * FROM intTable WHERE id = ?", new CallOption[0]);){
            Schema parameterSchema = prepare.getParameterSchema();
            try (VectorSchemaRoot insertRoot = VectorSchemaRoot.create((Schema)parameterSchema, (BufferAllocator)allocator);){
                insertRoot.allocateNew();
                IntVector valueVector = (IntVector)insertRoot.getVector(0);
                valueVector.setSafe(0, 1);
                insertRoot.setRowCount(1);
                prepare.setParameters(insertRoot);
                FlightInfo flightInfo = prepare.execute(new CallOption[0]);
                FlightStream stream = sqlClient.getStream(((FlightEndpoint)flightInfo.getEndpoints().get(0)).getTicket(), new CallOption[0]);
                Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)SCHEMA_INT_TABLE)), () -> MatcherAssert.assertThat(this.getResults(stream), (Matcher)CoreMatchers.is(EXPECTED_RESULTS_FOR_PARAMETER_BINDING))});
            }
        }
    }

    @Test
    public void testSimplePreparedStatementUpdateResults() throws SQLException {
        try (FlightSqlClient.PreparedStatement prepare = sqlClient.prepare("INSERT INTO INTTABLE (keyName, value ) VALUES (?, ?)", new CallOption[0]);
             FlightSqlClient.PreparedStatement deletePrepare = sqlClient.prepare("DELETE FROM INTTABLE WHERE keyName = ?", new CallOption[0]);){
            Schema parameterSchema = prepare.getParameterSchema();
            try (VectorSchemaRoot insertRoot = VectorSchemaRoot.create((Schema)parameterSchema, (BufferAllocator)allocator);){
                long deletedRows;
                VarCharVector varCharVector = (VarCharVector)insertRoot.getVector(0);
                IntVector valueVector = (IntVector)insertRoot.getVector(1);
                int counter = 10;
                insertRoot.allocateNew();
                IntStream range = IntStream.range(0, 10);
                range.forEach(i -> {
                    valueVector.setSafe(i, i * 10);
                    varCharVector.setSafe(i, new Text("value" + i));
                });
                insertRoot.setRowCount(10);
                prepare.setParameters(insertRoot);
                long updatedRows = prepare.executeUpdate(new CallOption[0]);
                try (VectorSchemaRoot deleteRoot = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{varCharVector});){
                    deletePrepare.setParameters(deleteRoot);
                    deletedRows = deletePrepare.executeUpdate(new CallOption[0]);
                }
                Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)updatedRows, (Matcher)CoreMatchers.is((Object)10L)), () -> MatcherAssert.assertThat((Object)deletedRows, (Matcher)CoreMatchers.is((Object)10L))});
            }
        }
    }

    @Test
    public void testSimplePreparedStatementUpdateResultsWithoutParameters() throws SQLException {
        try (FlightSqlClient.PreparedStatement prepare = sqlClient.prepare("INSERT INTO INTTABLE (keyName, value ) VALUES ('test', 1000)", new CallOption[0]);
             FlightSqlClient.PreparedStatement deletePrepare = sqlClient.prepare("DELETE FROM INTTABLE WHERE keyName = 'test'", new CallOption[0]);){
            long updatedRows = prepare.executeUpdate(new CallOption[0]);
            long deletedRows = deletePrepare.executeUpdate(new CallOption[0]);
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)updatedRows, (Matcher)CoreMatchers.is((Object)1L)), () -> MatcherAssert.assertThat((Object)deletedRows, (Matcher)CoreMatchers.is((Object)1L))});
        }
    }

    @Test
    public void testSimplePreparedStatementClosesProperly() {
        FlightSqlClient.PreparedStatement preparedStatement = sqlClient.prepare("SELECT * FROM intTable", new CallOption[0]);
        Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)preparedStatement.isClosed(), (Matcher)CoreMatchers.is((Object)false)), () -> {
            preparedStatement.close();
            MatcherAssert.assertThat((Object)preparedStatement.isClosed(), (Matcher)CoreMatchers.is((Object)true));
        }});
    }

    @Test
    public void testGetCatalogsSchema() {
        FlightInfo info = sqlClient.getCatalogs(new CallOption[0]);
        MatcherAssert.assertThat((Object)info.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA));
    }

    @Test
    public void testGetCatalogsResults() throws Exception {
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.getCatalogs(new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA)), () -> {
                List<List<String>> catalogs = this.getResults(stream);
                MatcherAssert.assertThat(catalogs, (Matcher)CoreMatchers.is(Collections.emptyList()));
            }});
        }
    }

    @Test
    public void testGetTableTypesSchema() {
        FlightInfo info = sqlClient.getTableTypes(new CallOption[0]);
        MatcherAssert.assertThat((Object)info.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA));
    }

    @Test
    public void testGetTableTypesResult() throws Exception {
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.getTableTypes(new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA)), () -> {
                List<List<String>> tableTypes = this.getResults(stream);
                ImmutableList expectedTableTypes = ImmutableList.of(Collections.singletonList("SYNONYM"), Collections.singletonList("SYSTEM TABLE"), Collections.singletonList("TABLE"), Collections.singletonList("VIEW"));
                MatcherAssert.assertThat(tableTypes, (Matcher)CoreMatchers.is((Object)expectedTableTypes));
            }});
        }
    }

    @Test
    public void testGetSchemasSchema() {
        FlightInfo info = sqlClient.getSchemas(null, null, new CallOption[0]);
        MatcherAssert.assertThat((Object)info.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA));
    }

    @Test
    public void testGetSchemasResult() throws Exception {
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.getSchemas(null, null, new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA)), () -> {
                List<List<String>> schemas = this.getResults(stream);
                ImmutableList expectedSchemas = ImmutableList.of(Arrays.asList(null, "APP"), Arrays.asList(null, "NULLID"), Arrays.asList(null, "SQLJ"), Arrays.asList(null, "SYS"), Arrays.asList(null, "SYSCAT"), Arrays.asList(null, "SYSCS_DIAG"), Arrays.asList(null, "SYSCS_UTIL"), Arrays.asList(null, "SYSFUN"), Arrays.asList(null, "SYSIBM"), Arrays.asList(null, "SYSPROC"), Arrays.asList(null, "SYSSTAT"));
                MatcherAssert.assertThat(schemas, (Matcher)CoreMatchers.is((Object)expectedSchemas));
            }});
        }
    }

    @Test
    public void testGetPrimaryKey() {
        FlightInfo flightInfo = sqlClient.getPrimaryKeys(TableRef.of(null, null, (String)"INTTABLE"), new CallOption[0]);
        FlightStream stream = sqlClient.getStream(((FlightEndpoint)flightInfo.getEndpoints().get(0)).getTicket(), new CallOption[0]);
        List<List<String>> results = this.getResults(stream);
        Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)results.size(), (Matcher)CoreMatchers.is((Object)1)), () -> {
            List result = (List)results.get(0);
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)((String)result.get(0)), (Matcher)CoreMatchers.is((Object)"")), () -> MatcherAssert.assertThat((Object)((String)result.get(1)), (Matcher)CoreMatchers.is((Object)"APP")), () -> MatcherAssert.assertThat((Object)((String)result.get(2)), (Matcher)CoreMatchers.is((Object)"INTTABLE")), () -> MatcherAssert.assertThat((Object)((String)result.get(3)), (Matcher)CoreMatchers.is((Object)"ID")), () -> MatcherAssert.assertThat((Object)((String)result.get(4)), (Matcher)CoreMatchers.is((Object)"1")), () -> MatcherAssert.assertThat((Object)((String)result.get(5)), (Matcher)CoreMatchers.notNullValue())});
        }});
    }

    @Test
    public void testGetSqlInfoSchema() {
        FlightInfo info = sqlClient.getSqlInfo(new FlightSql.SqlInfo[0]);
        MatcherAssert.assertThat((Object)info.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA));
    }

    @Test
    public void testGetSqlInfoResults() throws Exception {
        FlightInfo info = sqlClient.getSqlInfo(new FlightSql.SqlInfo[0]);
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)info.getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA)), () -> MatcherAssert.assertThat(TestFlightSql.getNonConformingResultsForGetSqlInfo(this.getResults(stream)), (Matcher)CoreMatchers.is(Collections.emptyList()))});
        }
    }

    @Test
    public void testGetSqlInfoResultsWithSingleArg() throws Exception {
        FlightSql.SqlInfo arg = FlightSql.SqlInfo.FLIGHT_SQL_SERVER_NAME;
        FlightInfo info = sqlClient.getSqlInfo(new FlightSql.SqlInfo[]{arg});
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)info.getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA)), () -> MatcherAssert.assertThat(TestFlightSql.getNonConformingResultsForGetSqlInfo(this.getResults(stream), arg), (Matcher)CoreMatchers.is(Collections.emptyList()))});
        }
    }

    @Test
    public void testGetSqlInfoResultsWithTwoArgs() throws Exception {
        FlightSql.SqlInfo[] args = new FlightSql.SqlInfo[]{FlightSql.SqlInfo.FLIGHT_SQL_SERVER_NAME, FlightSql.SqlInfo.FLIGHT_SQL_SERVER_VERSION};
        FlightInfo info = sqlClient.getSqlInfo(args);
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)info.getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA)), () -> MatcherAssert.assertThat(TestFlightSql.getNonConformingResultsForGetSqlInfo(this.getResults(stream), args), (Matcher)CoreMatchers.is(Collections.emptyList()))});
        }
    }

    @Test
    public void testGetSqlInfoResultsWithThreeArgs() throws Exception {
        FlightSql.SqlInfo[] args = new FlightSql.SqlInfo[]{FlightSql.SqlInfo.FLIGHT_SQL_SERVER_NAME, FlightSql.SqlInfo.FLIGHT_SQL_SERVER_VERSION, FlightSql.SqlInfo.SQL_IDENTIFIER_QUOTE_CHAR};
        FlightInfo info = sqlClient.getSqlInfo(args);
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)info.getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA)), () -> MatcherAssert.assertThat(TestFlightSql.getNonConformingResultsForGetSqlInfo(this.getResults(stream), args), (Matcher)CoreMatchers.is(Collections.emptyList()))});
        }
    }

    @Test
    public void testGetCommandExportedKeys() {
        FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.getExportedKeys(TableRef.of(null, null, (String)"FOREIGNTABLE"), new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);
        List<List<String>> results = this.getResults(stream);
        List<Matcher> matchers = Arrays.asList(CoreMatchers.nullValue(String.class), CoreMatchers.is((Object)"APP"), CoreMatchers.is((Object)"FOREIGNTABLE"), CoreMatchers.is((Object)"ID"), CoreMatchers.nullValue(String.class), CoreMatchers.is((Object)"APP"), CoreMatchers.is((Object)"INTTABLE"), CoreMatchers.is((Object)"FOREIGNID"), CoreMatchers.is((Object)"1"), CoreMatchers.containsString((String)"SQL"), CoreMatchers.containsString((String)"SQL"), CoreMatchers.is((Object)"3"), CoreMatchers.is((Object)"3"));
        ArrayList<Executable> assertions = new ArrayList<Executable>();
        Assertions.assertEquals((int)1, (int)results.size());
        for (int i = 0; i < matchers.size(); ++i) {
            String actual = results.get(0).get(i);
            Matcher expected = matchers.get(i);
            assertions.add(() -> MatcherAssert.assertThat((Object)actual, (Matcher)expected));
        }
        Assertions.assertAll(assertions);
    }

    @Test
    public void testGetCommandImportedKeys() {
        FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.getImportedKeys(TableRef.of(null, null, (String)"INTTABLE"), new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);
        List<List<String>> results = this.getResults(stream);
        List<Matcher> matchers = Arrays.asList(CoreMatchers.nullValue(String.class), CoreMatchers.is((Object)"APP"), CoreMatchers.is((Object)"FOREIGNTABLE"), CoreMatchers.is((Object)"ID"), CoreMatchers.nullValue(String.class), CoreMatchers.is((Object)"APP"), CoreMatchers.is((Object)"INTTABLE"), CoreMatchers.is((Object)"FOREIGNID"), CoreMatchers.is((Object)"1"), CoreMatchers.containsString((String)"SQL"), CoreMatchers.containsString((String)"SQL"), CoreMatchers.is((Object)"3"), CoreMatchers.is((Object)"3"));
        Assertions.assertEquals((int)1, (int)results.size());
        ArrayList<Executable> assertions = new ArrayList<Executable>();
        for (int i = 0; i < matchers.size(); ++i) {
            String actual = results.get(0).get(i);
            Matcher expected = matchers.get(i);
            assertions.add(() -> MatcherAssert.assertThat((Object)actual, (Matcher)expected));
        }
        Assertions.assertAll(assertions);
    }

    @Test
    public void testGetTypeInfo() {
        FlightInfo flightInfo = sqlClient.getXdbcTypeInfo(new CallOption[0]);
        FlightStream stream = sqlClient.getStream(((FlightEndpoint)flightInfo.getEndpoints().get(0)).getTicket(), new CallOption[0]);
        List<List<String>> results = this.getResults(stream);
        ImmutableList matchers = ImmutableList.of(Arrays.asList("BIGINT", "-5", "19", null, null, Collections.emptyList().toString(), "1", "false", "2", "false", "false", "true", "BIGINT", "0", "0", null, null, "10", null), Arrays.asList("LONG VARCHAR FOR BIT DATA", "-4", "32700", "X'", "'", Collections.emptyList().toString(), "1", "false", "0", "true", "false", "false", "LONG VARCHAR FOR BIT DATA", null, null, null, null, null, null), Arrays.asList("VARCHAR () FOR BIT DATA", "-3", "32672", "X'", "'", Collections.singletonList("length").toString(), "1", "false", "2", "true", "false", "false", "VARCHAR () FOR BIT DATA", null, null, null, null, null, null), Arrays.asList("CHAR () FOR BIT DATA", "-2", "254", "X'", "'", Collections.singletonList("length").toString(), "1", "false", "2", "true", "false", "false", "CHAR () FOR BIT DATA", null, null, null, null, null, null), Arrays.asList("LONG VARCHAR", "-1", "32700", "'", "'", Collections.emptyList().toString(), "1", "true", "1", "true", "false", "false", "LONG VARCHAR", null, null, null, null, null, null), Arrays.asList("CHAR", "1", "254", "'", "'", Collections.singletonList("length").toString(), "1", "true", "3", "true", "false", "false", "CHAR", null, null, null, null, null, null), Arrays.asList("NUMERIC", "2", "31", null, null, Arrays.asList("precision", "scale").toString(), "1", "false", "2", "false", "true", "false", "NUMERIC", "0", "31", null, null, "10", null), Arrays.asList("DECIMAL", "3", "31", null, null, Arrays.asList("precision", "scale").toString(), "1", "false", "2", "false", "true", "false", "DECIMAL", "0", "31", null, null, "10", null), Arrays.asList("INTEGER", "4", "10", null, null, Collections.emptyList().toString(), "1", "false", "2", "false", "false", "true", "INTEGER", "0", "0", null, null, "10", null), Arrays.asList("SMALLINT", "5", "5", null, null, Collections.emptyList().toString(), "1", "false", "2", "false", "false", "true", "SMALLINT", "0", "0", null, null, "10", null), Arrays.asList("FLOAT", "6", "52", null, null, Collections.singletonList("precision").toString(), "1", "false", "2", "false", "false", "false", "FLOAT", null, null, null, null, "2", null), Arrays.asList("REAL", "7", "23", null, null, Collections.emptyList().toString(), "1", "false", "2", "false", "false", "false", "REAL", null, null, null, null, "2", null), (Object[])new List[]{Arrays.asList("DOUBLE", "8", "52", null, null, Collections.emptyList().toString(), "1", "false", "2", "false", "false", "false", "DOUBLE", null, null, null, null, "2", null), Arrays.asList("VARCHAR", "12", "32672", "'", "'", Collections.singletonList("length").toString(), "1", "true", "3", "true", "false", "false", "VARCHAR", null, null, null, null, null, null), Arrays.asList("BOOLEAN", "16", "1", null, null, Collections.emptyList().toString(), "1", "false", "2", "true", "false", "false", "BOOLEAN", null, null, null, null, null, null), Arrays.asList("DATE", "91", "10", "DATE'", "'", Collections.emptyList().toString(), "1", "false", "2", "true", "false", "false", "DATE", "0", "0", null, null, "10", null), Arrays.asList("TIME", "92", "8", "TIME'", "'", Collections.emptyList().toString(), "1", "false", "2", "true", "false", "false", "TIME", "0", "0", null, null, "10", null), Arrays.asList("TIMESTAMP", "93", "29", "TIMESTAMP'", "'", Collections.emptyList().toString(), "1", "false", "2", "true", "false", "false", "TIMESTAMP", "0", "9", null, null, "10", null), Arrays.asList("OBJECT", "2000", null, null, null, Collections.emptyList().toString(), "1", "false", "2", "true", "false", "false", "OBJECT", null, null, null, null, null, null), Arrays.asList("BLOB", "2004", "2147483647", null, null, Collections.singletonList("length").toString(), "1", "false", "0", null, "false", null, "BLOB", null, null, null, null, null, null), Arrays.asList("CLOB", "2005", "2147483647", "'", "'", Collections.singletonList("length").toString(), "1", "true", "1", null, "false", null, "CLOB", null, null, null, null, null, null), Arrays.asList("XML", "2009", null, null, null, Collections.emptyList().toString(), "1", "true", "0", "false", "false", "false", "XML", null, null, null, null, null, null)});
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.is((Object)matchers));
    }

    @Test
    public void testGetTypeInfoWithFiltering() {
        FlightInfo flightInfo = sqlClient.getXdbcTypeInfo(-5, new CallOption[0]);
        FlightStream stream = sqlClient.getStream(((FlightEndpoint)flightInfo.getEndpoints().get(0)).getTicket(), new CallOption[0]);
        List<List<String>> results = this.getResults(stream);
        ImmutableList matchers = ImmutableList.of(Arrays.asList("BIGINT", "-5", "19", null, null, Collections.emptyList().toString(), "1", "false", "2", "false", "false", "true", "BIGINT", "0", "0", null, null, "10", null));
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.is((Object)matchers));
    }

    @Test
    public void testGetCommandCrossReference() {
        FlightInfo flightInfo = sqlClient.getCrossReference(TableRef.of(null, null, (String)"FOREIGNTABLE"), TableRef.of(null, null, (String)"INTTABLE"), new CallOption[0]);
        FlightStream stream = sqlClient.getStream(((FlightEndpoint)flightInfo.getEndpoints().get(0)).getTicket(), new CallOption[0]);
        List<List<String>> results = this.getResults(stream);
        List<Matcher> matchers = Arrays.asList(CoreMatchers.nullValue(String.class), CoreMatchers.is((Object)"APP"), CoreMatchers.is((Object)"FOREIGNTABLE"), CoreMatchers.is((Object)"ID"), CoreMatchers.nullValue(String.class), CoreMatchers.is((Object)"APP"), CoreMatchers.is((Object)"INTTABLE"), CoreMatchers.is((Object)"FOREIGNID"), CoreMatchers.is((Object)"1"), CoreMatchers.containsString((String)"SQL"), CoreMatchers.containsString((String)"SQL"), CoreMatchers.is((Object)"3"), CoreMatchers.is((Object)"3"));
        Assertions.assertEquals((int)1, (int)results.size());
        ArrayList<Executable> assertions = new ArrayList<Executable>();
        for (int i = 0; i < matchers.size(); ++i) {
            String actual = results.get(0).get(i);
            Matcher expected = matchers.get(i);
            assertions.add(() -> MatcherAssert.assertThat((Object)actual, (Matcher)expected));
        }
        Assertions.assertAll(assertions);
    }

    @Test
    public void testCreateStatementSchema() throws Exception {
        FlightInfo info = sqlClient.execute("SELECT * FROM intTable", new CallOption[0]);
        MatcherAssert.assertThat((Object)info.getSchema(), (Matcher)CoreMatchers.is((Object)SCHEMA_INT_TABLE));
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)info.getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            while (stream.next()) {
            }
        }
    }

    @Test
    public void testCreateStatementResults() throws Exception {
        try (FlightStream stream = sqlClient.getStream(((FlightEndpoint)sqlClient.execute("SELECT * FROM intTable", new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)SCHEMA_INT_TABLE)), () -> MatcherAssert.assertThat(this.getResults(stream), (Matcher)CoreMatchers.is(EXPECTED_RESULTS_FOR_STAR_SELECT_QUERY))});
        }
    }

    List<List<String>> getResults(FlightStream stream) {
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        while (stream.next()) {
            VectorSchemaRoot root = stream.getRoot();
            Throwable throwable = null;
            try {
                long rowCount = root.getRowCount();
                int i = 0;
                while ((long)i < rowCount) {
                    results.add(new ArrayList());
                    ++i;
                }
                root.getSchema().getFields().forEach(field -> {
                    block25: {
                        FieldVector fieldVector = root.getVector(field.getName());
                        Throwable throwable = null;
                        try {
                            if (fieldVector instanceof VarCharVector) {
                                VarCharVector varcharVector = (VarCharVector)fieldVector;
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Text data = varcharVector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : data.toString());
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof IntVector) {
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Object data = fieldVector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : Objects.toString(data));
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof VarBinaryVector) {
                                VarBinaryVector varbinaryVector = (VarBinaryVector)fieldVector;
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    String output;
                                    byte[] data = varbinaryVector.getObject(rowIndex);
                                    try {
                                        output = Objects.isNull(data) ? null : MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel(new ByteArrayInputStream(data)))).toJson();
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException("Failed to deserialize schema", e);
                                    }
                                    ((List)results.get(rowIndex)).add(output);
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof DenseUnionVector) {
                                DenseUnionVector denseUnionVector = (DenseUnionVector)fieldVector;
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Object data = denseUnionVector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : Objects.toString(data));
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof ListVector) {
                                for (int i = 0; i < fieldVector.getValueCount(); ++i) {
                                    if (fieldVector.isNull(i)) continue;
                                    List elements = ((ListVector)fieldVector).getObject(i);
                                    ArrayList<String> values = new ArrayList<String>();
                                    for (Text element : elements) {
                                        values.add(element.toString());
                                    }
                                    ((List)results.get(i)).add(((Object)values).toString());
                                }
                                break block25;
                            }
                            if (fieldVector instanceof UInt4Vector) {
                                UInt4Vector uInt4Vector = (UInt4Vector)fieldVector;
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Integer data = uInt4Vector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : Objects.toString(data));
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof UInt1Vector) {
                                UInt1Vector uInt1Vector = (UInt1Vector)fieldVector;
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Byte data = uInt1Vector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : Objects.toString(data));
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof BitVector) {
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Object data = fieldVector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : Objects.toString(data));
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            throw new UnsupportedOperationException("Not yet implemented");
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fieldVector != null) {
                                TestFlightSql.$closeResource(throwable, (AutoCloseable)fieldVector);
                            }
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (root == null) continue;
                TestFlightSql.$closeResource(throwable, (AutoCloseable)root);
            }
        }
        return results;
    }

    @Test
    public void testExecuteUpdate() {
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            long insertedCount = sqlClient.executeUpdate("INSERT INTO INTTABLE (keyName, value) VALUES ('KEYNAME1', 1001), ('KEYNAME2', 1002), ('KEYNAME3', 1003)", new CallOption[0]);
            MatcherAssert.assertThat((Object)insertedCount, (Matcher)CoreMatchers.is((Object)3L));
        }, () -> {
            long updatedCount = sqlClient.executeUpdate("UPDATE INTTABLE SET keyName = 'KEYNAME1' WHERE keyName = 'KEYNAME2' OR keyName = 'KEYNAME3'", new CallOption[0]);
            MatcherAssert.assertThat((Object)updatedCount, (Matcher)CoreMatchers.is((Object)2L));
        }, () -> {
            long deletedCount = sqlClient.executeUpdate("DELETE FROM INTTABLE WHERE keyName = 'KEYNAME1'", new CallOption[0]);
            MatcherAssert.assertThat((Object)deletedCount, (Matcher)CoreMatchers.is((Object)3L));
        }});
    }

    @Test
    public void testQueryWithNoResultsShouldNotHang() throws Exception {
        try (FlightSqlClient.PreparedStatement preparedStatement = sqlClient.prepare("SELECT * FROM intTable WHERE 1 = 0", new CallOption[0]);
             FlightStream stream = sqlClient.getStream(((FlightEndpoint)preparedStatement.execute(new CallOption[0]).getEndpoints().get(0)).getTicket(), new CallOption[0]);){
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)stream.getSchema(), (Matcher)CoreMatchers.is((Object)SCHEMA_INT_TABLE)), () -> {
                List<List<String>> result = this.getResults(stream);
                MatcherAssert.assertThat(result, (Matcher)CoreMatchers.is(Collections.emptyList()));
            }});
        }
    }

    @Test
    public void testCancelFlightInfo() {
        FlightInfo info = sqlClient.getSqlInfo(new FlightSql.SqlInfo[0]);
        CancelFlightInfoRequest request = new CancelFlightInfoRequest(info);
        FlightRuntimeException fre = (FlightRuntimeException)Assertions.assertThrows(FlightRuntimeException.class, () -> sqlClient.cancelFlightInfo(request, new CallOption[0]));
        Assertions.assertEquals((Object)FlightStatusCode.UNIMPLEMENTED, (Object)fre.status().code());
    }

    @Test
    public void testCancelQuery() {
        FlightInfo info = sqlClient.getSqlInfo(new FlightSql.SqlInfo[0]);
        FlightRuntimeException fre = (FlightRuntimeException)Assertions.assertThrows(FlightRuntimeException.class, () -> sqlClient.cancelQuery(info, new CallOption[0]));
        Assertions.assertEquals((Object)FlightStatusCode.UNIMPLEMENTED, (Object)fre.status().code());
    }

    @Test
    public void testRenewEndpoint() {
        FlightInfo info = sqlClient.getSqlInfo(new FlightSql.SqlInfo[0]);
        FlightRuntimeException fre = (FlightRuntimeException)Assertions.assertThrows(FlightRuntimeException.class, () -> sqlClient.renewFlightEndpoint(new RenewFlightEndpointRequest((FlightEndpoint)info.getEndpoints().get(0)), new CallOption[0]));
        Assertions.assertEquals((Object)FlightStatusCode.UNIMPLEMENTED, (Object)fre.status().code());
    }
}

