/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

@FunctionalInterface
public interface VectorSchemaRootTransformer {
    public VectorSchemaRoot transform(VectorSchemaRoot var1, VectorSchemaRoot var2) throws Exception;

    public static class Builder {
        private final Schema schema;
        private final BufferAllocator bufferAllocator;
        private final List<Field> newFields = new ArrayList<Field>();
        private final Collection<Task> tasks = new ArrayList<Task>();

        public Builder(Schema schema, BufferAllocator bufferAllocator) {
            this.schema = schema;
            this.bufferAllocator = bufferAllocator.newChildAllocator("VectorSchemaRootTransformer", 0L, bufferAllocator.getLimit());
        }

        public Builder renameFieldVector(String originalVectorName, String transformedVectorName) {
            this.tasks.add((originalRoot, transformedRoot) -> {
                ArrowType transformedType;
                FieldVector originalVector = originalRoot.getVector(originalVectorName);
                FieldVector transformedVector = transformedRoot.getVector(transformedVectorName);
                ArrowType originalType = originalVector.getField().getType();
                if (!originalType.equals(transformedType = transformedVector.getField().getType())) {
                    throw new IllegalArgumentException(String.format("Cannot transfer vector with field type %s to %s", originalType, transformedType));
                }
                if (originalVector instanceof BaseVariableWidthVector) {
                    ((BaseVariableWidthVector)originalVector).transferTo((BaseVariableWidthVector)transformedVector);
                } else if (originalVector instanceof BaseFixedWidthVector) {
                    ((BaseFixedWidthVector)originalVector).transferTo((BaseFixedWidthVector)transformedVector);
                } else {
                    throw new IllegalStateException(String.format("Cannot transfer vector of type %s", originalVector.getClass()));
                }
            });
            Field originalField = this.schema.findField(originalVectorName);
            this.newFields.add(new Field(transformedVectorName, new FieldType(originalField.isNullable(), originalField.getType(), originalField.getDictionary(), originalField.getMetadata()), originalField.getChildren()));
            return this;
        }

        public Builder addEmptyField(String fieldName, Types.MinorType fieldType) {
            this.newFields.add(Field.nullable((String)fieldName, (ArrowType)fieldType.getType()));
            return this;
        }

        public Builder addEmptyField(String fieldName, ArrowType fieldType) {
            this.newFields.add(Field.nullable((String)fieldName, (ArrowType)fieldType));
            return this;
        }

        public VectorSchemaRootTransformer build() {
            return (originalRoot, transformedRoot) -> {
                if (transformedRoot == null) {
                    transformedRoot = VectorSchemaRoot.create((Schema)new Schema(this.newFields), (BufferAllocator)this.bufferAllocator);
                }
                for (Task task : this.tasks) {
                    task.run(originalRoot, transformedRoot);
                }
                transformedRoot.setRowCount(originalRoot.getRowCount());
                originalRoot.clear();
                return transformedRoot;
            };
        }

        @FunctionalInterface
        static interface Task {
            public void run(VectorSchemaRoot var1, VectorSchemaRoot var2);
        }
    }
}

