/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.converter.impl;

import java.util.List;
import org.apache.arrow.driver.jdbc.converter.impl.BaseAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.utils.AvaticaParameterBinder;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.remote.TypedValue;

public class ListAvaticaParameterConverter
extends BaseAvaticaParameterConverter {
    public ListAvaticaParameterConverter(ArrowType.List type) {
    }

    @Override
    public boolean bindParameter(FieldVector vector, TypedValue typedValue, int index) {
        List values = (List)typedValue.value;
        if (vector instanceof ListVector) {
            ListVector listVector = (ListVector)vector;
            FieldVector childVector = listVector.getDataVector();
            int startPos = listVector.startNewValue(index);
            for (int i = 0; i < values.size(); ++i) {
                Object val = values.get(i);
                int childIndex = startPos + i;
                if (val == null) {
                    if (childVector.getField().isNullable()) {
                        childVector.setNull(childIndex);
                        continue;
                    }
                    throw new UnsupportedOperationException("Can't set null on non-nullable child list");
                }
                childVector.getField().getType().accept((ArrowType.ArrowTypeVisitor)new AvaticaParameterBinder.BinderVisitor(childVector, TypedValue.ofSerial((ColumnMetaData.Rep)typedValue.componentType, val), childIndex));
            }
            listVector.endValue(index, values.size());
            listVector.setValueCount(index + 1);
            return true;
        }
        return false;
    }

    @Override
    public AvaticaParameter createParameter(Field field) {
        return this.createParameter(field, false);
    }
}

