/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.converter.impl;

import java.util.List;
import org.apache.arrow.driver.jdbc.converter.impl.BaseAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.utils.AvaticaParameterBinder;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.remote.TypedValue;

public class LargeListAvaticaParameterConverter
extends BaseAvaticaParameterConverter {
    public LargeListAvaticaParameterConverter(ArrowType.LargeList type) {
    }

    @Override
    public boolean bindParameter(FieldVector vector, TypedValue typedValue, int index) {
        List values = (List)typedValue.value;
        if (vector instanceof LargeListVector) {
            LargeListVector listVector = (LargeListVector)vector;
            FieldVector childVector = listVector.getDataVector();
            long startPos = listVector.startNewValue((long)index);
            for (int i = 0; i < values.size(); ++i) {
                Object val = values.get(i);
                int childIndex = LargeMemoryUtil.checkedCastToInt((long)startPos) + i;
                if (val == null) {
                    if (childVector.getField().isNullable()) {
                        childVector.setNull(childIndex);
                        continue;
                    }
                    throw new UnsupportedOperationException("Can't set null on non-nullable child list");
                }
                childVector.getField().getType().accept((ArrowType.ArrowTypeVisitor)new AvaticaParameterBinder.BinderVisitor(childVector, TypedValue.ofSerial((ColumnMetaData.Rep)typedValue.componentType, val), childIndex));
            }
            listVector.endValue(index, (long)values.size());
            listVector.setValueCount(index + 1);
            return true;
        }
        return false;
    }

    @Override
    public AvaticaParameter createParameter(Field field) {
        return this.createParameter(field, false);
    }
}

