/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableSmallIntHolder;
import org.apache.arrow.vector.holders.NullableTinyIntHolder;
import org.apache.arrow.vector.holders.NullableUInt1Holder;
import org.apache.arrow.vector.holders.NullableUInt2Holder;
import org.apache.arrow.vector.holders.NullableUInt4Holder;
import org.apache.arrow.vector.holders.NullableUInt8Holder;

class ArrowFlightJdbcNumericGetter {
    ArrowFlightJdbcNumericGetter() {
    }

    static Getter createGetter(BaseIntVector vector) {
        if (vector instanceof UInt1Vector) {
            return ArrowFlightJdbcNumericGetter.createGetter((UInt1Vector)vector);
        }
        if (vector instanceof UInt2Vector) {
            return ArrowFlightJdbcNumericGetter.createGetter((UInt2Vector)vector);
        }
        if (vector instanceof UInt4Vector) {
            return ArrowFlightJdbcNumericGetter.createGetter((UInt4Vector)vector);
        }
        if (vector instanceof UInt8Vector) {
            return ArrowFlightJdbcNumericGetter.createGetter((UInt8Vector)vector);
        }
        if (vector instanceof TinyIntVector) {
            return ArrowFlightJdbcNumericGetter.createGetter((TinyIntVector)vector);
        }
        if (vector instanceof SmallIntVector) {
            return ArrowFlightJdbcNumericGetter.createGetter((SmallIntVector)vector);
        }
        if (vector instanceof IntVector) {
            return ArrowFlightJdbcNumericGetter.createGetter((IntVector)vector);
        }
        if (vector instanceof BigIntVector) {
            return ArrowFlightJdbcNumericGetter.createGetter((BigIntVector)vector);
        }
        throw new UnsupportedOperationException("No valid IntVector was provided.");
    }

    private static Getter createGetter(UInt1Vector vector) {
        NullableUInt1Holder nullableUInt1Holder = new NullableUInt1Holder();
        return (index, holder) -> {
            vector.get(index, nullableUInt1Holder);
            holder.isSet = nullableUInt1Holder.isSet;
            holder.value = nullableUInt1Holder.value;
        };
    }

    private static Getter createGetter(UInt2Vector vector) {
        NullableUInt2Holder nullableUInt2Holder = new NullableUInt2Holder();
        return (index, holder) -> {
            vector.get(index, nullableUInt2Holder);
            holder.isSet = nullableUInt2Holder.isSet;
            holder.value = nullableUInt2Holder.value;
        };
    }

    private static Getter createGetter(UInt4Vector vector) {
        NullableUInt4Holder nullableUInt4Holder = new NullableUInt4Holder();
        return (index, holder) -> {
            vector.get(index, nullableUInt4Holder);
            holder.isSet = nullableUInt4Holder.isSet;
            holder.value = nullableUInt4Holder.value;
        };
    }

    private static Getter createGetter(UInt8Vector vector) {
        NullableUInt8Holder nullableUInt8Holder = new NullableUInt8Holder();
        return (index, holder) -> {
            vector.get(index, nullableUInt8Holder);
            holder.isSet = nullableUInt8Holder.isSet;
            holder.value = nullableUInt8Holder.value;
        };
    }

    private static Getter createGetter(TinyIntVector vector) {
        NullableTinyIntHolder nullableTinyIntHolder = new NullableTinyIntHolder();
        return (index, holder) -> {
            vector.get(index, nullableTinyIntHolder);
            holder.isSet = nullableTinyIntHolder.isSet;
            holder.value = nullableTinyIntHolder.value;
        };
    }

    private static Getter createGetter(SmallIntVector vector) {
        NullableSmallIntHolder nullableSmallIntHolder = new NullableSmallIntHolder();
        return (index, holder) -> {
            vector.get(index, nullableSmallIntHolder);
            holder.isSet = nullableSmallIntHolder.isSet;
            holder.value = nullableSmallIntHolder.value;
        };
    }

    private static Getter createGetter(IntVector vector) {
        NullableIntHolder nullableIntHolder = new NullableIntHolder();
        return (index, holder) -> {
            vector.get(index, nullableIntHolder);
            holder.isSet = nullableIntHolder.isSet;
            holder.value = nullableIntHolder.value;
        };
    }

    private static Getter createGetter(BigIntVector vector) {
        NullableBigIntHolder nullableBigIntHolder = new NullableBigIntHolder();
        return (index, holder) -> {
            vector.get(index, nullableBigIntHolder);
            holder.isSet = nullableBigIntHolder.isSet;
            holder.value = nullableBigIntHolder.value;
        };
    }

    @FunctionalInterface
    static interface Getter {
        public void get(int var1, NumericHolder var2);
    }

    static class NumericHolder {
        int isSet;
        long value;

        NumericHolder() {
        }
    }
}

