/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.holders.NullableFloat8Holder;

public class ArrowFlightJdbcFloat8VectorAccessor
extends ArrowFlightJdbcAccessor {
    private final Float8Vector vector;
    private final NullableFloat8Holder holder = new NullableFloat8Holder();

    public ArrowFlightJdbcFloat8VectorAccessor(Float8Vector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.vector = vector;
    }

    @Override
    public Class<?> getObjectClass() {
        return Double.class;
    }

    @Override
    public double getDouble() {
        this.vector.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
        if (this.wasNull) {
            return 0.0;
        }
        return this.holder.value;
    }

    @Override
    public Object getObject() {
        double value = this.getDouble();
        return this.wasNull ? null : Double.valueOf(value);
    }

    @Override
    public String getString() {
        double value = this.getDouble();
        return this.wasNull ? null : Double.toString(value);
    }

    @Override
    public boolean getBoolean() {
        return this.getDouble() != 0.0;
    }

    @Override
    public byte getByte() {
        return (byte)this.getDouble();
    }

    @Override
    public short getShort() {
        return (short)this.getDouble();
    }

    @Override
    public int getInt() {
        return (int)this.getDouble();
    }

    @Override
    public long getLong() {
        return (long)this.getDouble();
    }

    @Override
    public float getFloat() {
        return (float)this.getDouble();
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        double value = this.getDouble();
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new SQLException("BigDecimal doesn't support Infinite/NaN.");
        }
        return this.wasNull ? null : BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        double value = this.getDouble();
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new SQLException("BigDecimal doesn't support Infinite/NaN.");
        }
        return this.wasNull ? null : BigDecimal.valueOf(value).setScale(scale, RoundingMode.HALF_UP);
    }
}

