/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;

public class ArrowFlightJdbcDecimalVectorAccessor
extends ArrowFlightJdbcAccessor {
    private final Getter getter;

    public ArrowFlightJdbcDecimalVectorAccessor(DecimalVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = arg_0 -> ((DecimalVector)vector).getObject(arg_0);
    }

    public ArrowFlightJdbcDecimalVectorAccessor(Decimal256Vector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.getter = arg_0 -> ((Decimal256Vector)vector).getObject(arg_0);
    }

    @Override
    public Class<?> getObjectClass() {
        return BigDecimal.class;
    }

    @Override
    public BigDecimal getBigDecimal() {
        BigDecimal value = this.getter.getObject(this.getCurrentRow());
        this.wasNull = value == null;
        this.wasNullConsumer.setWasNull(this.wasNull);
        return value;
    }

    @Override
    public String getString() {
        BigDecimal value = this.getBigDecimal();
        return this.wasNull ? null : value.toString();
    }

    @Override
    public boolean getBoolean() {
        BigDecimal value = this.getBigDecimal();
        return !this.wasNull && !value.equals(BigDecimal.ZERO);
    }

    @Override
    public byte getByte() {
        BigDecimal value = this.getBigDecimal();
        return this.wasNull ? (byte)0 : value.byteValue();
    }

    @Override
    public short getShort() {
        BigDecimal value = this.getBigDecimal();
        return this.wasNull ? (short)0 : value.shortValue();
    }

    @Override
    public int getInt() {
        BigDecimal value = this.getBigDecimal();
        return this.wasNull ? 0 : value.intValue();
    }

    @Override
    public long getLong() {
        BigDecimal value = this.getBigDecimal();
        return this.wasNull ? 0L : value.longValue();
    }

    @Override
    public float getFloat() {
        BigDecimal value = this.getBigDecimal();
        return this.wasNull ? 0.0f : value.floatValue();
    }

    @Override
    public double getDouble() {
        BigDecimal value = this.getBigDecimal();
        return this.wasNull ? 0.0 : value.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int scale) {
        BigDecimal value = this.getBigDecimal();
        return this.wasNull ? null : value.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public Object getObject() {
        return this.getBigDecimal();
    }

    @FunctionalInterface
    static interface Getter {
        public BigDecimal getObject(int var1);
    }
}

