/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcNumericGetter;
import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.types.Types;

public class ArrowFlightJdbcBaseIntVectorAccessor
extends ArrowFlightJdbcAccessor {
    private final Types.MinorType type;
    private final boolean isUnsigned;
    private final ArrowFlightJdbcNumericGetter.Getter getter;
    private final ArrowFlightJdbcNumericGetter.NumericHolder holder;

    public ArrowFlightJdbcBaseIntVectorAccessor(UInt1Vector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this((BaseIntVector)vector, currentRowSupplier, true, setCursorWasNull);
    }

    public ArrowFlightJdbcBaseIntVectorAccessor(UInt2Vector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this((BaseIntVector)vector, currentRowSupplier, true, setCursorWasNull);
    }

    public ArrowFlightJdbcBaseIntVectorAccessor(UInt4Vector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this((BaseIntVector)vector, currentRowSupplier, true, setCursorWasNull);
    }

    public ArrowFlightJdbcBaseIntVectorAccessor(UInt8Vector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this((BaseIntVector)vector, currentRowSupplier, true, setCursorWasNull);
    }

    public ArrowFlightJdbcBaseIntVectorAccessor(TinyIntVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this((BaseIntVector)vector, currentRowSupplier, false, setCursorWasNull);
    }

    public ArrowFlightJdbcBaseIntVectorAccessor(SmallIntVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this((BaseIntVector)vector, currentRowSupplier, false, setCursorWasNull);
    }

    public ArrowFlightJdbcBaseIntVectorAccessor(IntVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this((BaseIntVector)vector, currentRowSupplier, false, setCursorWasNull);
    }

    public ArrowFlightJdbcBaseIntVectorAccessor(BigIntVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        this((BaseIntVector)vector, currentRowSupplier, false, setCursorWasNull);
    }

    private ArrowFlightJdbcBaseIntVectorAccessor(BaseIntVector vector, IntSupplier currentRowSupplier, boolean isUnsigned, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.type = vector.getMinorType();
        this.holder = new ArrowFlightJdbcNumericGetter.NumericHolder();
        this.getter = ArrowFlightJdbcNumericGetter.createGetter(vector);
        this.isUnsigned = isUnsigned;
    }

    @Override
    public long getLong() {
        this.getter.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
        if (this.wasNull) {
            return 0L;
        }
        return this.holder.value;
    }

    @Override
    public Class<?> getObjectClass() {
        return Long.class;
    }

    @Override
    public String getString() {
        long number = this.getLong();
        if (this.wasNull) {
            return null;
        }
        return this.isUnsigned ? Long.toUnsignedString(number) : Long.toString(number);
    }

    @Override
    public byte getByte() {
        return (byte)this.getLong();
    }

    @Override
    public short getShort() {
        return (short)this.getLong();
    }

    @Override
    public int getInt() {
        return (int)this.getLong();
    }

    @Override
    public float getFloat() {
        return this.getLong();
    }

    @Override
    public double getDouble() {
        return this.getLong();
    }

    @Override
    public BigDecimal getBigDecimal() {
        BigDecimal value = BigDecimal.valueOf(this.getLong());
        return this.wasNull ? null : value;
    }

    @Override
    public BigDecimal getBigDecimal(int scale) {
        BigDecimal value = BigDecimal.valueOf(this.getDouble()).setScale(scale, RoundingMode.HALF_UP);
        return this.wasNull ? null : value;
    }

    @Override
    public Number getObject() {
        Number number;
        switch (this.type) {
            case TINYINT: 
            case UINT1: {
                number = this.getByte();
                break;
            }
            case SMALLINT: 
            case UINT2: {
                number = this.getShort();
                break;
            }
            case INT: 
            case UINT4: {
                number = this.getInt();
                break;
            }
            case BIGINT: 
            case UINT8: {
                number = this.getLong();
                break;
            }
            default: {
                throw new IllegalStateException("No valid MinorType was provided.");
            }
        }
        return this.wasNull ? (Number)null : (Number)number;
    }

    @Override
    public boolean getBoolean() {
        long value = this.getLong();
        return value != 0L;
    }
}

