/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.complex;

import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.calcite.avatica.util.StructImpl;

public class ArrowFlightJdbcStructVectorAccessor
extends ArrowFlightJdbcAccessor {
    private final StructVector vector;

    public ArrowFlightJdbcStructVectorAccessor(StructVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.vector = vector;
    }

    @Override
    public Class<?> getObjectClass() {
        return Map.class;
    }

    @Override
    public Object getObject() {
        Map object = this.vector.getObject(this.getCurrentRow());
        this.wasNull = object == null;
        this.wasNullConsumer.setWasNull(this.wasNull);
        return object;
    }

    @Override
    public Struct getStruct() {
        int currentRow = this.getCurrentRow();
        this.wasNull = this.vector.isNull(currentRow);
        this.wasNullConsumer.setWasNull(this.wasNull);
        if (this.wasNull) {
            return null;
        }
        List attributes = this.vector.getChildrenFromFields().stream().map(vector -> vector.getObject(currentRow)).collect(Collectors.toList());
        return new StructImpl(attributes);
    }
}

