/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.complex;

import java.util.Map;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.complex.AbstractArrowFlightJdbcListVectorAccessor;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.impl.UnionMapReader;
import org.apache.arrow.vector.util.JsonStringHashMap;

public class ArrowFlightJdbcMapVectorAccessor
extends AbstractArrowFlightJdbcListVectorAccessor {
    private final MapVector vector;

    public ArrowFlightJdbcMapVectorAccessor(MapVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.vector = vector;
    }

    @Override
    public Class<?> getObjectClass() {
        return Map.class;
    }

    @Override
    public Object getObject() {
        int index = this.getCurrentRow();
        this.wasNull = this.vector.isNull(index);
        this.wasNullConsumer.setWasNull(this.wasNull);
        if (this.wasNull) {
            return null;
        }
        JsonStringHashMap result = new JsonStringHashMap();
        UnionMapReader reader = this.vector.getReader();
        reader.setPosition(index);
        while (reader.next()) {
            Object key = reader.key().readObject();
            Object value = reader.value().readObject();
            result.put(key, value);
        }
        return result;
    }

    @Override
    protected long getStartOffset(int index) {
        return this.vector.getOffsetBuffer().getInt((long)index * 4L);
    }

    @Override
    protected long getEndOffset(int index) {
        return this.vector.getOffsetBuffer().getInt((long)(index + 1) * 4L);
    }

    @Override
    protected boolean isNull(int index) {
        return this.vector.isNull(index);
    }

    @Override
    protected FieldVector getDataVector() {
        return this.vector.getDataVector();
    }
}

