/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.calendar;

import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.holders.NullableTimeMicroHolder;
import org.apache.arrow.vector.holders.NullableTimeMilliHolder;
import org.apache.arrow.vector.holders.NullableTimeNanoHolder;
import org.apache.arrow.vector.holders.NullableTimeSecHolder;

final class ArrowFlightJdbcTimeVectorGetter {
    private ArrowFlightJdbcTimeVectorGetter() {
    }

    static Getter createGetter(TimeNanoVector vector) {
        NullableTimeNanoHolder auxHolder = new NullableTimeNanoHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    static Getter createGetter(TimeMicroVector vector) {
        NullableTimeMicroHolder auxHolder = new NullableTimeMicroHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    static Getter createGetter(TimeMilliVector vector) {
        NullableTimeMilliHolder auxHolder = new NullableTimeMilliHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    static Getter createGetter(TimeSecVector vector) {
        NullableTimeSecHolder auxHolder = new NullableTimeSecHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    @FunctionalInterface
    static interface Getter {
        public void get(int var1, Holder var2);
    }

    static class Holder {
        int isSet;
        long value;

        Holder() {
        }
    }
}

