/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.calendar;

import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecTZVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.holders.NullableTimeStampMicroHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMicroTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import org.apache.arrow.vector.holders.NullableTimeStampMilliTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampNanoHolder;
import org.apache.arrow.vector.holders.NullableTimeStampNanoTZHolder;
import org.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import org.apache.arrow.vector.holders.NullableTimeStampSecTZHolder;

final class ArrowFlightJdbcTimeStampVectorGetter {
    private ArrowFlightJdbcTimeStampVectorGetter() {
    }

    static Getter createGetter(TimeStampVector vector) {
        if (vector instanceof TimeStampNanoVector) {
            return ArrowFlightJdbcTimeStampVectorGetter.createGetter((TimeStampNanoVector)vector);
        }
        if (vector instanceof TimeStampNanoTZVector) {
            return ArrowFlightJdbcTimeStampVectorGetter.createGetter((TimeStampNanoTZVector)vector);
        }
        if (vector instanceof TimeStampMicroVector) {
            return ArrowFlightJdbcTimeStampVectorGetter.createGetter((TimeStampMicroVector)vector);
        }
        if (vector instanceof TimeStampMicroTZVector) {
            return ArrowFlightJdbcTimeStampVectorGetter.createGetter((TimeStampMicroTZVector)vector);
        }
        if (vector instanceof TimeStampMilliVector) {
            return ArrowFlightJdbcTimeStampVectorGetter.createGetter((TimeStampMilliVector)vector);
        }
        if (vector instanceof TimeStampMilliTZVector) {
            return ArrowFlightJdbcTimeStampVectorGetter.createGetter((TimeStampMilliTZVector)vector);
        }
        if (vector instanceof TimeStampSecVector) {
            return ArrowFlightJdbcTimeStampVectorGetter.createGetter((TimeStampSecVector)vector);
        }
        if (vector instanceof TimeStampSecTZVector) {
            return ArrowFlightJdbcTimeStampVectorGetter.createGetter((TimeStampSecTZVector)vector);
        }
        throw new UnsupportedOperationException("Unsupported Timestamp vector type");
    }

    private static Getter createGetter(TimeStampNanoVector vector) {
        NullableTimeStampNanoHolder auxHolder = new NullableTimeStampNanoHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampNanoTZVector vector) {
        NullableTimeStampNanoTZHolder auxHolder = new NullableTimeStampNanoTZHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampMicroVector vector) {
        NullableTimeStampMicroHolder auxHolder = new NullableTimeStampMicroHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampMicroTZVector vector) {
        NullableTimeStampMicroTZHolder auxHolder = new NullableTimeStampMicroTZHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampMilliVector vector) {
        NullableTimeStampMilliHolder auxHolder = new NullableTimeStampMilliHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampMilliTZVector vector) {
        NullableTimeStampMilliTZHolder auxHolder = new NullableTimeStampMilliTZHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampSecVector vector) {
        NullableTimeStampSecHolder auxHolder = new NullableTimeStampSecHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    private static Getter createGetter(TimeStampSecTZVector vector) {
        NullableTimeStampSecTZHolder auxHolder = new NullableTimeStampSecTZHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    @FunctionalInterface
    static interface Getter {
        public void get(int var1, Holder var2);
    }

    static class Holder {
        int isSet;
        long value;

        Holder() {
        }
    }
}

