/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.calendar;

import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.holders.NullableDateDayHolder;
import org.apache.arrow.vector.holders.NullableDateMilliHolder;

final class ArrowFlightJdbcDateVectorGetter {
    private ArrowFlightJdbcDateVectorGetter() {
    }

    static Getter createGetter(DateDayVector vector) {
        NullableDateDayHolder auxHolder = new NullableDateDayHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    static Getter createGetter(DateMilliVector vector) {
        NullableDateMilliHolder auxHolder = new NullableDateMilliHolder();
        return (index, holder) -> {
            vector.get(index, auxHolder);
            holder.isSet = auxHolder.isSet;
            holder.value = auxHolder.value;
        };
    }

    @FunctionalInterface
    static interface Getter {
        public void get(int var1, Holder var2);
    }

    static class Holder {
        int isSet;
        long value;

        Holder() {
        }
    }
}

