/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.utils.ConnectionWrapper;

public class ArrowFlightJdbcPooledConnection
implements PooledConnection {
    private final ArrowFlightConnection connection;
    private final Set<ConnectionEventListener> eventListeners;
    private final Set<StatementEventListener> statementEventListeners;

    ArrowFlightJdbcPooledConnection(ArrowFlightConnection connection) {
        this.connection = connection;
        this.eventListeners = Collections.synchronizedSet(new HashSet());
        this.statementEventListeners = Collections.synchronizedSet(new HashSet());
    }

    public Properties getProperties() {
        return this.connection.getClientInfo();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new ConnectionHandle();
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    void reset() throws SQLException {
        this.connection.reset();
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }

    private void onConnectionClosed() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        this.eventListeners.forEach(listener -> listener.connectionClosed(connectionEvent));
    }

    private final class ConnectionHandle
    extends ConnectionWrapper {
        private boolean closed;

        public ConnectionHandle() {
            super((Connection)((Object)ArrowFlightJdbcPooledConnection.this.connection));
            this.closed = false;
        }

        @Override
        public void close() throws SQLException {
            if (!this.closed) {
                this.closed = true;
                ArrowFlightJdbcPooledConnection.this.onConnectionClosed();
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.closed || super.isClosed();
        }
    }
}

