/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcDriver;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.apache.arrow.util.Preconditions;

public class ArrowFlightJdbcDataSource
implements DataSource {
    private final Properties properties;
    private final ArrowFlightConnectionConfigImpl config;
    private PrintWriter logWriter;

    protected ArrowFlightJdbcDataSource(Properties properties, ArrowFlightConnectionConfigImpl config) {
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties);
        this.config = (ArrowFlightConnectionConfigImpl)((Object)Preconditions.checkNotNull((Object)((Object)config)));
    }

    protected final ArrowFlightConnectionConfigImpl getConfig() {
        return this.config;
    }

    protected final Properties getProperties(String username, String password) {
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)this.properties);
        if (username != null) {
            newProperties.replace(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), username);
        }
        if (password != null) {
            newProperties.replace(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), password);
        }
        return ArrowFlightJdbcDriver.lowerCasePropertyKeys(newProperties);
    }

    public static ArrowFlightJdbcDataSource createNewDataSource(Properties properties) {
        return new ArrowFlightJdbcDataSource(properties, new ArrowFlightConnectionConfigImpl(properties));
    }

    public ArrowFlightConnection getConnection() throws SQLException {
        return this.getConnection(this.config.getUser(), this.config.getPassword());
    }

    public ArrowFlightConnection getConnection(String username, String password) throws SQLException {
        Properties properties = this.getProperties(username, password);
        return new ArrowFlightJdbcDriver().connect(this.config.url(), properties);
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        throw new SQLException("ArrowFlightJdbcDataSource is not a wrapper.");
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) {
        return false;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        throw new SQLFeatureNotSupportedException("Setting Login timeout is not supported.");
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger("ArrowFlightJdbc");
    }
}

