/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcDriver;
import org.apache.arrow.driver.jdbc.ArrowFlightMetaImpl;
import org.apache.arrow.driver.jdbc.client.ArrowFlightSqlClientHandler;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.util.Preconditions;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaFactory;
import org.apache.calcite.avatica.UnregisteredDriver;

public final class ArrowFlightConnection
extends AvaticaConnection {
    private final BufferAllocator allocator;
    private final ArrowFlightSqlClientHandler clientHandler;
    private final ArrowFlightConnectionConfigImpl config;
    private ExecutorService executorService;

    private ArrowFlightConnection(ArrowFlightJdbcDriver driver, AvaticaFactory factory, String url, Properties properties, ArrowFlightConnectionConfigImpl config, BufferAllocator allocator, ArrowFlightSqlClientHandler clientHandler) {
        super((UnregisteredDriver)driver, factory, url, properties);
        this.config = (ArrowFlightConnectionConfigImpl)((Object)Preconditions.checkNotNull((Object)((Object)config), (Object)"Config cannot be null."));
        this.allocator = (BufferAllocator)Preconditions.checkNotNull((Object)allocator, (Object)"Allocator cannot be null.");
        this.clientHandler = (ArrowFlightSqlClientHandler)Preconditions.checkNotNull((Object)clientHandler, (Object)"Handler cannot be null.");
    }

    static ArrowFlightConnection createNewConnection(ArrowFlightJdbcDriver driver, AvaticaFactory factory, String url, Properties properties, BufferAllocator allocator) throws SQLException {
        url = ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.replaceSemiColons(url);
        ArrowFlightConnectionConfigImpl config = new ArrowFlightConnectionConfigImpl(properties);
        ArrowFlightSqlClientHandler clientHandler = ArrowFlightConnection.createNewClientHandler(config, allocator);
        return new ArrowFlightConnection(driver, factory, url, properties, config, allocator, clientHandler);
    }

    private static ArrowFlightSqlClientHandler createNewClientHandler(ArrowFlightConnectionConfigImpl config, BufferAllocator allocator) throws SQLException {
        try {
            return new ArrowFlightSqlClientHandler.Builder().withHost(config.getHost()).withPort(config.getPort()).withUsername(config.getUser()).withPassword(config.getPassword()).withTrustStorePath(config.getTrustStorePath()).withTrustStorePassword(config.getTrustStorePassword()).withSystemTrustStore(config.useSystemTrustStore()).withTlsRootCertificates(config.getTlsRootCertificatesPath()).withClientCertificate(config.getClientCertificatePath()).withClientKey(config.getClientKeyPath()).withBufferAllocator(allocator).withEncryption(config.useEncryption()).withDisableCertificateVerification(config.getDisableCertificateVerification()).withToken(config.getToken()).withCallOptions(config.toCallOption()).withRetainCookies(config.retainCookies()).withRetainAuth(config.retainAuth()).build();
        }
        catch (SQLException e) {
            try {
                allocator.close();
            }
            catch (Exception allocatorCloseEx) {
                e.addSuppressed(allocatorCloseEx);
            }
            throw e;
        }
    }

    void reset() throws SQLException {
        try {
            AutoCloseables.close(this.statementMap.values());
        }
        catch (Exception e) {
            throw AvaticaConnection.HELPER.createException(e.getMessage(), e);
        }
        this.statementMap.clear();
        this.setHoldability(this.metaData.getResultSetHoldability());
        ((ArrowFlightMetaImpl)this.meta).setDefaultConnectionProperties();
    }

    ArrowFlightSqlClientHandler getClientHandler() {
        return this.clientHandler;
    }

    synchronized ExecutorService getExecutorService() {
        this.executorService = this.executorService == null ? Executors.newFixedThreadPool(this.config.threadPoolSize(), (ThreadFactory)new DefaultThreadFactory(((Object)((Object)this)).getClass().getSimpleName())) : this.executorService;
        return this.executorService;
    }

    public Properties getClientInfo() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.info);
        return copy;
    }

    public void close() throws SQLException {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        try {
            AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.clientHandler});
            this.allocator.getChildAllocators().forEach(AutoCloseables::closeNoChecked);
            AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.allocator});
            super.close();
        }
        catch (Exception e) {
            throw AvaticaConnection.HELPER.createException(e.getMessage(), e);
        }
    }

    BufferAllocator getBufferAllocator() {
        return this.allocator;
    }

    public ArrowFlightMetaImpl getMeta() {
        return (ArrowFlightMetaImpl)this.meta;
    }
}

