/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import com.google.protobuf.ProtocolMessageEnum;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcFlightStreamResultSet;
import org.apache.arrow.driver.jdbc.utils.SqlTypes;
import org.apache.arrow.driver.jdbc.utils.VectorSchemaRootTransformer;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.sql.FlightSqlColumnMetadata;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.flight.sql.util.SqlInfoOptionsUtils;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaDatabaseMetaData;

public class ArrowDatabaseMetadata
extends AvaticaDatabaseMetaData {
    private static final String JAVA_REGEX_SPECIALS = "[]()|^-+*?{}$\\.";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final int NO_DECIMAL_DIGITS = 0;
    private static final int BASE10_RADIX = 10;
    static final int COLUMN_SIZE_BYTE = (int)Math.ceil(7.0 * Math.log(2.0) / Math.log(10.0));
    static final int COLUMN_SIZE_SHORT = (int)Math.ceil(15.0 * Math.log(2.0) / Math.log(10.0));
    static final int COLUMN_SIZE_INT = (int)Math.ceil(31.0 * Math.log(2.0) / Math.log(10.0));
    static final int COLUMN_SIZE_LONG = (int)Math.ceil(63.0 * Math.log(2.0) / Math.log(10.0));
    static final int COLUMN_SIZE_VARCHAR_AND_BINARY = 65536;
    static final int COLUMN_SIZE_DATE = "YYYY-MM-DD".length();
    static final int COLUMN_SIZE_TIME = "HH:MM:ss".length();
    static final int COLUMN_SIZE_TIME_MILLISECONDS = "HH:MM:ss.SSS".length();
    static final int COLUMN_SIZE_TIME_MICROSECONDS = "HH:MM:ss.SSSSSS".length();
    static final int COLUMN_SIZE_TIME_NANOSECONDS = "HH:MM:ss.SSSSSSSSS".length();
    static final int COLUMN_SIZE_TIMESTAMP_SECONDS = COLUMN_SIZE_DATE + 1 + COLUMN_SIZE_TIME;
    static final int COLUMN_SIZE_TIMESTAMP_MILLISECONDS = COLUMN_SIZE_DATE + 1 + COLUMN_SIZE_TIME_MILLISECONDS;
    static final int COLUMN_SIZE_TIMESTAMP_MICROSECONDS = COLUMN_SIZE_DATE + 1 + COLUMN_SIZE_TIME_MICROSECONDS;
    static final int COLUMN_SIZE_TIMESTAMP_NANOSECONDS = COLUMN_SIZE_DATE + 1 + COLUMN_SIZE_TIME_NANOSECONDS;
    static final int DECIMAL_DIGITS_TIME_MILLISECONDS = 3;
    static final int DECIMAL_DIGITS_TIME_MICROSECONDS = 6;
    static final int DECIMAL_DIGITS_TIME_NANOSECONDS = 9;
    private static final Schema GET_COLUMNS_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"TABLE_CAT", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"TABLE_SCHEM", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"TABLE_NAME", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"COLUMN_NAME", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"DATA_TYPE", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"TYPE_NAME", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"COLUMN_SIZE", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"BUFFER_LENGTH", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"DECIMAL_DIGITS", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"NUM_PREC_RADIX", (ArrowType)Types.MinorType.INT.getType()), Field.notNullable((String)"NULLABLE", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"REMARKS", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"COLUMN_DEF", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"SQL_DATA_TYPE", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"SQL_DATETIME_SUB", (ArrowType)Types.MinorType.INT.getType()), Field.notNullable((String)"CHAR_OCTET_LENGTH", (ArrowType)Types.MinorType.INT.getType()), Field.notNullable((String)"ORDINAL_POSITION", (ArrowType)Types.MinorType.INT.getType()), Field.notNullable((String)"IS_NULLABLE", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"SCOPE_CATALOG", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"SCOPE_SCHEMA", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"SCOPE_TABLE", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"SOURCE_DATA_TYPE", (ArrowType)Types.MinorType.SMALLINT.getType()), Field.notNullable((String)"IS_AUTOINCREMENT", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"IS_GENERATEDCOLUMN", (ArrowType)Types.MinorType.VARCHAR.getType())));
    private final AtomicBoolean isCachePopulated = new AtomicBoolean(false);
    private final Map<FlightSql.SqlInfo, Object> cachedSqlInfo = new EnumMap<FlightSql.SqlInfo, Object>(FlightSql.SqlInfo.class);
    private static final Map<Integer, Integer> sqlTypesToFlightEnumConvertTypes = new HashMap<Integer, Integer>();

    ArrowDatabaseMetadata(AvaticaConnection connection) {
        super(connection);
    }

    public String getDatabaseProductName() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.FLIGHT_SQL_SERVER_NAME, String.class);
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.FLIGHT_SQL_SERVER_VERSION, String.class);
    }

    public String getIdentifierQuoteString() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_IDENTIFIER_QUOTE_CHAR, String.class);
    }

    public boolean isReadOnly() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.FLIGHT_SQL_SERVER_READ_ONLY, Boolean.class);
    }

    public String getSQLKeywords() throws SQLException {
        return this.convertListSqlInfoToString(this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_KEYWORDS, List.class)).orElse("");
    }

    public String getNumericFunctions() throws SQLException {
        return this.convertListSqlInfoToString(this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_NUMERIC_FUNCTIONS, List.class)).orElse("");
    }

    public String getStringFunctions() throws SQLException {
        return this.convertListSqlInfoToString(this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_STRING_FUNCTIONS, List.class)).orElse("");
    }

    public String getSystemFunctions() throws SQLException {
        return this.convertListSqlInfoToString(this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SYSTEM_FUNCTIONS, List.class)).orElse("");
    }

    public String getTimeDateFunctions() throws SQLException {
        return this.convertListSqlInfoToString(this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_DATETIME_FUNCTIONS, List.class)).orElse("");
    }

    public String getSearchStringEscape() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SEARCH_STRING_ESCAPE, String.class);
    }

    public String getExtraNameCharacters() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_EXTRA_NAME_CHARACTERS, String.class);
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTS_COLUMN_ALIASING, Boolean.class);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_NULL_PLUS_NULL_IS_NULL, Boolean.class);
    }

    public boolean supportsConvert() throws SQLException {
        return !this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTS_CONVERT, Map.class).isEmpty();
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        Map sqlSupportsConvert = this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTS_CONVERT, Map.class);
        if (!sqlTypesToFlightEnumConvertTypes.containsKey(fromType)) {
            return false;
        }
        List list = (List)sqlSupportsConvert.get(sqlTypesToFlightEnumConvertTypes.get(fromType));
        return list != null && list.contains(sqlTypesToFlightEnumConvertTypes.get(toType));
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTS_TABLE_CORRELATION_NAMES, Boolean.class);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTS_DIFFERENT_TABLE_CORRELATION_NAMES, Boolean.class);
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTS_EXPRESSIONS_IN_ORDER_BY, Boolean.class);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTS_ORDER_BY_UNRELATED, Boolean.class);
    }

    public boolean supportsGroupBy() throws SQLException {
        int bitmask = this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_GROUP_BY, Integer.class);
        return bitmask != 0;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_GROUP_BY, (ProtocolMessageEnum)FlightSql.SqlSupportedGroupBy.SQL_GROUP_BY_UNRELATED);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTS_LIKE_ESCAPE_CLAUSE, Boolean.class);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTS_NON_NULLABLE_COLUMNS, Boolean.class);
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.checkEnumLevel(Arrays.asList(this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_GRAMMAR, (ProtocolMessageEnum)FlightSql.SupportedSqlGrammar.SQL_EXTENDED_GRAMMAR), this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_GRAMMAR, (ProtocolMessageEnum)FlightSql.SupportedSqlGrammar.SQL_CORE_GRAMMAR), this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_GRAMMAR, (ProtocolMessageEnum)FlightSql.SupportedSqlGrammar.SQL_MINIMUM_GRAMMAR)));
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.checkEnumLevel(Arrays.asList(this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_GRAMMAR, (ProtocolMessageEnum)FlightSql.SupportedSqlGrammar.SQL_EXTENDED_GRAMMAR), this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_GRAMMAR, (ProtocolMessageEnum)FlightSql.SupportedSqlGrammar.SQL_CORE_GRAMMAR)));
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_GRAMMAR, (ProtocolMessageEnum)FlightSql.SupportedSqlGrammar.SQL_EXTENDED_GRAMMAR);
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return this.checkEnumLevel(Arrays.asList(this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_ANSI92_SUPPORTED_LEVEL, (ProtocolMessageEnum)FlightSql.SupportedAnsi92SqlGrammarLevel.ANSI92_ENTRY_SQL), this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_ANSI92_SUPPORTED_LEVEL, (ProtocolMessageEnum)FlightSql.SupportedAnsi92SqlGrammarLevel.ANSI92_INTERMEDIATE_SQL), this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_ANSI92_SUPPORTED_LEVEL, (ProtocolMessageEnum)FlightSql.SupportedAnsi92SqlGrammarLevel.ANSI92_FULL_SQL)));
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return this.checkEnumLevel(Arrays.asList(this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_ANSI92_SUPPORTED_LEVEL, (ProtocolMessageEnum)FlightSql.SupportedAnsi92SqlGrammarLevel.ANSI92_ENTRY_SQL), this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_ANSI92_SUPPORTED_LEVEL, (ProtocolMessageEnum)FlightSql.SupportedAnsi92SqlGrammarLevel.ANSI92_INTERMEDIATE_SQL)));
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_ANSI92_SUPPORTED_LEVEL, (ProtocolMessageEnum)FlightSql.SupportedAnsi92SqlGrammarLevel.ANSI92_FULL_SQL);
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTS_INTEGRITY_ENHANCEMENT_FACILITY, Boolean.class);
    }

    public boolean supportsOuterJoins() throws SQLException {
        int bitmask = this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_OUTER_JOINS_SUPPORT_LEVEL, Integer.class);
        return bitmask != 0;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_OUTER_JOINS_SUPPORT_LEVEL, (ProtocolMessageEnum)FlightSql.SqlOuterJoinsSupportLevel.SQL_FULL_OUTER_JOINS);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_OUTER_JOINS_SUPPORT_LEVEL, (ProtocolMessageEnum)FlightSql.SqlOuterJoinsSupportLevel.SQL_LIMITED_OUTER_JOINS);
    }

    public String getSchemaTerm() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SCHEMA_TERM, String.class);
    }

    public String getProcedureTerm() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_PROCEDURE_TERM, String.class);
    }

    public String getCatalogTerm() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_CATALOG_TERM, String.class);
    }

    public boolean isCatalogAtStart() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_CATALOG_AT_START, Boolean.class);
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SCHEMAS_SUPPORTED_ACTIONS, (ProtocolMessageEnum)FlightSql.SqlSupportedElementActions.SQL_ELEMENT_IN_PROCEDURE_CALLS);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SCHEMAS_SUPPORTED_ACTIONS, (ProtocolMessageEnum)FlightSql.SqlSupportedElementActions.SQL_ELEMENT_IN_INDEX_DEFINITIONS);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SCHEMAS_SUPPORTED_ACTIONS, (ProtocolMessageEnum)FlightSql.SqlSupportedElementActions.SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_CATALOGS_SUPPORTED_ACTIONS, (ProtocolMessageEnum)FlightSql.SqlSupportedElementActions.SQL_ELEMENT_IN_INDEX_DEFINITIONS);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_CATALOGS_SUPPORTED_ACTIONS, (ProtocolMessageEnum)FlightSql.SqlSupportedElementActions.SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS);
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_POSITIONED_COMMANDS, (ProtocolMessageEnum)FlightSql.SqlSupportedPositionedCommands.SQL_POSITIONED_DELETE);
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_POSITIONED_COMMANDS, (ProtocolMessageEnum)FlightSql.SqlSupportedPositionedCommands.SQL_POSITIONED_UPDATE);
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        int bitmask = this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_RESULT_SET_TYPES, Integer.class);
        switch (type) {
            case 1003: {
                return SqlInfoOptionsUtils.doesBitmaskTranslateToEnum((ProtocolMessageEnum)FlightSql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_FORWARD_ONLY, (long)bitmask);
            }
            case 1004: {
                return SqlInfoOptionsUtils.doesBitmaskTranslateToEnum((ProtocolMessageEnum)FlightSql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE, (long)bitmask);
            }
            case 1005: {
                return SqlInfoOptionsUtils.doesBitmaskTranslateToEnum((ProtocolMessageEnum)FlightSql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_SCROLL_SENSITIVE, (long)bitmask);
            }
        }
        throw new SQLException("Invalid result set type argument. The informed type is not defined in java.sql.ResultSet.");
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SELECT_FOR_UPDATE_SUPPORTED, Boolean.class);
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_STORED_PROCEDURES_SUPPORTED, Boolean.class);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_SUBQUERIES, (ProtocolMessageEnum)FlightSql.SqlSupportedSubqueries.SQL_SUBQUERIES_IN_COMPARISONS);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_SUBQUERIES, (ProtocolMessageEnum)FlightSql.SqlSupportedSubqueries.SQL_SUBQUERIES_IN_EXISTS);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_SUBQUERIES, (ProtocolMessageEnum)FlightSql.SqlSupportedSubqueries.SQL_SUBQUERIES_IN_INS);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_SUBQUERIES, (ProtocolMessageEnum)FlightSql.SqlSupportedSubqueries.SQL_SUBQUERIES_IN_QUANTIFIEDS);
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_CORRELATED_SUBQUERIES_SUPPORTED, Boolean.class);
    }

    public boolean supportsUnion() throws SQLException {
        int bitmask = this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_UNIONS, Integer.class);
        return bitmask != 0;
    }

    public boolean supportsUnionAll() throws SQLException {
        return this.getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_UNIONS, (ProtocolMessageEnum)FlightSql.SqlSupportedUnions.SQL_UNION_ALL);
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_BINARY_LITERAL_LENGTH, Long.class).intValue();
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_CHAR_LITERAL_LENGTH, Long.class).intValue();
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_COLUMN_NAME_LENGTH, Long.class).intValue();
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_COLUMNS_IN_GROUP_BY, Long.class).intValue();
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_COLUMNS_IN_INDEX, Long.class).intValue();
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_COLUMNS_IN_ORDER_BY, Long.class).intValue();
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_COLUMNS_IN_SELECT, Long.class).intValue();
    }

    public int getMaxColumnsInTable() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_COLUMNS_IN_TABLE, Long.class).intValue();
    }

    public int getMaxConnections() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_CONNECTIONS, Long.class).intValue();
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_CURSOR_NAME_LENGTH, Long.class).intValue();
    }

    public int getMaxIndexLength() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_INDEX_LENGTH, Long.class).intValue();
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_DB_SCHEMA_NAME_LENGTH, Long.class).intValue();
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_PROCEDURE_NAME_LENGTH, Long.class).intValue();
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_CATALOG_NAME_LENGTH, Long.class).intValue();
    }

    public int getMaxRowSize() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_ROW_SIZE, Long.class).intValue();
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_ROW_SIZE_INCLUDES_BLOBS, Boolean.class);
    }

    public int getMaxStatementLength() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_STATEMENT_LENGTH, Long.class).intValue();
    }

    public int getMaxStatements() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_STATEMENTS, Long.class).intValue();
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_TABLE_NAME_LENGTH, Long.class).intValue();
    }

    public int getMaxTablesInSelect() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_TABLES_IN_SELECT, Long.class).intValue();
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_MAX_USERNAME_LENGTH, Long.class).intValue();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_DEFAULT_TRANSACTION_ISOLATION, Long.class).intValue();
    }

    public boolean supportsTransactions() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_TRANSACTIONS_SUPPORTED, Boolean.class);
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        int bitmask = this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SUPPORTED_TRANSACTIONS_ISOLATION_LEVELS, Integer.class);
        switch (level) {
            case 0: {
                return SqlInfoOptionsUtils.doesBitmaskTranslateToEnum((ProtocolMessageEnum)FlightSql.SqlTransactionIsolationLevel.SQL_TRANSACTION_NONE, (long)bitmask);
            }
            case 2: {
                return SqlInfoOptionsUtils.doesBitmaskTranslateToEnum((ProtocolMessageEnum)FlightSql.SqlTransactionIsolationLevel.SQL_TRANSACTION_READ_COMMITTED, (long)bitmask);
            }
            case 1: {
                return SqlInfoOptionsUtils.doesBitmaskTranslateToEnum((ProtocolMessageEnum)FlightSql.SqlTransactionIsolationLevel.SQL_TRANSACTION_READ_UNCOMMITTED, (long)bitmask);
            }
            case 4: {
                return SqlInfoOptionsUtils.doesBitmaskTranslateToEnum((ProtocolMessageEnum)FlightSql.SqlTransactionIsolationLevel.SQL_TRANSACTION_REPEATABLE_READ, (long)bitmask);
            }
            case 8: {
                return SqlInfoOptionsUtils.doesBitmaskTranslateToEnum((ProtocolMessageEnum)FlightSql.SqlTransactionIsolationLevel.SQL_TRANSACTION_SERIALIZABLE, (long)bitmask);
            }
        }
        throw new SQLException("Invalid transaction isolation level argument. The informed level is not defined in java.sql.Connection.");
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_DATA_DEFINITION_CAUSES_TRANSACTION_COMMIT, Boolean.class);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_DATA_DEFINITIONS_IN_TRANSACTIONS_IGNORED, Boolean.class);
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_BATCH_UPDATES_SUPPORTED, Boolean.class);
    }

    public boolean supportsSavepoints() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_SAVEPOINTS_SUPPORTED, Boolean.class);
    }

    public boolean supportsNamedParameters() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_NAMED_PARAMETERS_SUPPORTED, Boolean.class);
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_LOCATORS_UPDATE_COPY, Boolean.class);
    }

    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return this.getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo.SQL_STORED_FUNCTIONS_USING_CALL_SYNTAX_SUPPORTED, Boolean.class);
    }

    public ArrowFlightConnection getConnection() throws SQLException {
        return (ArrowFlightConnection)((Object)super.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getSqlInfoAndCacheIfCacheIsEmpty(FlightSql.SqlInfo sqlInfoCommand, Class<T> desiredType) throws SQLException {
        ArrowFlightConnection connection = this.getConnection();
        if (!this.isCachePopulated.get()) {
            Map<FlightSql.SqlInfo, Object> map = this.cachedSqlInfo;
            synchronized (map) {
                if (this.cachedSqlInfo.isEmpty()) {
                    FlightInfo sqlInfo = connection.getClientHandler().getSqlInfo(new FlightSql.SqlInfo[0]);
                    try (ArrowFlightJdbcFlightStreamResultSet resultSet = ArrowFlightJdbcFlightStreamResultSet.fromFlightInfo(connection, sqlInfo, null);){
                        while (resultSet.next()) {
                            this.cachedSqlInfo.put(FlightSql.SqlInfo.forNumber((int)((Integer)resultSet.getObject("info_name"))), resultSet.getObject("value"));
                        }
                    }
                    this.isCachePopulated.set(true);
                }
            }
        }
        return desiredType.cast(this.cachedSqlInfo.get(sqlInfoCommand));
    }

    private Optional<String> convertListSqlInfoToString(List<?> sqlInfoList) {
        if (sqlInfoList == null) {
            return Optional.empty();
        }
        return Optional.of(sqlInfoList.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    private boolean getSqlInfoEnumOptionAndCacheIfCacheIsEmpty(FlightSql.SqlInfo sqlInfoCommand, ProtocolMessageEnum enumInstance) throws SQLException {
        int bitmask = this.getSqlInfoAndCacheIfCacheIsEmpty(sqlInfoCommand, Integer.class);
        return SqlInfoOptionsUtils.doesBitmaskTranslateToEnum((ProtocolMessageEnum)enumInstance, (long)bitmask);
    }

    private boolean checkEnumLevel(List<Boolean> toCheck) {
        return toCheck.stream().anyMatch(e -> e);
    }

    public ResultSet getCatalogs() throws SQLException {
        ArrowFlightConnection connection = this.getConnection();
        FlightInfo flightInfoCatalogs = connection.getClientHandler().getCatalogs();
        BufferAllocator allocator = connection.getBufferAllocator();
        VectorSchemaRootTransformer transformer = new VectorSchemaRootTransformer.Builder(FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA, allocator).renameFieldVector("catalog_name", "TABLE_CAT").build();
        return ArrowFlightJdbcFlightStreamResultSet.fromFlightInfo(connection, flightInfoCatalogs, transformer);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        ArrowFlightConnection connection = this.getConnection();
        FlightInfo flightInfoImportedKeys = connection.getClientHandler().getImportedKeys(catalog, schema, table);
        BufferAllocator allocator = connection.getBufferAllocator();
        VectorSchemaRootTransformer transformer = this.getForeignKeysTransformer(allocator);
        return ArrowFlightJdbcFlightStreamResultSet.fromFlightInfo(connection, flightInfoImportedKeys, transformer);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        ArrowFlightConnection connection = this.getConnection();
        FlightInfo flightInfoExportedKeys = connection.getClientHandler().getExportedKeys(catalog, schema, table);
        BufferAllocator allocator = connection.getBufferAllocator();
        VectorSchemaRootTransformer transformer = this.getForeignKeysTransformer(allocator);
        return ArrowFlightJdbcFlightStreamResultSet.fromFlightInfo(connection, flightInfoExportedKeys, transformer);
    }

    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        ArrowFlightConnection connection = this.getConnection();
        FlightInfo flightInfoCrossReference = connection.getClientHandler().getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        BufferAllocator allocator = connection.getBufferAllocator();
        VectorSchemaRootTransformer transformer = this.getForeignKeysTransformer(allocator);
        return ArrowFlightJdbcFlightStreamResultSet.fromFlightInfo(connection, flightInfoCrossReference, transformer);
    }

    private VectorSchemaRootTransformer getForeignKeysTransformer(BufferAllocator allocator) {
        return new VectorSchemaRootTransformer.Builder(FlightSqlProducer.Schemas.GET_IMPORTED_KEYS_SCHEMA, allocator).renameFieldVector("pk_catalog_name", "PKTABLE_CAT").renameFieldVector("pk_db_schema_name", "PKTABLE_SCHEM").renameFieldVector("pk_table_name", "PKTABLE_NAME").renameFieldVector("pk_column_name", "PKCOLUMN_NAME").renameFieldVector("fk_catalog_name", "FKTABLE_CAT").renameFieldVector("fk_db_schema_name", "FKTABLE_SCHEM").renameFieldVector("fk_table_name", "FKTABLE_NAME").renameFieldVector("fk_column_name", "FKCOLUMN_NAME").renameFieldVector("key_sequence", "KEY_SEQ").renameFieldVector("fk_key_name", "FK_NAME").renameFieldVector("pk_key_name", "PK_NAME").renameFieldVector("update_rule", "UPDATE_RULE").renameFieldVector("delete_rule", "DELETE_RULE").addEmptyField("DEFERRABILITY", (ArrowType)new ArrowType.Int(8, false)).build();
    }

    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        ArrowFlightConnection connection = this.getConnection();
        FlightInfo flightInfoSchemas = connection.getClientHandler().getSchemas(catalog, schemaPattern);
        BufferAllocator allocator = connection.getBufferAllocator();
        VectorSchemaRootTransformer transformer = new VectorSchemaRootTransformer.Builder(FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA, allocator).renameFieldVector("db_schema_name", "TABLE_SCHEM").renameFieldVector("catalog_name", "TABLE_CATALOG").build();
        return ArrowFlightJdbcFlightStreamResultSet.fromFlightInfo(connection, flightInfoSchemas, transformer);
    }

    public ResultSet getTableTypes() throws SQLException {
        ArrowFlightConnection connection = this.getConnection();
        FlightInfo flightInfoTableTypes = connection.getClientHandler().getTableTypes();
        BufferAllocator allocator = connection.getBufferAllocator();
        VectorSchemaRootTransformer transformer = new VectorSchemaRootTransformer.Builder(FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA, allocator).renameFieldVector("table_type", "TABLE_TYPE").build();
        return ArrowFlightJdbcFlightStreamResultSet.fromFlightInfo(connection, flightInfoTableTypes, transformer);
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ArrowFlightConnection connection = this.getConnection();
        List<String> typesList = types == null ? null : Arrays.asList(types);
        FlightInfo flightInfoTables = connection.getClientHandler().getTables(catalog, schemaPattern, tableNamePattern, typesList, false);
        BufferAllocator allocator = connection.getBufferAllocator();
        VectorSchemaRootTransformer transformer = new VectorSchemaRootTransformer.Builder(FlightSqlProducer.Schemas.GET_TABLES_SCHEMA_NO_SCHEMA, allocator).renameFieldVector("catalog_name", "TABLE_CAT").renameFieldVector("db_schema_name", "TABLE_SCHEM").renameFieldVector("table_name", "TABLE_NAME").renameFieldVector("table_type", "TABLE_TYPE").addEmptyField("REMARKS", Types.MinorType.VARBINARY).addEmptyField("TYPE_CAT", Types.MinorType.VARBINARY).addEmptyField("TYPE_SCHEM", Types.MinorType.VARBINARY).addEmptyField("TYPE_NAME", Types.MinorType.VARBINARY).addEmptyField("SELF_REFERENCING_COL_NAME", Types.MinorType.VARBINARY).addEmptyField("REF_GENERATION", Types.MinorType.VARBINARY).build();
        return ArrowFlightJdbcFlightStreamResultSet.fromFlightInfo(connection, flightInfoTables, transformer);
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        ArrowFlightConnection connection = this.getConnection();
        FlightInfo flightInfoPrimaryKeys = connection.getClientHandler().getPrimaryKeys(catalog, schema, table);
        BufferAllocator allocator = connection.getBufferAllocator();
        VectorSchemaRootTransformer transformer = new VectorSchemaRootTransformer.Builder(FlightSqlProducer.Schemas.GET_PRIMARY_KEYS_SCHEMA, allocator).renameFieldVector("catalog_name", "TABLE_CAT").renameFieldVector("db_schema_name", "TABLE_SCHEM").renameFieldVector("table_name", "TABLE_NAME").renameFieldVector("column_name", "COLUMN_NAME").renameFieldVector("key_sequence", "KEY_SEQ").renameFieldVector("key_name", "PK_NAME").build();
        return ArrowFlightJdbcFlightStreamResultSet.fromFlightInfo(connection, flightInfoPrimaryKeys, transformer);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ArrowFlightConnection connection = this.getConnection();
        FlightInfo flightInfoTables = connection.getClientHandler().getTables(catalog, schemaPattern, tableNamePattern, null, true);
        BufferAllocator allocator = connection.getBufferAllocator();
        Pattern columnNamePat = columnNamePattern != null ? Pattern.compile(ArrowDatabaseMetadata.sqlToRegexLike(columnNamePattern)) : null;
        return ArrowFlightJdbcFlightStreamResultSet.fromFlightInfo(connection, flightInfoTables, (originalRoot, transformedRoot) -> {
            int columnCounter = 0;
            if (transformedRoot == null) {
                transformedRoot = VectorSchemaRoot.create((Schema)GET_COLUMNS_SCHEMA, (BufferAllocator)allocator);
            }
            int originalRootRowCount = originalRoot.getRowCount();
            VarCharVector catalogNameVector = (VarCharVector)originalRoot.getVector("catalog_name");
            VarCharVector tableNameVector = (VarCharVector)originalRoot.getVector("table_name");
            VarCharVector schemaNameVector = (VarCharVector)originalRoot.getVector("db_schema_name");
            VarBinaryVector schemaVector = (VarBinaryVector)originalRoot.getVector("table_schema");
            for (int i = 0; i < originalRootRowCount; ++i) {
                Schema currentSchema;
                Text catalogName = catalogNameVector.getObject(i);
                Text tableName = tableNameVector.getObject(i);
                Text schemaName = schemaNameVector.getObject(i);
                try {
                    currentSchema = MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel(new ByteArrayInputStream(schemaVector.get(i)))));
                }
                catch (IOException e) {
                    throw new IOException(String.format("Failed to deserialize schema for table %s", tableName), e);
                }
                List tableColumns = currentSchema.getFields();
                columnCounter = this.setGetColumnsVectorSchemaRootFromFields(transformedRoot, columnCounter, tableColumns, catalogName, tableName, schemaName, columnNamePat);
            }
            transformedRoot.setRowCount(columnCounter);
            originalRoot.clear();
            return transformedRoot;
        });
    }

    private int setGetColumnsVectorSchemaRootFromFields(VectorSchemaRoot currentRoot, int insertIndex, List<Field> tableColumns, Text catalogName, Text tableName, Text schemaName, Pattern columnNamePattern) {
        int ordinalIndex = 1;
        int tableColumnsSize = tableColumns.size();
        VarCharVector tableCatVector = (VarCharVector)currentRoot.getVector("TABLE_CAT");
        VarCharVector tableSchemVector = (VarCharVector)currentRoot.getVector("TABLE_SCHEM");
        VarCharVector tableNameVector = (VarCharVector)currentRoot.getVector("TABLE_NAME");
        VarCharVector columnNameVector = (VarCharVector)currentRoot.getVector("COLUMN_NAME");
        IntVector dataTypeVector = (IntVector)currentRoot.getVector("DATA_TYPE");
        VarCharVector typeNameVector = (VarCharVector)currentRoot.getVector("TYPE_NAME");
        IntVector columnSizeVector = (IntVector)currentRoot.getVector("COLUMN_SIZE");
        IntVector decimalDigitsVector = (IntVector)currentRoot.getVector("DECIMAL_DIGITS");
        IntVector numPrecRadixVector = (IntVector)currentRoot.getVector("NUM_PREC_RADIX");
        IntVector nullableVector = (IntVector)currentRoot.getVector("NULLABLE");
        IntVector ordinalPositionVector = (IntVector)currentRoot.getVector("ORDINAL_POSITION");
        VarCharVector isNullableVector = (VarCharVector)currentRoot.getVector("IS_NULLABLE");
        VarCharVector isAutoincrementVector = (VarCharVector)currentRoot.getVector("IS_AUTOINCREMENT");
        VarCharVector isGeneratedColumnVector = (VarCharVector)currentRoot.getVector("IS_GENERATEDCOLUMN");
        int i = 0;
        while (i < tableColumnsSize) {
            Field field = tableColumns.get(i);
            FlightSqlColumnMetadata columnMetadata = new FlightSqlColumnMetadata(field.getMetadata());
            String columnName = field.getName();
            if (columnNamePattern == null || columnNamePattern.matcher(columnName).matches()) {
                Integer columnSize;
                ArrowType fieldType = field.getType();
                if (catalogName != null) {
                    tableCatVector.setSafe(insertIndex, catalogName);
                }
                if (schemaName != null) {
                    tableSchemVector.setSafe(insertIndex, schemaName);
                }
                if (tableName != null) {
                    tableNameVector.setSafe(insertIndex, tableName);
                }
                if (columnName != null) {
                    columnNameVector.setSafe(insertIndex, columnName.getBytes(CHARSET));
                }
                dataTypeVector.setSafe(insertIndex, SqlTypes.getSqlTypeIdFromArrowType(fieldType));
                byte[] typeName = columnMetadata.getTypeName() != null ? columnMetadata.getTypeName().getBytes(CHARSET) : SqlTypes.getSqlTypeNameFromArrowType(fieldType).getBytes(CHARSET);
                typeNameVector.setSafe(insertIndex, typeName);
                if (fieldType instanceof ArrowType.Decimal) {
                    numPrecRadixVector.setSafe(insertIndex, 10);
                } else if (fieldType instanceof ArrowType.Int) {
                    numPrecRadixVector.setSafe(insertIndex, 10);
                } else if (fieldType instanceof ArrowType.FloatingPoint) {
                    numPrecRadixVector.setSafe(insertIndex, 10);
                }
                Integer decimalDigits = columnMetadata.getScale();
                if (decimalDigits == null) {
                    decimalDigits = ArrowDatabaseMetadata.getDecimalDigits(fieldType);
                }
                if (decimalDigits != null) {
                    decimalDigitsVector.setSafe(insertIndex, decimalDigits.intValue());
                }
                if ((columnSize = columnMetadata.getPrecision()) == null) {
                    columnSize = ArrowDatabaseMetadata.getColumnSize(fieldType);
                }
                if (columnSize != null) {
                    columnSizeVector.setSafe(insertIndex, columnSize.intValue());
                }
                nullableVector.setSafe(insertIndex, field.isNullable() ? 1 : 0);
                isNullableVector.setSafe(insertIndex, ArrowDatabaseMetadata.booleanToYesOrNo(field.isNullable()));
                Boolean autoIncrement = columnMetadata.isAutoIncrement();
                if (autoIncrement != null) {
                    isAutoincrementVector.setSafe(insertIndex, ArrowDatabaseMetadata.booleanToYesOrNo(autoIncrement));
                } else {
                    isAutoincrementVector.setSafe(insertIndex, EMPTY_BYTE_ARRAY);
                }
                isGeneratedColumnVector.setSafe(insertIndex, EMPTY_BYTE_ARRAY);
                ordinalPositionVector.setSafe(insertIndex, ordinalIndex);
                ++insertIndex;
            }
            ++i;
            ++ordinalIndex;
        }
        return insertIndex;
    }

    private static byte[] booleanToYesOrNo(boolean autoIncrement) {
        return autoIncrement ? "YES".getBytes(CHARSET) : "NO".getBytes(CHARSET);
    }

    static Integer getDecimalDigits(ArrowType fieldType) {
        if (fieldType instanceof ArrowType.Decimal) {
            ArrowType.Decimal thisDecimal = (ArrowType.Decimal)fieldType;
            return thisDecimal.getScale();
        }
        if (fieldType instanceof ArrowType.Int) {
            return 0;
        }
        if (fieldType instanceof ArrowType.Timestamp) {
            switch (((ArrowType.Timestamp)fieldType).getUnit()) {
                case SECOND: {
                    return 0;
                }
                case MILLISECOND: {
                    return 3;
                }
                case MICROSECOND: {
                    return 6;
                }
                case NANOSECOND: {
                    return 9;
                }
            }
        } else if (fieldType instanceof ArrowType.Time) {
            switch (((ArrowType.Time)fieldType).getUnit()) {
                case SECOND: {
                    return 0;
                }
                case MILLISECOND: {
                    return 3;
                }
                case MICROSECOND: {
                    return 6;
                }
                case NANOSECOND: {
                    return 9;
                }
            }
        } else if (fieldType instanceof ArrowType.Date) {
            return 0;
        }
        return null;
    }

    static Integer getColumnSize(ArrowType fieldType) {
        if (fieldType instanceof ArrowType.Decimal) {
            ArrowType.Decimal thisDecimal = (ArrowType.Decimal)fieldType;
            return thisDecimal.getPrecision();
        }
        if (fieldType instanceof ArrowType.Int) {
            ArrowType.Int thisInt = (ArrowType.Int)fieldType;
            switch (thisInt.getBitWidth()) {
                case 8: {
                    return COLUMN_SIZE_BYTE;
                }
                case 16: {
                    return COLUMN_SIZE_SHORT;
                }
                case 32: {
                    return COLUMN_SIZE_INT;
                }
                case 64: {
                    return COLUMN_SIZE_LONG;
                }
            }
        } else {
            if (fieldType instanceof ArrowType.Utf8 || fieldType instanceof ArrowType.Binary) {
                return 65536;
            }
            if (fieldType instanceof ArrowType.Timestamp) {
                switch (((ArrowType.Timestamp)fieldType).getUnit()) {
                    case SECOND: {
                        return COLUMN_SIZE_TIMESTAMP_SECONDS;
                    }
                    case MILLISECOND: {
                        return COLUMN_SIZE_TIMESTAMP_MILLISECONDS;
                    }
                    case MICROSECOND: {
                        return COLUMN_SIZE_TIMESTAMP_MICROSECONDS;
                    }
                    case NANOSECOND: {
                        return COLUMN_SIZE_TIMESTAMP_NANOSECONDS;
                    }
                }
            } else if (fieldType instanceof ArrowType.Time) {
                switch (((ArrowType.Time)fieldType).getUnit()) {
                    case SECOND: {
                        return COLUMN_SIZE_TIME;
                    }
                    case MILLISECOND: {
                        return COLUMN_SIZE_TIME_MILLISECONDS;
                    }
                    case MICROSECOND: {
                        return COLUMN_SIZE_TIME_MICROSECONDS;
                    }
                    case NANOSECOND: {
                        return COLUMN_SIZE_TIME_NANOSECONDS;
                    }
                }
            } else if (fieldType instanceof ArrowType.Date) {
                return COLUMN_SIZE_DATE;
            }
        }
        return null;
    }

    static String sqlToRegexLike(String sqlPattern) {
        int len = sqlPattern.length();
        StringBuilder javaPattern = new StringBuilder(len + len);
        block4: for (int i = 0; i < len; ++i) {
            char currentChar = sqlPattern.charAt(i);
            if (JAVA_REGEX_SPECIALS.indexOf(currentChar) >= 0) {
                javaPattern.append('\\');
            }
            switch (currentChar) {
                case '_': {
                    javaPattern.append('.');
                    continue block4;
                }
                case '%': {
                    javaPattern.append(".");
                    javaPattern.append('*');
                    continue block4;
                }
                default: {
                    javaPattern.append(currentChar);
                }
            }
        }
        return javaPattern.toString();
    }

    static {
        sqlTypesToFlightEnumConvertTypes.put(-7, 2);
        sqlTypesToFlightEnumConvertTypes.put(4, 7);
        sqlTypesToFlightEnumConvertTypes.put(2, 12);
        sqlTypesToFlightEnumConvertTypes.put(5, 14);
        sqlTypesToFlightEnumConvertTypes.put(-6, 17);
        sqlTypesToFlightEnumConvertTypes.put(6, 6);
        sqlTypesToFlightEnumConvertTypes.put(-5, 0);
        sqlTypesToFlightEnumConvertTypes.put(7, 13);
        sqlTypesToFlightEnumConvertTypes.put(3, 5);
        sqlTypesToFlightEnumConvertTypes.put(-2, 1);
        sqlTypesToFlightEnumConvertTypes.put(-4, 10);
        sqlTypesToFlightEnumConvertTypes.put(1, 3);
        sqlTypesToFlightEnumConvertTypes.put(12, 19);
        sqlTypesToFlightEnumConvertTypes.put(-16, 11);
        sqlTypesToFlightEnumConvertTypes.put(91, 4);
        sqlTypesToFlightEnumConvertTypes.put(93, 16);
    }
}

