/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.driver.jdbc.utils.VectorSchemaRootTransformer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class VectorSchemaRootTransformerTest {
    @Rule
    public RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    private final BufferAllocator rootAllocator = this.rootAllocatorTestRule.getRootAllocator();

    @Test
    public void testTransformerBuilderWorksCorrectly() throws Exception {
        VarBinaryVector field1 = this.rootAllocatorTestRule.createVarBinaryVector("FIELD_1");
        VarBinaryVector field2 = this.rootAllocatorTestRule.createVarBinaryVector("FIELD_2");
        VarBinaryVector field3 = this.rootAllocatorTestRule.createVarBinaryVector("FIELD_3");
        try (VectorSchemaRoot originalRoot = VectorSchemaRoot.of((FieldVector[])new FieldVector[]{field1, field2, field3});
             VectorSchemaRoot clonedRoot = this.cloneVectorSchemaRoot(originalRoot);){
            VectorSchemaRootTransformer.Builder builder = new VectorSchemaRootTransformer.Builder(originalRoot.getSchema(), this.rootAllocator);
            builder.renameFieldVector("FIELD_3", "FIELD_3_RENAMED");
            builder.addEmptyField("EMPTY_FIELD", (ArrowType)new ArrowType.Bool());
            builder.renameFieldVector("FIELD_2", "FIELD_2_RENAMED");
            builder.renameFieldVector("FIELD_1", "FIELD_1_RENAMED");
            VectorSchemaRootTransformer transformer = builder.build();
            Schema transformedSchema = new Schema((Iterable)ImmutableList.of((Object)Field.nullable((String)"FIELD_3_RENAMED", (ArrowType)new ArrowType.Binary()), (Object)Field.nullable((String)"EMPTY_FIELD", (ArrowType)new ArrowType.Bool()), (Object)Field.nullable((String)"FIELD_2_RENAMED", (ArrowType)new ArrowType.Binary()), (Object)Field.nullable((String)"FIELD_1_RENAMED", (ArrowType)new ArrowType.Binary())));
            try (VectorSchemaRoot transformedRoot = this.createVectorSchemaRoot(transformedSchema);){
                Assert.assertSame((Object)transformedRoot, (Object)transformer.transform(clonedRoot, transformedRoot));
                Assert.assertEquals((Object)transformedSchema, (Object)transformedRoot.getSchema());
                int rowCount = originalRoot.getRowCount();
                Assert.assertEquals((long)rowCount, (long)transformedRoot.getRowCount());
                VarBinaryVector originalField1 = (VarBinaryVector)originalRoot.getVector("FIELD_1");
                VarBinaryVector originalField2 = (VarBinaryVector)originalRoot.getVector("FIELD_2");
                VarBinaryVector originalField3 = (VarBinaryVector)originalRoot.getVector("FIELD_3");
                VarBinaryVector transformedField1 = (VarBinaryVector)transformedRoot.getVector("FIELD_1_RENAMED");
                VarBinaryVector transformedField2 = (VarBinaryVector)transformedRoot.getVector("FIELD_2_RENAMED");
                VarBinaryVector transformedField3 = (VarBinaryVector)transformedRoot.getVector("FIELD_3_RENAMED");
                FieldVector emptyField = transformedRoot.getVector("EMPTY_FIELD");
                for (int i = 0; i < rowCount; ++i) {
                    Assert.assertArrayEquals((byte[])originalField1.getObject(i), (byte[])transformedField1.getObject(i));
                    Assert.assertArrayEquals((byte[])originalField2.getObject(i), (byte[])transformedField2.getObject(i));
                    Assert.assertArrayEquals((byte[])originalField3.getObject(i), (byte[])transformedField3.getObject(i));
                    Assert.assertNull((Object)emptyField.getObject(i));
                }
            }
        }
    }

    private VectorSchemaRoot cloneVectorSchemaRoot(VectorSchemaRoot originalRoot) {
        VectorUnloader vectorUnloader = new VectorUnloader(originalRoot);
        try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();){
            VectorSchemaRoot clonedRoot = this.createVectorSchemaRoot(originalRoot.getSchema());
            VectorLoader vectorLoader = new VectorLoader(clonedRoot);
            vectorLoader.load(recordBatch);
            VectorSchemaRoot vectorSchemaRoot = clonedRoot;
            return vectorSchemaRoot;
        }
    }

    private VectorSchemaRoot createVectorSchemaRoot(Schema schema) {
        List fieldVectors = schema.getFields().stream().map(field -> field.createVector(this.rootAllocator)).collect(Collectors.toList());
        return new VectorSchemaRoot(fieldVectors);
    }
}

