/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.util.Map;
import org.apache.arrow.driver.jdbc.utils.UrlParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UrlParserTest {
    UrlParserTest() {
    }

    @Test
    void parse() {
        Map parsed = UrlParser.parse((String)"foo=bar&123=456", (String)"&");
        Assertions.assertEquals(parsed.get("foo"), (Object)"bar");
        Assertions.assertEquals(parsed.get("123"), (Object)"456");
    }

    @Test
    void parseEscaped() {
        Map parsed = UrlParser.parse((String)"foo=bar%26&%26123=456", (String)"&");
        Assertions.assertEquals(parsed.get("foo"), (Object)"bar&");
        Assertions.assertEquals(parsed.get("&123"), (Object)"456");
    }

    @Test
    void parseEmpty() {
        Map parsed = UrlParser.parse((String)"a=&b&foo=bar&123=456", (String)"&");
        Assertions.assertEquals(parsed.get("a"), (Object)"");
        Assertions.assertNull(parsed.get("b"));
        Assertions.assertEquals(parsed.get("foo"), (Object)"bar");
        Assertions.assertEquals(parsed.get("123"), (Object)"456");
    }
}

