/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

public class ThrowableAssertionUtils {
    private ThrowableAssertionUtils() {
    }

    public static void simpleAssertThrowableClass(Class<? extends Throwable> expectedThrowable, ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable actualThrown) {
            if (expectedThrowable.isInstance(actualThrown)) {
                return;
            }
            String mismatchMessage = String.format("unexpected exception type thrown;\nexpected: %s\nactual: %s", ThrowableAssertionUtils.formatClass(expectedThrowable), ThrowableAssertionUtils.formatClass(actualThrown.getClass()));
            throw new AssertionError(mismatchMessage, actualThrown);
        }
        String notThrownMessage = String.format("expected %s to be thrown, but nothing was thrown", ThrowableAssertionUtils.formatClass(expectedThrowable));
        throw new AssertionError((Object)notThrownMessage);
    }

    private static String formatClass(Class<?> value) {
        String className = value.getCanonicalName();
        return className == null ? value.getName() : className;
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

