/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import org.apache.arrow.driver.jdbc.utils.SqlTypes;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.Assert;
import org.junit.Test;

public class SqlTypesTest {
    @Test
    public void testGetSqlTypeIdFromArrowType() {
        Assert.assertEquals((long)-6L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Int(8, true)));
        Assert.assertEquals((long)5L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Int(16, true)));
        Assert.assertEquals((long)4L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Int(32, true)));
        Assert.assertEquals((long)-5L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Int(64, true)));
        Assert.assertEquals((long)-2L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.FixedSizeBinary(1024)));
        Assert.assertEquals((long)-3L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Binary()));
        Assert.assertEquals((long)-4L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.LargeBinary()));
        Assert.assertEquals((long)12L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Utf8()));
        Assert.assertEquals((long)-1L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.LargeUtf8()));
        Assert.assertEquals((long)91L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Date(DateUnit.MILLISECOND)));
        Assert.assertEquals((long)92L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32)));
        Assert.assertEquals((long)93L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "")));
        Assert.assertEquals((long)16L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Bool()));
        Assert.assertEquals((long)3L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Decimal(0, 0, 64)));
        Assert.assertEquals((long)8L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)));
        Assert.assertEquals((long)6L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)));
        Assert.assertEquals((long)2003L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.List()));
        Assert.assertEquals((long)2003L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.LargeList()));
        Assert.assertEquals((long)2003L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.FixedSizeList(10)));
        Assert.assertEquals((long)2000L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Struct()));
        Assert.assertEquals((long)2000L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Duration(TimeUnit.MILLISECOND)));
        Assert.assertEquals((long)2000L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Interval(IntervalUnit.DAY_TIME)));
        Assert.assertEquals((long)2000L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Union(UnionMode.Dense, null)));
        Assert.assertEquals((long)2000L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Map(true)));
        Assert.assertEquals((long)0L, (long)SqlTypes.getSqlTypeIdFromArrowType((ArrowType)new ArrowType.Null()));
    }

    @Test
    public void testGetSqlTypeNameFromArrowType() {
        Assert.assertEquals((Object)"TINYINT", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Int(8, true)));
        Assert.assertEquals((Object)"SMALLINT", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Int(16, true)));
        Assert.assertEquals((Object)"INTEGER", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Int(32, true)));
        Assert.assertEquals((Object)"BIGINT", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Int(64, true)));
        Assert.assertEquals((Object)"BINARY", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.FixedSizeBinary(1024)));
        Assert.assertEquals((Object)"VARBINARY", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Binary()));
        Assert.assertEquals((Object)"LONGVARBINARY", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.LargeBinary()));
        Assert.assertEquals((Object)"VARCHAR", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Utf8()));
        Assert.assertEquals((Object)"LONGVARCHAR", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.LargeUtf8()));
        Assert.assertEquals((Object)"DATE", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Date(DateUnit.MILLISECOND)));
        Assert.assertEquals((Object)"TIME", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32)));
        Assert.assertEquals((Object)"TIMESTAMP", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "")));
        Assert.assertEquals((Object)"BOOLEAN", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Bool()));
        Assert.assertEquals((Object)"DECIMAL", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Decimal(0, 0, 64)));
        Assert.assertEquals((Object)"DOUBLE", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)));
        Assert.assertEquals((Object)"FLOAT", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)));
        Assert.assertEquals((Object)"ARRAY", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.List()));
        Assert.assertEquals((Object)"ARRAY", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.LargeList()));
        Assert.assertEquals((Object)"ARRAY", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.FixedSizeList(10)));
        Assert.assertEquals((Object)"JAVA_OBJECT", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Struct()));
        Assert.assertEquals((Object)"JAVA_OBJECT", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Duration(TimeUnit.MILLISECOND)));
        Assert.assertEquals((Object)"JAVA_OBJECT", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Interval(IntervalUnit.DAY_TIME)));
        Assert.assertEquals((Object)"JAVA_OBJECT", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Union(UnionMode.Dense, null)));
        Assert.assertEquals((Object)"JAVA_OBJECT", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Map(true)));
        Assert.assertEquals((Object)"NULL", (Object)SqlTypes.getSqlTypeNameFromArrowType((ArrowType)new ArrowType.Null()));
    }
}

