/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecTZVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.impl.UnionFixedSizeListWriter;
import org.apache.arrow.vector.complex.impl.UnionLargeListWriter;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RootAllocatorTestRule
implements TestRule,
AutoCloseable {
    public static final byte MAX_VALUE = 127;
    private final BufferAllocator rootAllocator = new RootAllocator();
    private final Random random = new Random(10L);

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    RootAllocatorTestRule.this.close();
                }
            }
        };
    }

    public BufferAllocator getRootAllocator() {
        return this.rootAllocator;
    }

    @Override
    public void close() throws Exception {
        this.rootAllocator.getChildAllocators().forEach(BufferAllocator::close);
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.rootAllocator});
    }

    public Float8Vector createFloat8Vector() {
        double[] doubleVectorValues = new double[]{0.0, 1.0, -1.0, -128.0, 127.0, -32768.0, 32767.0, -2.147483648E9, 2.147483647E9, -9.223372036854776E18, 9.223372036854776E18, 3.4028234663852886E38, -3.4028234663852886E38, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.4E-45f, -1.4E-45f, Double.MAX_VALUE, -1.7976931348623157E308, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.MIN_VALUE, -4.9E-324};
        Float8Vector result = new Float8Vector("", this.getRootAllocator());
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < doubleVectorValues.length) {
                result.setSafe(i, doubleVectorValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextDouble());
        }
        return result;
    }

    public Float8Vector createFloat8VectorForNullTests() {
        Float8Vector float8Vector = new Float8Vector("ID", this.getRootAllocator());
        float8Vector.allocateNew(1);
        float8Vector.setNull(0);
        float8Vector.setValueCount(1);
        return float8Vector;
    }

    public Float4Vector createFloat4Vector() {
        float[] floatVectorValues = new float[]{0.0f, 1.0f, -1.0f, -128.0f, 127.0f, -32768.0f, 32767.0f, -2.1474836E9f, 2.1474836E9f, -9.223372E18f, 9.223372E18f, Float.MAX_VALUE, -3.4028235E38f, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.MIN_VALUE, -1.4E-45f};
        Float4Vector result = new Float4Vector("", this.getRootAllocator());
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < floatVectorValues.length) {
                result.setSafe(i, floatVectorValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextFloat());
        }
        return result;
    }

    public IntVector createIntVector() {
        int[] intVectorValues = new int[]{0, 1, -1, -128, 127, Short.MIN_VALUE, Short.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE};
        IntVector result = new IntVector("", this.getRootAllocator());
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < intVectorValues.length) {
                result.setSafe(i, intVectorValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextInt());
        }
        return result;
    }

    public SmallIntVector createSmallIntVector() {
        short[] smallIntVectorValues = new short[]{0, 1, -1, -128, 127, Short.MIN_VALUE, Short.MAX_VALUE};
        SmallIntVector result = new SmallIntVector("", this.getRootAllocator());
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < smallIntVectorValues.length) {
                result.setSafe(i, smallIntVectorValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextInt(Short.MAX_VALUE));
        }
        return result;
    }

    public TinyIntVector createTinyIntVector() {
        byte[] byteVectorValues = new byte[]{0, 1, -1, -128, 127};
        TinyIntVector result = new TinyIntVector("", this.getRootAllocator());
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < byteVectorValues.length) {
                result.setSafe(i, byteVectorValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextInt(127));
        }
        return result;
    }

    public BigIntVector createBigIntVector() {
        long[] longVectorValues = new long[]{0L, 1L, -1L, -128L, 127L, -32768L, 32767L, Integer.MIN_VALUE, Integer.MAX_VALUE, Long.MIN_VALUE, Long.MAX_VALUE};
        BigIntVector result = new BigIntVector("", this.getRootAllocator());
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < longVectorValues.length) {
                result.setSafe(i, longVectorValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextLong());
        }
        return result;
    }

    public UInt1Vector createUInt1Vector() {
        short[] uInt1VectorValues = new short[]{0, 1, -1, -128, 127};
        UInt1Vector result = new UInt1Vector("", this.getRootAllocator());
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < uInt1VectorValues.length) {
                result.setSafe(i, (int)uInt1VectorValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextInt(256));
        }
        return result;
    }

    public UInt2Vector createUInt2Vector() {
        int[] uInt2VectorValues = new int[]{0, 1, -1, -128, 127, Short.MIN_VALUE, Short.MAX_VALUE};
        UInt2Vector result = new UInt2Vector("", this.getRootAllocator());
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < uInt2VectorValues.length) {
                result.setSafe(i, uInt2VectorValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextInt(65536));
        }
        return result;
    }

    public UInt4Vector createUInt4Vector() {
        int[] uInt4VectorValues = new int[]{0, 1, -1, -128, 127, Short.MIN_VALUE, Short.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE};
        UInt4Vector result = new UInt4Vector("", this.getRootAllocator());
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < uInt4VectorValues.length) {
                result.setSafe(i, uInt4VectorValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextInt(Integer.MAX_VALUE));
        }
        return result;
    }

    public UInt8Vector createUInt8Vector() {
        long[] uInt8VectorValues = new long[]{0L, 1L, -1L, -128L, 127L, -32768L, 32767L, Integer.MIN_VALUE, Integer.MAX_VALUE, Long.MIN_VALUE, Long.MAX_VALUE};
        UInt8Vector result = new UInt8Vector("", this.getRootAllocator());
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < uInt8VectorValues.length) {
                result.setSafe(i, uInt8VectorValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextLong());
        }
        return result;
    }

    public VarBinaryVector createVarBinaryVector() {
        return this.createVarBinaryVector("");
    }

    public VarBinaryVector createVarBinaryVector(String fieldName) {
        VarBinaryVector valueVector = new VarBinaryVector(fieldName, this.getRootAllocator());
        valueVector.allocateNew(3);
        valueVector.setSafe(0, (fieldName + "__BINARY_DATA_0001").getBytes(StandardCharsets.UTF_8));
        valueVector.setSafe(1, (fieldName + "__BINARY_DATA_0002").getBytes(StandardCharsets.UTF_8));
        valueVector.setSafe(2, (fieldName + "__BINARY_DATA_0003").getBytes(StandardCharsets.UTF_8));
        valueVector.setValueCount(3);
        return valueVector;
    }

    public LargeVarBinaryVector createLargeVarBinaryVector() {
        LargeVarBinaryVector valueVector = new LargeVarBinaryVector("", this.getRootAllocator());
        valueVector.allocateNew(3);
        valueVector.setSafe(0, "BINARY_DATA_0001".getBytes(StandardCharsets.UTF_8));
        valueVector.setSafe(1, "BINARY_DATA_0002".getBytes(StandardCharsets.UTF_8));
        valueVector.setSafe(2, "BINARY_DATA_0003".getBytes(StandardCharsets.UTF_8));
        valueVector.setValueCount(3);
        return valueVector;
    }

    public FixedSizeBinaryVector createFixedSizeBinaryVector() {
        FixedSizeBinaryVector valueVector = new FixedSizeBinaryVector("", this.getRootAllocator(), 16);
        valueVector.allocateNew(3);
        valueVector.setSafe(0, "BINARY_DATA_0001".getBytes(StandardCharsets.UTF_8));
        valueVector.setSafe(1, "BINARY_DATA_0002".getBytes(StandardCharsets.UTF_8));
        valueVector.setSafe(2, "BINARY_DATA_0003".getBytes(StandardCharsets.UTF_8));
        valueVector.setValueCount(3);
        return valueVector;
    }

    public DecimalVector createDecimalVector() {
        BigDecimal[] bigDecimalValues = new BigDecimal[]{new BigDecimal(0), new BigDecimal(1), new BigDecimal(-1), new BigDecimal(-128), new BigDecimal(127), new BigDecimal(-32767), new BigDecimal(Short.MIN_VALUE), new BigDecimal(Integer.MIN_VALUE), new BigDecimal(Integer.MAX_VALUE), new BigDecimal(Long.MIN_VALUE), new BigDecimal(-9223372036854775807L), new BigDecimal("170141183460469231731687303715884105727")};
        DecimalVector result = new DecimalVector("ID", this.getRootAllocator(), 39, 0);
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < bigDecimalValues.length) {
                result.setSafe(i, bigDecimalValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextLong());
        }
        return result;
    }

    public Decimal256Vector createDecimal256Vector() {
        BigDecimal[] bigDecimalValues = new BigDecimal[]{new BigDecimal(0), new BigDecimal(1), new BigDecimal(-1), new BigDecimal(-128), new BigDecimal(127), new BigDecimal(-32767), new BigDecimal(Short.MIN_VALUE), new BigDecimal(Integer.MIN_VALUE), new BigDecimal(Integer.MAX_VALUE), new BigDecimal(Long.MIN_VALUE), new BigDecimal(-9223372036854775807L), new BigDecimal("170141183460469231731687303715884105727"), new BigDecimal("17014118346046923173168234157303715884105727"), new BigDecimal("1701411834604692317316823415265417303715884105727"), new BigDecimal("-17014118346046923173168234152654115451237303715884105727"), new BigDecimal("-17014118346046923173168234152654115451231545157303715884105727"), new BigDecimal("1701411834604692315815656534152654115451231545157303715884105727"), new BigDecimal("30560141183460469231581565634152654115451231545157303715884105727"), new BigDecimal("57896044618658097711785492504343953926634992332820282019728792003956564819967"), new BigDecimal("-56896044618658097711785492504343953926634992332820282019728792003956564819967")};
        Decimal256Vector result = new Decimal256Vector("ID", this.getRootAllocator(), 77, 0);
        result.setValueCount(127);
        for (int i = 0; i < 127; ++i) {
            if (i < bigDecimalValues.length) {
                result.setSafe(i, bigDecimalValues[i]);
                continue;
            }
            result.setSafe(i, this.random.nextLong());
        }
        return result;
    }

    public TimeStampNanoVector createTimeStampNanoVector() {
        TimeStampNanoVector valueVector = new TimeStampNanoVector("", this.getRootAllocator());
        valueVector.allocateNew(2);
        valueVector.setSafe(0, TimeUnit.MILLISECONDS.toNanos(1625702400000L));
        valueVector.setSafe(1, TimeUnit.MILLISECONDS.toNanos(1625788800000L));
        valueVector.setValueCount(2);
        return valueVector;
    }

    public TimeStampNanoTZVector createTimeStampNanoTZVector(String timeZone) {
        TimeStampNanoTZVector valueVector = new TimeStampNanoTZVector("", this.getRootAllocator(), timeZone);
        valueVector.allocateNew(2);
        valueVector.setSafe(0, TimeUnit.MILLISECONDS.toNanos(1625702400000L));
        valueVector.setSafe(1, TimeUnit.MILLISECONDS.toNanos(1625788800000L));
        valueVector.setValueCount(2);
        return valueVector;
    }

    public TimeStampMicroVector createTimeStampMicroVector() {
        TimeStampMicroVector valueVector = new TimeStampMicroVector("", this.getRootAllocator());
        valueVector.allocateNew(2);
        valueVector.setSafe(0, TimeUnit.MILLISECONDS.toMicros(1625702400000L));
        valueVector.setSafe(1, TimeUnit.MILLISECONDS.toMicros(1625788800000L));
        valueVector.setValueCount(2);
        return valueVector;
    }

    public TimeStampMicroTZVector createTimeStampMicroTZVector(String timeZone) {
        TimeStampMicroTZVector valueVector = new TimeStampMicroTZVector("", this.getRootAllocator(), timeZone);
        valueVector.allocateNew(2);
        valueVector.setSafe(0, TimeUnit.MILLISECONDS.toMicros(1625702400000L));
        valueVector.setSafe(1, TimeUnit.MILLISECONDS.toMicros(1625788800000L));
        valueVector.setValueCount(2);
        return valueVector;
    }

    public TimeStampMilliVector createTimeStampMilliVector() {
        TimeStampMilliVector valueVector = new TimeStampMilliVector("", this.getRootAllocator());
        valueVector.allocateNew(2);
        valueVector.setSafe(0, 1625702400000L);
        valueVector.setSafe(1, 1625788800000L);
        valueVector.setValueCount(2);
        return valueVector;
    }

    public TimeStampMilliTZVector createTimeStampMilliTZVector(String timeZone) {
        TimeStampMilliTZVector valueVector = new TimeStampMilliTZVector("", this.getRootAllocator(), timeZone);
        valueVector.allocateNew(2);
        valueVector.setSafe(0, 1625702400000L);
        valueVector.setSafe(1, 1625788800000L);
        valueVector.setValueCount(2);
        return valueVector;
    }

    public TimeStampSecVector createTimeStampSecVector() {
        TimeStampSecVector valueVector = new TimeStampSecVector("", this.getRootAllocator());
        valueVector.allocateNew(2);
        valueVector.setSafe(0, TimeUnit.MILLISECONDS.toSeconds(1625702400000L));
        valueVector.setSafe(1, TimeUnit.MILLISECONDS.toSeconds(1625788800000L));
        valueVector.setValueCount(2);
        return valueVector;
    }

    public TimeStampSecTZVector createTimeStampSecTZVector(String timeZone) {
        TimeStampSecTZVector valueVector = new TimeStampSecTZVector("", this.getRootAllocator(), timeZone);
        valueVector.allocateNew(2);
        valueVector.setSafe(0, TimeUnit.MILLISECONDS.toSeconds(1625702400000L));
        valueVector.setSafe(1, TimeUnit.MILLISECONDS.toSeconds(1625788800000L));
        valueVector.setValueCount(2);
        return valueVector;
    }

    public BitVector createBitVector() {
        BitVector valueVector = new BitVector("Value", this.getRootAllocator());
        valueVector.allocateNew(2);
        valueVector.setSafe(0, 0);
        valueVector.setSafe(1, 1);
        valueVector.setValueCount(2);
        return valueVector;
    }

    public BitVector createBitVectorForNullTests() {
        BitVector bitVector = new BitVector("ID", this.getRootAllocator());
        bitVector.allocateNew(2);
        bitVector.setNull(0);
        bitVector.setValueCount(1);
        return bitVector;
    }

    public TimeNanoVector createTimeNanoVector() {
        TimeNanoVector valueVector = new TimeNanoVector("", this.getRootAllocator());
        valueVector.allocateNew(5);
        valueVector.setSafe(0, 0L);
        valueVector.setSafe(1, 1000000000L);
        valueVector.setSafe(2, 60000000000L);
        valueVector.setSafe(3, 3600000000000L);
        valueVector.setSafe(4, 86399000000000L);
        valueVector.setValueCount(5);
        return valueVector;
    }

    public TimeMicroVector createTimeMicroVector() {
        TimeMicroVector valueVector = new TimeMicroVector("", this.getRootAllocator());
        valueVector.allocateNew(5);
        valueVector.setSafe(0, 0L);
        valueVector.setSafe(1, 1000000L);
        valueVector.setSafe(2, 60000000L);
        valueVector.setSafe(3, 3600000000L);
        valueVector.setSafe(4, 86399000000L);
        valueVector.setValueCount(5);
        return valueVector;
    }

    public TimeMilliVector createTimeMilliVector() {
        TimeMilliVector valueVector = new TimeMilliVector("", this.getRootAllocator());
        valueVector.allocateNew(5);
        valueVector.setSafe(0, 0);
        valueVector.setSafe(1, 1000);
        valueVector.setSafe(2, 60000);
        valueVector.setSafe(3, 3600000);
        valueVector.setSafe(4, 86399000);
        valueVector.setValueCount(5);
        return valueVector;
    }

    public TimeSecVector createTimeSecVector() {
        TimeSecVector valueVector = new TimeSecVector("", this.getRootAllocator());
        valueVector.allocateNew(5);
        valueVector.setSafe(0, 0);
        valueVector.setSafe(1, 1);
        valueVector.setSafe(2, 60);
        valueVector.setSafe(3, 3600);
        valueVector.setSafe(4, 86399);
        valueVector.setValueCount(5);
        return valueVector;
    }

    public DateDayVector createDateDayVector() {
        DateDayVector valueVector = new DateDayVector("", this.getRootAllocator());
        valueVector.allocateNew(2);
        valueVector.setSafe(0, (int)TimeUnit.MILLISECONDS.toDays(1625702400000L));
        valueVector.setSafe(1, (int)TimeUnit.MILLISECONDS.toDays(1625788800000L));
        valueVector.setValueCount(2);
        return valueVector;
    }

    public DateMilliVector createDateMilliVector() {
        DateMilliVector valueVector = new DateMilliVector("", this.getRootAllocator());
        valueVector.allocateNew(2);
        valueVector.setSafe(0, 1625702400000L);
        valueVector.setSafe(1, 1625788800000L);
        valueVector.setValueCount(2);
        return valueVector;
    }

    public ListVector createListVector() {
        return this.createListVector("");
    }

    public ListVector createListVector(String fieldName) {
        ListVector valueVector = ListVector.empty((String)fieldName, (BufferAllocator)this.getRootAllocator());
        valueVector.setInitialCapacity(127);
        UnionListWriter writer = valueVector.getWriter();
        IntStream range = IntStream.range(0, 127);
        range.forEach(row -> {
            writer.startList();
            writer.setPosition(row);
            IntStream.range(0, 5).map(j -> j * row).forEach(arg_0 -> ((UnionListWriter)writer).writeInt(arg_0));
            writer.setValueCount(5);
            writer.endList();
        });
        valueVector.setValueCount(127);
        return valueVector;
    }

    public LargeListVector createLargeListVector() {
        LargeListVector valueVector = LargeListVector.empty((String)"", (BufferAllocator)this.getRootAllocator());
        valueVector.setInitialCapacity(127);
        UnionLargeListWriter writer = valueVector.getWriter();
        IntStream range = IntStream.range(0, 127);
        range.forEach(row -> {
            writer.startList();
            writer.setPosition(row);
            IntStream.range(0, 5).map(j -> j * row).forEach(arg_0 -> ((UnionLargeListWriter)writer).writeInt(arg_0));
            writer.setValueCount(5);
            writer.endList();
        });
        valueVector.setValueCount(127);
        return valueVector;
    }

    public FixedSizeListVector createFixedSizeListVector() {
        FixedSizeListVector valueVector = FixedSizeListVector.empty((String)"", (int)5, (BufferAllocator)this.getRootAllocator());
        valueVector.setInitialCapacity(127);
        UnionFixedSizeListWriter writer = valueVector.getWriter();
        IntStream range = IntStream.range(0, 127);
        range.forEach(row -> {
            writer.startList();
            writer.setPosition(row);
            IntStream.range(0, 5).map(j -> j * row).forEach(arg_0 -> ((UnionFixedSizeListWriter)writer).writeInt(arg_0));
            writer.setValueCount(5);
            writer.endList();
        });
        valueVector.setValueCount(127);
        return valueVector;
    }
}

