/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.arrow.util.Preconditions;
import org.hamcrest.CoreMatchers;
import org.junit.rules.ErrorCollector;

public final class ResultSetTestUtils {
    private final ErrorCollector collector;

    public ResultSetTestUtils(ErrorCollector collector) {
        this.collector = (ErrorCollector)Preconditions.checkNotNull((Object)collector, (Object)"Error collector cannot be null.");
    }

    public static <T> void testData(ResultSet resultSet, List<List<T>> expectedResults, ErrorCollector collector) throws SQLException {
        ResultSetTestUtils.testData(resultSet, IntStream.range(1, resultSet.getMetaData().getColumnCount() + 1).toArray(), expectedResults, collector);
    }

    public static <T> void testData(ResultSet resultSet, List<String> columnNames, List<List<T>> expectedResults, ErrorCollector collector) throws SQLException {
        ResultSetTestUtils.testData(resultSet, (ResultSet data) -> {
            ArrayList<Object> columns = new ArrayList<Object>();
            for (String columnName : columnNames) {
                try {
                    columns.add(resultSet.getObject(columnName));
                }
                catch (SQLException e) {
                    collector.addError((Throwable)e);
                }
            }
            return columns;
        }, expectedResults, collector);
    }

    public static <T> void testData(ResultSet resultSet, int[] columnIndices, List<List<T>> expectedResults, ErrorCollector collector) throws SQLException {
        ResultSetTestUtils.testData(resultSet, (ResultSet data) -> {
            ArrayList<Object> columns = new ArrayList<Object>();
            for (int columnIndex : columnIndices) {
                try {
                    columns.add(resultSet.getObject(columnIndex));
                }
                catch (SQLException e) {
                    collector.addError((Throwable)e);
                }
            }
            return columns;
        }, expectedResults, collector);
    }

    public static <T> void testData(ResultSet resultSet, Function<ResultSet, List<T>> dataConsumer, List<List<T>> expectedResults, ErrorCollector collector) throws SQLException {
        ArrayList<List<T>> actualResults = new ArrayList<List<T>>();
        while (resultSet.next()) {
            actualResults.add(dataConsumer.apply(resultSet));
        }
        collector.checkThat(actualResults, CoreMatchers.is(expectedResults));
    }

    public <T> void testData(ResultSet resultSet, List<List<T>> expectedResults) throws SQLException {
        ResultSetTestUtils.testData(resultSet, expectedResults, this.collector);
    }

    public <T> void testData(ResultSet resultSet, List<String> columnNames, List<List<T>> expectedResults) throws SQLException {
        ResultSetTestUtils.testData(resultSet, columnNames, expectedResults, this.collector);
    }

    public <T> void testData(ResultSet resultSet, int[] columnIndices, List<List<T>> expectedResults) throws SQLException {
        ResultSetTestUtils.testData(resultSet, columnIndices, expectedResults, this.collector);
    }

    public <T> void testData(ResultSet resultSet, Function<ResultSet, List<T>> dataConsumer, List<List<T>> expectedResults) throws SQLException {
        ResultSetTestUtils.testData(resultSet, dataConsumer, expectedResults, this.collector);
    }
}

