/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.sql.BasicFlightSqlProducer;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;

public class PartitionedFlightSqlProducer
extends BasicFlightSqlProducer {
    private final List<FlightEndpoint> endpoints;
    private final Schema schema;

    public PartitionedFlightSqlProducer(Schema schema, FlightEndpoint ... endpoints) {
        this.schema = schema;
        this.endpoints = Arrays.asList(endpoints);
    }

    protected <T extends Message> List<FlightEndpoint> determineEndpoints(T request, FlightDescriptor flightDescriptor, Schema schema) {
        return this.endpoints;
    }

    public void createPreparedStatement(FlightSql.ActionCreatePreparedStatementRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        FlightSql.ActionCreatePreparedStatementResult.Builder resultBuilder = FlightSql.ActionCreatePreparedStatementResult.newBuilder().setPreparedStatementHandle(ByteString.EMPTY);
        ByteString datasetSchemaBytes = ByteString.copyFrom((byte[])this.schema.serializeAsMessage());
        resultBuilder.setDatasetSchema(datasetSchemaBytes);
        listener.onNext((Object)new Result(Any.pack((Message)resultBuilder.build()).toByteArray()));
        listener.onCompleted();
    }

    public FlightInfo getFlightInfoStatement(FlightSql.CommandStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return FlightInfo.builder((Schema)this.schema, (FlightDescriptor)descriptor, this.endpoints).build();
    }

    public FlightInfo getFlightInfoPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return FlightInfo.builder((Schema)this.schema, (FlightDescriptor)descriptor, this.endpoints).build();
    }

    public void closePreparedStatement(FlightSql.ActionClosePreparedStatementRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        listener.onCompleted();
    }

    public static class DataOnlyFlightSqlProducer
    extends NoOpFlightProducer {
        private final Ticket ticket;
        private final VectorSchemaRoot data;

        public DataOnlyFlightSqlProducer(Ticket ticket, VectorSchemaRoot data) {
            this.ticket = ticket;
            this.data = data;
        }

        public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
            if (!Arrays.equals(ticket.getBytes(), this.ticket.getBytes())) {
                listener.error((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Illegal ticket.").toRuntimeException());
                return;
            }
            listener.start(this.data);
            listener.putNext();
            listener.completed();
        }
    }
}

