/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.Criteria;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.flight.sql.SqlInfoBuilder;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.JsonStringArrayList;

public final class MockFlightSqlProducer
implements FlightSqlProducer {
    private final Map<String, Map.Entry<Schema, List<UUID>>> queryResults = new HashMap<String, Map.Entry<Schema, List<UUID>>>();
    private final Map<UUID, Consumer<FlightProducer.ServerStreamListener>> selectResultProviders = new HashMap<UUID, Consumer<FlightProducer.ServerStreamListener>>();
    private final Map<ByteString, String> preparedStatements = new HashMap<ByteString, String>();
    private final Map<Message, Consumer<FlightProducer.ServerStreamListener>> catalogQueriesResults = new HashMap<Message, Consumer<FlightProducer.ServerStreamListener>>();
    private final Map<String, BiConsumer<FlightStream, FlightProducer.StreamListener<PutResult>>> updateResultProviders = new HashMap<String, BiConsumer<FlightStream, FlightProducer.StreamListener<PutResult>>>();
    private final SqlInfoBuilder sqlInfoBuilder = new SqlInfoBuilder();
    private final Map<String, Schema> parameterSchemas = new HashMap<String, Schema>();
    private final Map<String, List<List<Object>>> expectedParameterValues = new HashMap<String, List<List<Object>>>();
    private final Map<String, Integer> actionTypeCounter = new HashMap<String, Integer>();

    private static FlightInfo getFlightInfoExportedAndImportedKeys(Message message, FlightDescriptor descriptor) {
        return MockFlightSqlProducer.getFlightInfo(message, FlightSqlProducer.Schemas.GET_IMPORTED_KEYS_SCHEMA, descriptor);
    }

    private static FlightInfo getFlightInfo(Message message, Schema schema, FlightDescriptor descriptor) {
        return new FlightInfo(schema, descriptor, Collections.singletonList(new FlightEndpoint(new Ticket(Any.pack((Message)message).toByteArray()), new Location[0])), -1L, -1L);
    }

    public static ByteBuffer serializeSchema(Schema schema) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(outputStream)), (Schema)schema);
            return ByteBuffer.wrap(outputStream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize schema", e);
        }
    }

    public void addSelectQuery(String sqlCommand, Schema schema, List<Consumer<FlightProducer.ServerStreamListener>> resultProviders) {
        int providers = resultProviders.size();
        List uuids = IntStream.range(0, providers).mapToObj(index -> new UUID(sqlCommand.hashCode(), Integer.hashCode(index))).collect(Collectors.toList());
        this.queryResults.put(sqlCommand, new AbstractMap.SimpleImmutableEntry(schema, uuids));
        IntStream.range(0, providers).forEach(index -> this.selectResultProviders.put((UUID)uuids.get(index), (Consumer)resultProviders.get(index)));
    }

    public void addUpdateQuery(String sqlCommand, long updatedRows) {
        this.addUpdateQuery(sqlCommand, (flightStream, putResultStreamListener) -> {
            FlightSql.DoPutUpdateResult result = FlightSql.DoPutUpdateResult.newBuilder().setRecordCount(updatedRows).build();
            try {
                RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
                Throwable throwable = null;
                try {
                    ArrowBuf buffer = allocator.buffer((long)result.getSerializedSize());
                    Throwable throwable2 = null;
                    try {
                        buffer.writeBytes(result.toByteArray());
                        putResultStreamListener.onNext((Object)PutResult.metadata((ArrowBuf)buffer));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (buffer != null) {
                            MockFlightSqlProducer.$closeResource(throwable2, (AutoCloseable)buffer);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    MockFlightSqlProducer.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            catch (Throwable throwable) {
                putResultStreamListener.onError(throwable);
            }
            finally {
                putResultStreamListener.onCompleted();
            }
        });
    }

    public void addCatalogQuery(Message message, Consumer<FlightProducer.ServerStreamListener> resultsProvider) {
        this.catalogQueriesResults.put(message, resultsProvider);
    }

    void addUpdateQuery(String sqlCommand, BiConsumer<FlightStream, FlightProducer.StreamListener<PutResult>> resultsProvider) {
        Preconditions.checkState((this.updateResultProviders.putIfAbsent(sqlCommand, resultsProvider) == null ? 1 : 0) != 0, (Object)String.format("Attempted to overwrite preexisting query: <%s>.", sqlCommand));
    }

    public void addExpectedParameters(String query, Schema parameterSchema, List<List<Object>> expectedValues) {
        this.parameterSchemas.put(query, parameterSchema);
        this.expectedParameterValues.put(query, expectedValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPreparedStatement(FlightSql.ActionCreatePreparedStatementRequest request, FlightProducer.CallContext callContext, FlightProducer.StreamListener<Result> listener) {
        try {
            ByteString preparedStatementHandle = ByteString.copyFrom((byte[])UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
            String query = request.getQuery();
            FlightSql.ActionCreatePreparedStatementResult.Builder resultBuilder = FlightSql.ActionCreatePreparedStatementResult.newBuilder().setPreparedStatementHandle(preparedStatementHandle);
            Map.Entry<Schema, List<UUID>> entry = this.queryResults.get(query);
            if (entry != null) {
                this.preparedStatements.put(preparedStatementHandle, query);
                Schema datasetSchema = entry.getKey();
                ByteString datasetSchemaBytes = ByteString.copyFrom((ByteBuffer)MockFlightSqlProducer.serializeSchema(datasetSchema));
                resultBuilder.setDatasetSchema(datasetSchemaBytes);
            } else if (this.updateResultProviders.containsKey(query)) {
                this.preparedStatements.put(preparedStatementHandle, query);
            } else {
                listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Query not found").toRuntimeException());
                return;
            }
            Schema parameterSchema = this.parameterSchemas.get(query);
            if (parameterSchema != null) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(outputStream)), (Schema)parameterSchema);
                resultBuilder.setParameterSchema(ByteString.copyFrom((byte[])outputStream.toByteArray()));
            }
            listener.onNext((Object)new Result(Any.pack((Message)resultBuilder.build()).toByteArray()));
        }
        catch (Throwable t) {
            listener.onError(t);
        }
        finally {
            listener.onCompleted();
        }
    }

    public void closePreparedStatement(FlightSql.ActionClosePreparedStatementRequest actionClosePreparedStatementRequest, FlightProducer.CallContext callContext, FlightProducer.StreamListener<Result> streamListener) {
        streamListener.onCompleted();
    }

    public FlightInfo getFlightInfoStatement(FlightSql.CommandStatementQuery commandStatementQuery, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        String query = commandStatementQuery.getQuery();
        Map.Entry queryInfo = (Map.Entry)Preconditions.checkNotNull(this.queryResults.get(query), (Object)String.format("Query not registered: <%s>.", query));
        List endpoints = ((List)queryInfo.getValue()).stream().map(x$0 -> TicketConversionUtils.getTicketBytesFromUuid(x$0)).map(x$0 -> TicketConversionUtils.getTicketStatementQueryFromHandle(x$0)).map(x$0 -> TicketConversionUtils.getEndpointFromMessage(x$0)).collect(Collectors.toList());
        return FlightInfo.builder((Schema)((Schema)queryInfo.getKey()), (FlightDescriptor)flightDescriptor, endpoints).setAppMetadata("foo".getBytes(StandardCharsets.UTF_8)).build();
    }

    public FlightInfo getFlightInfoPreparedStatement(FlightSql.CommandPreparedStatementQuery commandPreparedStatementQuery, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        ByteString preparedStatementHandle = commandPreparedStatementQuery.getPreparedStatementHandle();
        String query = (String)Preconditions.checkNotNull((Object)this.preparedStatements.get(preparedStatementHandle), (Object)String.format("No query registered under handle: <%s>.", preparedStatementHandle));
        Map.Entry queryInfo = (Map.Entry)Preconditions.checkNotNull(this.queryResults.get(query), (Object)String.format("Query not registered: <%s>.", query));
        List endpoints = ((List)queryInfo.getValue()).stream().map(x$0 -> TicketConversionUtils.getTicketBytesFromUuid(x$0)).map(x$0 -> TicketConversionUtils.getCommandPreparedStatementQueryFromHandle(x$0)).map(x$0 -> TicketConversionUtils.getEndpointFromMessage(x$0)).collect(Collectors.toList());
        return FlightInfo.builder((Schema)((Schema)queryInfo.getKey()), (FlightDescriptor)flightDescriptor, endpoints).setAppMetadata("foo".getBytes(StandardCharsets.UTF_8)).build();
    }

    public SchemaResult getSchemaStatement(FlightSql.CommandStatementQuery commandStatementQuery, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        String query = commandStatementQuery.getQuery();
        Map.Entry queryInfo = (Map.Entry)Preconditions.checkNotNull(this.queryResults.get(query), (Object)String.format("Query not registered: <%s>.", query));
        return new SchemaResult((Schema)queryInfo.getKey());
    }

    public void getStreamStatement(FlightSql.TicketStatementQuery ticketStatementQuery, FlightProducer.CallContext callContext, FlightProducer.ServerStreamListener serverStreamListener) {
        UUID uuid = UUID.fromString(ticketStatementQuery.getStatementHandle().toStringUtf8());
        ((Consumer)Preconditions.checkNotNull(this.selectResultProviders.get(uuid), (String)"No consumer was registered for the specified UUID: <%s>.", (Object)uuid)).accept(serverStreamListener);
    }

    public void getStreamPreparedStatement(FlightSql.CommandPreparedStatementQuery commandPreparedStatementQuery, FlightProducer.CallContext callContext, FlightProducer.ServerStreamListener serverStreamListener) {
        UUID uuid = UUID.fromString(commandPreparedStatementQuery.getPreparedStatementHandle().toStringUtf8());
        ((Consumer)Preconditions.checkNotNull(this.selectResultProviders.get(uuid), (String)"No consumer was registered for the specified UUID: <%s>.", (Object)uuid)).accept(serverStreamListener);
    }

    public Runnable acceptPutStatement(FlightSql.CommandStatementUpdate commandStatementUpdate, FlightProducer.CallContext callContext, FlightStream flightStream, FlightProducer.StreamListener<PutResult> streamListener) {
        return () -> {
            String query = commandStatementUpdate.getQuery();
            BiConsumer resultProvider = (BiConsumer)Preconditions.checkNotNull(this.updateResultProviders.get(query), (Object)String.format("No consumer found for query: <%s>.", query));
            resultProvider.accept(flightStream, streamListener);
        };
    }

    private boolean validateParameters(String query, FlightStream flightStream, FlightProducer.StreamListener<PutResult> streamListener) {
        List<List<Object>> expectedValues = this.expectedParameterValues.get(query);
        if (expectedValues != null) {
            int index = 0;
            while (flightStream.next()) {
                VectorSchemaRoot root = flightStream.getRoot();
                for (int i = 0; i < root.getRowCount(); ++i) {
                    if (index >= expectedValues.size()) {
                        streamListener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("More parameter rows provided than expected").toRuntimeException());
                        return true;
                    }
                    List<Object> expectedRow = expectedValues.get(index++);
                    if (root.getFieldVectors().size() != expectedRow.size()) {
                        streamListener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Parameter count mismatch").toRuntimeException());
                        return true;
                    }
                    for (int paramIndex = 0; paramIndex < expectedRow.size(); ++paramIndex) {
                        Object expected = expectedRow.get(paramIndex);
                        Object actual = root.getVector(paramIndex).getObject(i);
                        boolean matches = expected.getClass().isArray() ? Arrays.equals((Object[])expected, ((JsonStringArrayList)actual).toArray()) : Objects.equals(expected, actual);
                        if (matches) continue;
                        streamListener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription(String.format("Parameter mismatch. Expected: %s Actual: %s", expected, actual)).toRuntimeException());
                        return true;
                    }
                }
            }
            if (index < expectedValues.size()) {
                streamListener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Fewer parameter rows provided than expected").toRuntimeException());
                return true;
            }
        }
        return false;
    }

    public Runnable acceptPutPreparedStatementUpdate(FlightSql.CommandPreparedStatementUpdate commandPreparedStatementUpdate, FlightProducer.CallContext callContext, FlightStream flightStream, FlightProducer.StreamListener<PutResult> streamListener) {
        ByteString handle = commandPreparedStatementUpdate.getPreparedStatementHandle();
        String query = (String)Preconditions.checkNotNull((Object)this.preparedStatements.get(handle), (Object)String.format("No query registered under handle: <%s>.", handle));
        if (this.validateParameters(query, flightStream, streamListener)) {
            return () -> {};
        }
        return this.acceptPutStatement(FlightSql.CommandStatementUpdate.newBuilder().setQuery(query).build(), callContext, flightStream, streamListener);
    }

    public Runnable acceptPutPreparedStatementQuery(FlightSql.CommandPreparedStatementQuery commandPreparedStatementQuery, FlightProducer.CallContext callContext, FlightStream flightStream, FlightProducer.StreamListener<PutResult> streamListener) {
        ByteString handle = commandPreparedStatementQuery.getPreparedStatementHandle();
        String query = (String)Preconditions.checkNotNull((Object)this.preparedStatements.get(handle), (Object)String.format("No query registered under handle: <%s>.", handle));
        if (this.validateParameters(query, flightStream, streamListener)) {
            return () -> {};
        }
        return () -> streamListener.onCompleted();
    }

    public FlightInfo getFlightInfoSqlInfo(FlightSql.CommandGetSqlInfo commandGetSqlInfo, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        return MockFlightSqlProducer.getFlightInfo((Message)commandGetSqlInfo, FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA, flightDescriptor);
    }

    public void getStreamSqlInfo(FlightSql.CommandGetSqlInfo commandGetSqlInfo, FlightProducer.CallContext callContext, FlightProducer.ServerStreamListener serverStreamListener) {
        this.sqlInfoBuilder.send(commandGetSqlInfo.getInfoList(), serverStreamListener);
    }

    public FlightInfo getFlightInfoTypeInfo(FlightSql.CommandGetXdbcTypeInfo request, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return null;
    }

    public void getStreamTypeInfo(FlightSql.CommandGetXdbcTypeInfo request, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
    }

    public FlightInfo getFlightInfoCatalogs(FlightSql.CommandGetCatalogs commandGetCatalogs, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        return MockFlightSqlProducer.getFlightInfo((Message)commandGetCatalogs, FlightSqlProducer.Schemas.GET_CATALOGS_SCHEMA, flightDescriptor);
    }

    public void getStreamCatalogs(FlightProducer.CallContext callContext, FlightProducer.ServerStreamListener serverStreamListener) {
        FlightSql.CommandGetCatalogs command = FlightSql.CommandGetCatalogs.getDefaultInstance();
        this.getStreamCatalogFunctions((Message)command, serverStreamListener);
    }

    public FlightInfo getFlightInfoSchemas(FlightSql.CommandGetDbSchemas commandGetSchemas, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        return MockFlightSqlProducer.getFlightInfo((Message)commandGetSchemas, FlightSqlProducer.Schemas.GET_SCHEMAS_SCHEMA, flightDescriptor);
    }

    public void getStreamSchemas(FlightSql.CommandGetDbSchemas commandGetSchemas, FlightProducer.CallContext callContext, FlightProducer.ServerStreamListener serverStreamListener) {
        this.getStreamCatalogFunctions((Message)commandGetSchemas, serverStreamListener);
    }

    public FlightInfo getFlightInfoTables(FlightSql.CommandGetTables commandGetTables, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        return MockFlightSqlProducer.getFlightInfo((Message)commandGetTables, FlightSqlProducer.Schemas.GET_TABLES_SCHEMA_NO_SCHEMA, flightDescriptor);
    }

    public void getStreamTables(FlightSql.CommandGetTables commandGetTables, FlightProducer.CallContext callContext, FlightProducer.ServerStreamListener serverStreamListener) {
        this.getStreamCatalogFunctions((Message)commandGetTables, serverStreamListener);
    }

    public FlightInfo getFlightInfoTableTypes(FlightSql.CommandGetTableTypes commandGetTableTypes, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        return MockFlightSqlProducer.getFlightInfo((Message)commandGetTableTypes, FlightSqlProducer.Schemas.GET_TABLE_TYPES_SCHEMA, flightDescriptor);
    }

    public void getStreamTableTypes(FlightProducer.CallContext callContext, FlightProducer.ServerStreamListener serverStreamListener) {
        FlightSql.CommandGetTableTypes command = FlightSql.CommandGetTableTypes.getDefaultInstance();
        this.getStreamCatalogFunctions((Message)command, serverStreamListener);
    }

    public FlightInfo getFlightInfoPrimaryKeys(FlightSql.CommandGetPrimaryKeys commandGetPrimaryKeys, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        return MockFlightSqlProducer.getFlightInfo((Message)commandGetPrimaryKeys, FlightSqlProducer.Schemas.GET_PRIMARY_KEYS_SCHEMA, flightDescriptor);
    }

    public void getStreamPrimaryKeys(FlightSql.CommandGetPrimaryKeys commandGetPrimaryKeys, FlightProducer.CallContext callContext, FlightProducer.ServerStreamListener serverStreamListener) {
        this.getStreamCatalogFunctions((Message)commandGetPrimaryKeys, serverStreamListener);
    }

    public FlightInfo getFlightInfoExportedKeys(FlightSql.CommandGetExportedKeys commandGetExportedKeys, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        return MockFlightSqlProducer.getFlightInfoExportedAndImportedKeys((Message)commandGetExportedKeys, flightDescriptor);
    }

    public FlightInfo getFlightInfoImportedKeys(FlightSql.CommandGetImportedKeys commandGetImportedKeys, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        return MockFlightSqlProducer.getFlightInfoExportedAndImportedKeys((Message)commandGetImportedKeys, flightDescriptor);
    }

    public FlightInfo getFlightInfoCrossReference(FlightSql.CommandGetCrossReference commandGetCrossReference, FlightProducer.CallContext callContext, FlightDescriptor flightDescriptor) {
        return MockFlightSqlProducer.getFlightInfoExportedAndImportedKeys((Message)commandGetCrossReference, flightDescriptor);
    }

    public void getStreamExportedKeys(FlightSql.CommandGetExportedKeys commandGetExportedKeys, FlightProducer.CallContext callContext, FlightProducer.ServerStreamListener serverStreamListener) {
        this.getStreamCatalogFunctions((Message)commandGetExportedKeys, serverStreamListener);
    }

    public void getStreamImportedKeys(FlightSql.CommandGetImportedKeys commandGetImportedKeys, FlightProducer.CallContext callContext, FlightProducer.ServerStreamListener serverStreamListener) {
        this.getStreamCatalogFunctions((Message)commandGetImportedKeys, serverStreamListener);
    }

    public void getStreamCrossReference(FlightSql.CommandGetCrossReference commandGetCrossReference, FlightProducer.CallContext callContext, FlightProducer.ServerStreamListener serverStreamListener) {
        this.getStreamCatalogFunctions((Message)commandGetCrossReference, serverStreamListener);
    }

    public void close() {
    }

    public void listFlights(FlightProducer.CallContext callContext, Criteria criteria, FlightProducer.StreamListener<FlightInfo> streamListener) {
        throw CallStatus.UNIMPLEMENTED.toRuntimeException();
    }

    public void doAction(FlightProducer.CallContext context, Action action, FlightProducer.StreamListener<Result> listener) {
        super.doAction(context, action, listener);
        this.actionTypeCounter.put(action.getType(), this.actionTypeCounter.getOrDefault(action.getType(), 0) + 1);
    }

    public void clearActionTypeCounter() {
        this.actionTypeCounter.clear();
    }

    public Map<String, Integer> getActionTypeCounter() {
        return this.actionTypeCounter;
    }

    private void getStreamCatalogFunctions(Message ticket, FlightProducer.ServerStreamListener serverStreamListener) {
        ((Consumer)Preconditions.checkNotNull(this.catalogQueriesResults.get(ticket), (Object)String.format("Query not registered for ticket: <%s>", ticket))).accept(serverStreamListener);
    }

    public SqlInfoBuilder getSqlInfoBuilder() {
        return this.sqlInfoBuilder;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private static final class TicketConversionUtils {
        private TicketConversionUtils() {
        }

        private static ByteString getTicketBytesFromUuid(UUID uuid) {
            return ByteString.copyFromUtf8((String)uuid.toString());
        }

        private static FlightSql.TicketStatementQuery getTicketStatementQueryFromHandle(ByteString handle) {
            return FlightSql.TicketStatementQuery.newBuilder().setStatementHandle(handle).build();
        }

        private static FlightSql.CommandPreparedStatementQuery getCommandPreparedStatementQueryFromHandle(ByteString handle) {
            return FlightSql.CommandPreparedStatementQuery.newBuilder().setPreparedStatementHandle(handle).build();
        }

        private static FlightEndpoint getEndpointFromMessage(Message message) {
            return new FlightEndpoint(new Ticket(Any.pack((Message)message).toByteArray()), new Location[0]);
        }
    }
}

