/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class FlightSqlTestCertificates {
    public static final String TEST_DATA_ENV_VAR = "ARROW_TEST_DATA";
    public static final String TEST_DATA_PROPERTY = "arrow.test.dataRoot";

    static Path getTestDataRoot() {
        String path = System.getenv(TEST_DATA_ENV_VAR);
        if (path == null) {
            path = System.getProperty(TEST_DATA_PROPERTY);
        }
        return Paths.get(Objects.requireNonNull(path, String.format("Could not find test data path. Set the environment variable %s or the JVM property %s.", TEST_DATA_ENV_VAR, TEST_DATA_PROPERTY)), new String[0]);
    }

    static Path getFlightTestDataRoot() {
        return FlightSqlTestCertificates.getTestDataRoot().resolve("flight");
    }

    public static File exampleCACert() {
        Path root = FlightSqlTestCertificates.getFlightTestDataRoot();
        return root.resolve("root-ca.pem").toFile();
    }

    public static List<CertKeyPair> exampleTlsCerts() {
        Path root = FlightSqlTestCertificates.getFlightTestDataRoot();
        return Arrays.asList(new CertKeyPair(root.resolve("cert0.pem").toFile(), root.resolve("cert0.pkcs1").toFile()), new CertKeyPair(root.resolve("cert1.pem").toFile(), root.resolve("cert1.pkcs1").toFile()));
    }

    public static class CertKeyPair {
        public final File cert;
        public final File key;

        public CertKeyPair(File cert, File key) {
            this.cert = cert;
            this.key = key;
        }
    }
}

