/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.util.concurrent.CompletionService;
import org.apache.arrow.driver.jdbc.client.CloseableEndpointStreamPair;
import org.apache.arrow.driver.jdbc.utils.FlightEndpointDataQueue;
import org.apache.arrow.driver.jdbc.utils.ThrowableAssertionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FlightEndpointDataQueueTest {
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    @Mock
    private CompletionService<CloseableEndpointStreamPair> mockedService;
    private FlightEndpointDataQueue queue;

    @Before
    public void setUp() {
        this.queue = new FlightEndpointDataQueue(this.mockedService);
    }

    @Test
    public void testNextShouldRetrieveNullIfEmpty() throws Exception {
        this.collector.checkThat((Object)this.queue.next(), CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testNextShouldThrowExceptionUponClose() throws Exception {
        this.queue.close();
        ThrowableAssertionUtils.simpleAssertThrowableClass(IllegalStateException.class, () -> this.queue.next());
    }

    @Test
    public void testEnqueueShouldThrowExceptionUponClose() throws Exception {
        this.queue.close();
        ThrowableAssertionUtils.simpleAssertThrowableClass(IllegalStateException.class, () -> this.queue.enqueue((CloseableEndpointStreamPair)Mockito.mock(CloseableEndpointStreamPair.class)));
    }

    @Test
    public void testCheckOpen() throws Exception {
        this.collector.checkSucceeds(() -> {
            this.queue.checkOpen();
            return true;
        });
        this.queue.close();
        ThrowableAssertionUtils.simpleAssertThrowableClass(IllegalStateException.class, () -> this.queue.checkOpen());
    }

    @Test
    public void testShouldCloseQueue() throws Exception {
        this.collector.checkThat((Object)this.queue.isClosed(), CoreMatchers.is((Object)false));
        this.queue.close();
        this.collector.checkThat((Object)this.queue.isClosed(), CoreMatchers.is((Object)true));
    }
}

