/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.sql.BasicFlightSqlProducer;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;

public class FallbackFlightSqlProducer
extends BasicFlightSqlProducer {
    private final VectorSchemaRoot data;

    public FallbackFlightSqlProducer(VectorSchemaRoot resultData) {
        this.data = resultData;
    }

    protected <T extends Message> List<FlightEndpoint> determineEndpoints(T request, FlightDescriptor flightDescriptor, Schema schema) {
        return Collections.emptyList();
    }

    public void createPreparedStatement(FlightSql.ActionCreatePreparedStatementRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        FlightSql.ActionCreatePreparedStatementResult.Builder resultBuilder = FlightSql.ActionCreatePreparedStatementResult.newBuilder().setPreparedStatementHandle(request.getQueryBytes());
        ByteString datasetSchemaBytes = ByteString.copyFrom((byte[])this.data.getSchema().serializeAsMessage());
        resultBuilder.setDatasetSchema(datasetSchemaBytes);
        listener.onNext((Object)new Result(Any.pack((Message)resultBuilder.build()).toByteArray()));
        listener.onCompleted();
    }

    public FlightInfo getFlightInfoStatement(FlightSql.CommandStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfo(descriptor, command.getQuery());
    }

    public FlightInfo getFlightInfoPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        return this.getFlightInfo(descriptor, command.getPreparedStatementHandle().toStringUtf8());
    }

    public void getStreamStatement(FlightSql.TicketStatementQuery ticket, FlightProducer.CallContext context, FlightProducer.ServerStreamListener listener) {
        listener.start(this.data);
        listener.putNext();
        listener.completed();
    }

    public void closePreparedStatement(FlightSql.ActionClosePreparedStatementRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        listener.onCompleted();
    }

    private FlightInfo getFlightInfo(FlightDescriptor descriptor, String query) {
        List<FlightEndpoint> endpoints;
        Ticket ticket = new Ticket(Any.pack((Message)FlightSql.TicketStatementQuery.getDefaultInstance()).toByteArray());
        if (query.equals("fallback")) {
            endpoints = Collections.singletonList(FlightEndpoint.builder((Ticket)ticket, (Location[])new Location[]{Location.reuseConnection()}).build());
        } else if (query.equals("fallback with error")) {
            endpoints = Collections.singletonList(FlightEndpoint.builder((Ticket)ticket, (Location[])new Location[]{Location.forGrpcInsecure((String)"localhost", (int)9999), Location.reuseConnection()}).build());
        } else {
            throw CallStatus.UNIMPLEMENTED.withDescription(query).toRuntimeException();
        }
        return FlightInfo.builder((Schema)this.data.getSchema(), (FlightDescriptor)descriptor, endpoints).build();
    }
}

