/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.arrow.driver.jdbc.utils.DateTimeUtils;
import org.hamcrest.CoreMatchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class DateTimeUtilsTest {
    @ClassRule
    public static final ErrorCollector collector = new ErrorCollector();
    private final TimeZone defaultTimezone = TimeZone.getTimeZone("UTC");
    private final TimeZone alternateTimezone = TimeZone.getTimeZone("America/Vancouver");
    private final long positiveEpochMilli = 959817600000L;
    private final long negativeEpochMilli = -618105600000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldGetOffsetWithSameTimeZone() {
        TimeZone currentTimezone = TimeZone.getDefault();
        long epochMillis = 959817600000L;
        long offset = this.defaultTimezone.getOffset(959817600000L);
        TimeZone.setDefault(this.defaultTimezone);
        try {
            long expected = 959817600000L + offset;
            long actual = DateTimeUtils.applyCalendarOffset((long)959817600000L, (Calendar)Calendar.getInstance(this.defaultTimezone));
            collector.checkThat((Object)actual, CoreMatchers.is((Object)expected));
        }
        finally {
            TimeZone.setDefault(currentTimezone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldGetOffsetWithDifferentTimeZone() {
        TimeZone currentTimezone = TimeZone.getDefault();
        long epochMillis = -618105600000L;
        long offset = this.alternateTimezone.getOffset(-618105600000L);
        TimeZone.setDefault(this.alternateTimezone);
        try {
            long expectedEpochMillis = -618105600000L + offset;
            long actualEpochMillis = DateTimeUtils.applyCalendarOffset((long)-618105600000L, (Calendar)Calendar.getInstance(this.defaultTimezone));
            collector.checkThat((Object)actualEpochMillis, CoreMatchers.is((Object)expectedEpochMillis));
        }
        finally {
            TimeZone.setDefault(currentTimezone);
        }
    }

    @Test
    public void testShouldGetTimestampPositive() {
        long epochMilli = 959817600000L;
        Instant instant = Instant.ofEpochMilli(epochMilli);
        Timestamp expected = Timestamp.from(instant);
        Timestamp actual = DateTimeUtils.getTimestampValue((long)epochMilli);
        collector.checkThat((Object)expected, CoreMatchers.is((Object)actual));
    }

    @Test
    public void testShouldGetTimestampNegative() {
        long epochMilli = -618105600000L;
        Instant instant = Instant.ofEpochMilli(-618105600000L);
        Timestamp expected = Timestamp.from(instant);
        Timestamp actual = DateTimeUtils.getTimestampValue((long)-618105600000L);
        collector.checkThat((Object)expected, CoreMatchers.is((Object)actual));
    }
}

