/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import com.google.common.collect.ImmutableList;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.arrow.driver.jdbc.utils.MockFlightSqlProducer;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.sql.FlightSqlColumnMetadata;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.rules.ErrorCollector;

public final class CoreMockedSqlProducers {
    public static final String LEGACY_REGULAR_SQL_CMD = "SELECT * FROM TEST";
    public static final String LEGACY_METADATA_SQL_CMD = "SELECT * FROM METADATA";
    public static final String LEGACY_CANCELLATION_SQL_CMD = "SELECT * FROM TAKES_FOREVER";
    public static final String LEGACY_REGULAR_WITH_EMPTY_SQL_CMD = "SELECT * FROM TEST_EMPTIES";

    private CoreMockedSqlProducers() {
    }

    public static MockFlightSqlProducer getLegacyProducer() {
        MockFlightSqlProducer producer = new MockFlightSqlProducer();
        CoreMockedSqlProducers.addLegacyRegularSqlCmdSupport(producer);
        CoreMockedSqlProducers.addLegacyMetadataSqlCmdSupport(producer);
        CoreMockedSqlProducers.addLegacyCancellationSqlCmdSupport(producer);
        CoreMockedSqlProducers.addQueryWithEmbeddedEmptyRoot(producer);
        return producer;
    }

    private static void addQueryWithEmbeddedEmptyRoot(MockFlightSqlProducer producer) {
        Schema querySchema = new Schema((Iterable)ImmutableList.of((Object)new Field("ID", new FieldType(true, (ArrowType)new ArrowType.Int(64, true), null), null)));
        ArrayList<Consumer<FlightProducer.ServerStreamListener>> resultProducers = new ArrayList<Consumer<FlightProducer.ServerStreamListener>>();
        Consumer<FlightProducer.ServerStreamListener> dataRoot = listener -> {
            try {
                RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)querySchema, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        root.allocateNew();
                        root.setRowCount(0);
                        listener.start(root);
                        listener.putNext();
                        ((BigIntVector)root.getVector("ID")).setSafe(0, 100L);
                        root.setRowCount(1);
                        listener.putNext();
                        root.clear();
                        root.setRowCount(0);
                        listener.putNext();
                        ((BigIntVector)root.getVector("ID")).setSafe(0, 100L);
                        root.setRowCount(1);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            CoreMockedSqlProducers.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CoreMockedSqlProducers.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            finally {
                listener.completed();
            }
        };
        resultProducers.add(dataRoot);
        producer.addSelectQuery(LEGACY_REGULAR_WITH_EMPTY_SQL_CMD, querySchema, resultProducers);
    }

    private static void addLegacyRegularSqlCmdSupport(MockFlightSqlProducer producer) {
        Schema querySchema = new Schema((Iterable)ImmutableList.of((Object)new Field("ID", new FieldType(true, (ArrowType)new ArrowType.Int(64, true), null), null), (Object)new Field("Name", new FieldType(true, (ArrowType)new ArrowType.Utf8(), null), null), (Object)new Field("Age", new FieldType(true, (ArrowType)new ArrowType.Int(32, false), null), null), (Object)new Field("Salary", new FieldType(true, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null), null), (Object)new Field("Hire Date", new FieldType(true, (ArrowType)new ArrowType.Date(DateUnit.DAY), null), null), (Object)new Field("Last Sale", new FieldType(true, (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null), null), null)));
        ArrayList<Consumer<FlightProducer.ServerStreamListener>> resultProducers = new ArrayList<Consumer<FlightProducer.ServerStreamListener>>();
        IntStream.range(0, 10).forEach(page -> resultProducers.add(listener -> {
            int rowsPerPage = 5000;
            try {
                RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)querySchema, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        root.allocateNew();
                        listener.start(root);
                        int batchSize = 500;
                        int indexOnBatch = 0;
                        int resultsOffset = page * 5000;
                        for (int i = 0; i < 5000; ++i) {
                            ((BigIntVector)root.getVector("ID")).setSafe(indexOnBatch, 0x80000000L + (long)i + (long)resultsOffset);
                            ((VarCharVector)root.getVector("Name")).setSafe(indexOnBatch, new Text("Test Name #" + (resultsOffset + i)));
                            ((UInt4Vector)root.getVector("Age")).setSafe(indexOnBatch, 32768 + i + resultsOffset);
                            ((Float8Vector)root.getVector("Salary")).setSafe(indexOnBatch, Math.scalb((double)(i + resultsOffset) / 2.0, i + resultsOffset));
                            ((DateDayVector)root.getVector("Hire Date")).setSafe(indexOnBatch, i + resultsOffset);
                            ((TimeStampMilliVector)root.getVector("Last Sale")).setSafe(indexOnBatch, Long.MAX_VALUE - (long)i - (long)resultsOffset);
                            if (++indexOnBatch != batchSize) continue;
                            root.setRowCount(indexOnBatch);
                            if (listener.isCancelled()) {
                                return;
                            }
                            listener.putNext();
                            root.allocateNew();
                            indexOnBatch = 0;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            CoreMockedSqlProducers.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CoreMockedSqlProducers.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            finally {
                listener.completed();
            }
        }));
        producer.addSelectQuery(LEGACY_REGULAR_SQL_CMD, querySchema, resultProducers);
    }

    private static void addLegacyMetadataSqlCmdSupport(MockFlightSqlProducer producer) {
        Schema metadataSchema = new Schema((Iterable)ImmutableList.of((Object)new Field("integer0", new FieldType(true, (ArrowType)new ArrowType.Int(64, true), null, new FlightSqlColumnMetadata.Builder().catalogName("CATALOG_NAME_1").schemaName("SCHEMA_NAME_1").tableName("TABLE_NAME_1").typeName("TYPE_NAME_1").precision(10).scale(0).isAutoIncrement(true).isCaseSensitive(false).isReadOnly(true).isSearchable(true).build().getMetadataMap()), null), (Object)new Field("string1", new FieldType(true, (ArrowType)new ArrowType.Utf8(), null, new FlightSqlColumnMetadata.Builder().catalogName("CATALOG_NAME_2").schemaName("SCHEMA_NAME_2").tableName("TABLE_NAME_2").typeName("TYPE_NAME_2").precision(65535).scale(0).isAutoIncrement(false).isCaseSensitive(true).isReadOnly(false).isSearchable(true).build().getMetadataMap()), null), (Object)new Field("float2", new FieldType(true, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null, new FlightSqlColumnMetadata.Builder().catalogName("CATALOG_NAME_3").schemaName("SCHEMA_NAME_3").tableName("TABLE_NAME_3").typeName("TYPE_NAME_3").precision(15).scale(20).isAutoIncrement(false).isCaseSensitive(false).isReadOnly(false).isSearchable(true).build().getMetadataMap()), null)));
        Consumer<FlightProducer.ServerStreamListener> formula = listener -> {
            try {
                RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
                Throwable throwable = null;
                try {
                    VectorSchemaRoot root = VectorSchemaRoot.create((Schema)metadataSchema, (BufferAllocator)allocator);
                    Throwable throwable2 = null;
                    try {
                        root.allocateNew();
                        ((BigIntVector)root.getVector("integer0")).setSafe(0, 1L);
                        ((VarCharVector)root.getVector("string1")).setSafe(0, new Text("teste"));
                        ((Float4Vector)root.getVector("float2")).setSafe(0, 4.1f);
                        root.setRowCount(1);
                        listener.start(root);
                        listener.putNext();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (root != null) {
                            CoreMockedSqlProducers.$closeResource(throwable2, (AutoCloseable)root);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CoreMockedSqlProducers.$closeResource(throwable, (AutoCloseable)allocator);
                }
            }
            finally {
                listener.completed();
            }
        };
        producer.addSelectQuery(LEGACY_METADATA_SQL_CMD, metadataSchema, Collections.singletonList(formula));
    }

    private static void addLegacyCancellationSqlCmdSupport(MockFlightSqlProducer producer) {
        producer.addSelectQuery(LEGACY_CANCELLATION_SQL_CMD, new Schema(Collections.singletonList(new Field("integer0", new FieldType(true, (ArrowType)new ArrowType.Int(64, true), null), null))), Collections.singletonList(listener -> {}));
    }

    public static void assertLegacyRegularSqlResultSet(ResultSet resultSet, ErrorCollector collector) throws SQLException {
        int expectedRowCount = 50000;
        long[] expectedIds = new long[50000];
        ArrayList<String> expectedNames = new ArrayList<String>(50000);
        int[] expectedAges = new int[50000];
        double[] expectedSalaries = new double[50000];
        ArrayList<Date> expectedHireDates = new ArrayList<Date>(50000);
        ArrayList<Timestamp> expectedLastSales = new ArrayList<Timestamp>(50000);
        long[] actualIds = new long[50000];
        ArrayList<String> actualNames = new ArrayList<String>(50000);
        int[] actualAges = new int[50000];
        double[] actualSalaries = new double[50000];
        ArrayList<Date> actualHireDates = new ArrayList<Date>(50000);
        ArrayList<Timestamp> actualLastSales = new ArrayList<Timestamp>(50000);
        int actualRowCount = 0;
        while (resultSet.next()) {
            expectedIds[actualRowCount] = 0x80000000L + (long)actualRowCount;
            expectedNames.add(String.format("Test Name #%d", actualRowCount));
            expectedAges[actualRowCount] = 32768 + actualRowCount;
            expectedSalaries[actualRowCount] = Math.scalb((double)actualRowCount / 2.0, actualRowCount);
            expectedHireDates.add(new Date(86400000L * (long)actualRowCount));
            expectedLastSales.add(new Timestamp(Long.MAX_VALUE - (long)actualRowCount));
            actualIds[actualRowCount] = (Long)resultSet.getObject(1);
            actualNames.add((String)resultSet.getObject(2));
            actualAges[actualRowCount] = (Integer)resultSet.getObject(3);
            actualSalaries[actualRowCount] = (Double)resultSet.getObject(4);
            actualHireDates.add((Date)resultSet.getObject(5));
            actualLastSales.add((Timestamp)resultSet.getObject(6));
            ++actualRowCount;
        }
        collector.checkThat((Object)actualRowCount, CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)50000)));
        collector.checkThat((Object)actualIds, CoreMatchers.is((Object)expectedIds));
        collector.checkThat(actualNames, CoreMatchers.is(expectedNames));
        collector.checkThat((Object)actualAges, CoreMatchers.is((Object)expectedAges));
        collector.checkThat((Object)actualSalaries, CoreMatchers.is((Object)expectedSalaries));
        collector.checkThat(actualHireDates, CoreMatchers.is(expectedHireDates));
        collector.checkThat(actualLastSales, CoreMatchers.is(expectedLastSales));
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

