/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.arrow.driver.jdbc.utils.ConvertUtils;
import org.apache.arrow.flight.sql.FlightSqlColumnMetadata;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.proto.Common;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class ConvertUtilsTest {
    @Rule
    public ErrorCollector collector = new ErrorCollector();

    @Test
    public void testShouldSetOnColumnMetaDataBuilder() {
        Common.ColumnMetaData.Builder builder = Common.ColumnMetaData.newBuilder();
        FlightSqlColumnMetadata expectedColumnMetaData = new FlightSqlColumnMetadata.Builder().catalogName("catalog1").schemaName("schema1").tableName("table1").isAutoIncrement(true).isCaseSensitive(true).isReadOnly(true).isSearchable(true).precision(20).scale(10).build();
        ConvertUtils.setOnColumnMetaDataBuilder((Common.ColumnMetaData.Builder)builder, (Map)expectedColumnMetaData.getMetadataMap());
        this.assertBuilder(builder, expectedColumnMetaData);
    }

    @Test
    public void testShouldConvertArrowFieldsToColumnMetaDataList() {
        ImmutableList listField = ImmutableList.of((Object)new Field("col1", new FieldType(true, (ArrowType)ArrowType.Utf8.INSTANCE, null, new FlightSqlColumnMetadata.Builder().catalogName("catalog1").schemaName("schema1").tableName("table1").build().getMetadataMap()), null));
        ImmutableList expectedColumnMetaData = ImmutableList.of((Object)ColumnMetaData.fromProto((Common.ColumnMetaData)Common.ColumnMetaData.newBuilder().setCatalogName("catalog1").setSchemaName("schema1").setTableName("table1").build()));
        List actualColumnMetaData = ConvertUtils.convertArrowFieldsToColumnMetaDataList((List)listField);
        this.assertColumnMetaData((List<ColumnMetaData>)expectedColumnMetaData, actualColumnMetaData);
    }

    private void assertColumnMetaData(List<ColumnMetaData> expected, List<ColumnMetaData> actual) {
        this.collector.checkThat((Object)expected.size(), CoreMatchers.equalTo((Object)actual.size()));
        int size = expected.size();
        for (int i = 0; i < size; ++i) {
            ColumnMetaData expectedColumnMetaData = expected.get(i);
            ColumnMetaData actualColumnMetaData = actual.get(i);
            this.collector.checkThat((Object)expectedColumnMetaData.catalogName, CoreMatchers.equalTo((Object)actualColumnMetaData.catalogName));
            this.collector.checkThat((Object)expectedColumnMetaData.schemaName, CoreMatchers.equalTo((Object)actualColumnMetaData.schemaName));
            this.collector.checkThat((Object)expectedColumnMetaData.tableName, CoreMatchers.equalTo((Object)actualColumnMetaData.tableName));
            this.collector.checkThat((Object)expectedColumnMetaData.readOnly, CoreMatchers.equalTo((Object)actualColumnMetaData.readOnly));
            this.collector.checkThat((Object)expectedColumnMetaData.autoIncrement, CoreMatchers.equalTo((Object)actualColumnMetaData.autoIncrement));
            this.collector.checkThat((Object)expectedColumnMetaData.precision, CoreMatchers.equalTo((Object)actualColumnMetaData.precision));
            this.collector.checkThat((Object)expectedColumnMetaData.scale, CoreMatchers.equalTo((Object)actualColumnMetaData.scale));
            this.collector.checkThat((Object)expectedColumnMetaData.caseSensitive, CoreMatchers.equalTo((Object)actualColumnMetaData.caseSensitive));
            this.collector.checkThat((Object)expectedColumnMetaData.searchable, CoreMatchers.equalTo((Object)actualColumnMetaData.searchable));
        }
    }

    private void assertBuilder(Common.ColumnMetaData.Builder builder, FlightSqlColumnMetadata flightSqlColumnMetaData) {
        Integer precision = flightSqlColumnMetaData.getPrecision();
        Integer scale = flightSqlColumnMetaData.getScale();
        this.collector.checkThat((Object)flightSqlColumnMetaData.getCatalogName(), CoreMatchers.equalTo((Object)builder.getCatalogName()));
        this.collector.checkThat((Object)flightSqlColumnMetaData.getSchemaName(), CoreMatchers.equalTo((Object)builder.getSchemaName()));
        this.collector.checkThat((Object)flightSqlColumnMetaData.getTableName(), CoreMatchers.equalTo((Object)builder.getTableName()));
        this.collector.checkThat((Object)flightSqlColumnMetaData.isAutoIncrement(), CoreMatchers.equalTo((Object)builder.getAutoIncrement()));
        this.collector.checkThat((Object)flightSqlColumnMetaData.isCaseSensitive(), CoreMatchers.equalTo((Object)builder.getCaseSensitive()));
        this.collector.checkThat((Object)flightSqlColumnMetaData.isSearchable(), CoreMatchers.equalTo((Object)builder.getSearchable()));
        this.collector.checkThat((Object)flightSqlColumnMetaData.isReadOnly(), CoreMatchers.equalTo((Object)builder.getReadOnly()));
        this.collector.checkThat((Object)(precision == null ? 0 : precision), CoreMatchers.equalTo((Object)builder.getPrecision()));
        this.collector.checkThat((Object)(scale == null ? 0 : scale), CoreMatchers.equalTo((Object)builder.getScale()));
    }
}

