/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.sql.Connection;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.utils.ConnectionWrapper;
import org.apache.arrow.driver.jdbc.utils.ThrowableAssertionUtils;
import org.apache.arrow.util.AutoCloseables;
import org.apache.calcite.avatica.AvaticaConnection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public final class ConnectionWrapperTest {
    private static final String SCHEMA_NAME = "SCHEMA";
    private static final String PLACEHOLDER_QUERY = "SELECT * FROM DOES_NOT_MATTER";
    private static final int[] COLUMN_INDICES = IntStream.range(0, 10).toArray();
    private static final String[] COLUMN_NAMES = (String[])Arrays.stream(COLUMN_INDICES).mapToObj(i -> String.format("col%d", i)).toArray(String[]::new);
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String SAVEPOINT_NAME = "SAVEPOINT";
    private static final String CLIENT_INFO = "CLIENT_INFO";
    private static final int RESULT_SET_TYPE = 1003;
    private static final int RESULT_SET_CONCURRENCY = 1007;
    private static final int RESULT_SET_HOLDABILITY = 1;
    private static final int GENERATED_KEYS = 2;
    private static final Random RANDOM = new Random(Long.MAX_VALUE);
    private static final int TIMEOUT = RANDOM.nextInt(Integer.MAX_VALUE);
    @Mock
    public AvaticaConnection underlyingConnection;
    private ConnectionWrapper connectionWrapper;
    @Rule
    public final ErrorCollector collector = new ErrorCollector();

    @Before
    public void setUp() {
        this.connectionWrapper = new ConnectionWrapper((Connection)this.underlyingConnection);
    }

    @After
    public void tearDown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.connectionWrapper, this.underlyingConnection});
    }

    @Test
    public void testUnwrappingUnderlyingConnectionShouldReturnUnderlyingConnection() {
        this.collector.checkThat(this.collector.checkSucceeds(() -> this.connectionWrapper.unwrap(Object.class)), CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.underlyingConnection)));
        this.collector.checkThat((Object)((Connection)this.collector.checkSucceeds(() -> (Connection)this.connectionWrapper.unwrap(Connection.class))), CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.underlyingConnection)));
        this.collector.checkThat((Object)((AvaticaConnection)this.collector.checkSucceeds(() -> (AvaticaConnection)this.connectionWrapper.unwrap(AvaticaConnection.class))), CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.underlyingConnection)));
        ThrowableAssertionUtils.simpleAssertThrowableClass(ClassCastException.class, () -> {
            ArrowFlightConnection cfr_ignored_0 = (ArrowFlightConnection)this.connectionWrapper.unwrap(ArrowFlightConnection.class);
        });
        ThrowableAssertionUtils.simpleAssertThrowableClass(ClassCastException.class, () -> {
            ConnectionWrapper cfr_ignored_0 = (ConnectionWrapper)this.connectionWrapper.unwrap(ConnectionWrapper.class);
        });
    }

    @Test
    public void testCreateStatementShouldCreateStatementFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.createStatement(), CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).createStatement())));
        this.collector.checkThat((Object)this.connectionWrapper.createStatement(1003, 1007, 1), CoreMatchers.is((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).createStatement(1003, 1007, 1)));
        this.collector.checkThat((Object)this.connectionWrapper.createStatement(1003, 1007), CoreMatchers.is((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).createStatement(1003, 1007)));
    }

    @Test
    public void testPrepareStatementShouldPrepareStatementFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.prepareStatement(PLACEHOLDER_QUERY), CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).prepareStatement(PLACEHOLDER_QUERY))));
        this.collector.checkThat((Object)this.connectionWrapper.prepareStatement(PLACEHOLDER_QUERY, COLUMN_INDICES), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).prepareStatement(PLACEHOLDER_QUERY, COLUMN_INDICES)), CoreMatchers.nullValue()})));
        this.collector.checkThat((Object)this.connectionWrapper.prepareStatement(PLACEHOLDER_QUERY, COLUMN_NAMES), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).prepareStatement(PLACEHOLDER_QUERY, COLUMN_NAMES)), CoreMatchers.nullValue()})));
        this.collector.checkThat((Object)this.connectionWrapper.prepareStatement(PLACEHOLDER_QUERY, 1003, 1007), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).prepareStatement(PLACEHOLDER_QUERY, 1003, 1007)), CoreMatchers.nullValue()})));
        this.collector.checkThat((Object)this.connectionWrapper.prepareStatement(PLACEHOLDER_QUERY, 2), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).prepareStatement(PLACEHOLDER_QUERY, 2)), CoreMatchers.nullValue()})));
    }

    @Test
    public void testPrepareCallShouldPrepareCallFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.prepareCall(PLACEHOLDER_QUERY), CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).prepareCall(PLACEHOLDER_QUERY))));
        this.collector.checkThat((Object)this.connectionWrapper.prepareCall(PLACEHOLDER_QUERY, 1003, 1007), CoreMatchers.is((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).prepareCall(PLACEHOLDER_QUERY, 1003, 1007)));
    }

    @Test
    public void testNativeSqlShouldGetNativeSqlFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.nativeSQL(PLACEHOLDER_QUERY), CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).nativeSQL(PLACEHOLDER_QUERY))));
    }

    @Test
    public void testSetAutoCommitShouldSetAutoCommitInUnderlyingConnection() throws SQLException {
        this.connectionWrapper.setAutoCommit(true);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setAutoCommit(true);
        this.connectionWrapper.setAutoCommit(false);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setAutoCommit(false);
    }

    @Test
    public void testGetAutoCommitShouldGetAutoCommitFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.getAutoCommit(), CoreMatchers.is((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).getAutoCommit()));
    }

    @Test
    public void testCommitShouldCommitToUnderlyingConnection() throws SQLException {
        this.connectionWrapper.commit();
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).commit();
    }

    @Test
    public void testRollbackShouldRollbackFromUnderlyingConnection() throws SQLException {
        this.connectionWrapper.rollback();
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).rollback();
    }

    @Test
    public void testCloseShouldCloseUnderlyingConnection() throws SQLException {
        this.connectionWrapper.close();
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testIsClosedShouldGetStatusFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.isClosed(), CoreMatchers.is((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).isClosed()));
    }

    @Test
    public void testGetMetadataShouldGetMetadataFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.getMetaData(), CoreMatchers.is((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).getMetaData()));
    }

    @Test
    public void testSetReadOnlyShouldSetUnderlyingConnectionAsReadOnly() throws SQLException {
        this.connectionWrapper.setReadOnly(false);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setReadOnly(false);
        this.connectionWrapper.setReadOnly(true);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setReadOnly(true);
    }

    @Test
    public void testSetIsReadOnlyShouldGetStatusFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.isReadOnly(), CoreMatchers.is((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection)).isReadOnly()));
    }

    @Test
    public void testSetCatalogShouldSetCatalogInUnderlyingConnection() throws SQLException {
        String catalog = "CATALOG";
        this.connectionWrapper.setCatalog("CATALOG");
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setCatalog("CATALOG");
    }

    @Test
    public void testGetCatalogShouldGetCatalogFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.getCatalog(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).getCatalog()), CoreMatchers.nullValue()})));
    }

    @Test
    public void setTransactionIsolationShouldSetUnderlyingTransactionIsolation() throws SQLException {
        boolean transactionIsolation = false;
        this.connectionWrapper.setTransactionIsolation(0);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setTransactionIsolation(0);
    }

    @Test
    public void getTransactionIsolationShouldGetUnderlyingConnectionIsolation() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.getTransactionIsolation(), CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).getTransactionIsolation())));
    }

    @Test
    public void getWarningShouldGetWarningsFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.getWarnings(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).getWarnings()), CoreMatchers.nullValue()})));
    }

    @Test
    public void testClearWarningShouldClearWarningsFromUnderlyingConnection() throws SQLException {
        this.connectionWrapper.clearWarnings();
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).clearWarnings();
    }

    @Test
    public void getTypeMapShouldGetTypeMapFromUnderlyingConnection() throws SQLException {
        Mockito.when((Object)this.underlyingConnection.getTypeMap()).thenReturn(null);
        this.collector.checkThat((Object)this.connectionWrapper.getTypeMap(), CoreMatchers.is((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).getTypeMap()));
    }

    @Test
    public void testSetTypeMapShouldSetTypeMapFromUnderlyingConnection() throws SQLException {
        this.connectionWrapper.setTypeMap(null);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setTypeMap(null);
    }

    @Test
    public void testSetHoldabilityShouldSetUnderlyingConnection() throws SQLException {
        this.connectionWrapper.setHoldability(1);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setHoldability(1);
    }

    @Test
    public void testGetHoldabilityShouldGetHoldabilityFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.getHoldability(), CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).getHoldability())));
    }

    @Test
    public void testSetSavepointShouldSetSavepointInUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.setSavepoint(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setSavepoint()), CoreMatchers.nullValue()})));
        this.collector.checkThat((Object)this.connectionWrapper.setSavepoint(SAVEPOINT_NAME), CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setSavepoint(SAVEPOINT_NAME))));
    }

    @Test
    public void testRollbackShouldRollbackInUnderlyingConnection() throws SQLException {
        this.connectionWrapper.rollback(null);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).rollback(null);
    }

    @Test
    public void testReleaseSavepointShouldReleaseSavepointFromUnderlyingConnection() throws SQLException {
        this.connectionWrapper.releaseSavepoint(null);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).releaseSavepoint(null);
    }

    @Test
    public void testCreateClobShouldCreateClobFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.createClob(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).createClob()), CoreMatchers.nullValue()})));
    }

    @Test
    public void testCreateBlobShouldCreateBlobFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.createBlob(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).createBlob()), CoreMatchers.nullValue()})));
    }

    @Test
    public void testCreateNClobShouldCreateNClobFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.createNClob(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).createNClob()), CoreMatchers.nullValue()})));
    }

    @Test
    public void testCreateSQLXMLShouldCreateSQLXMLFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.createSQLXML(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).createSQLXML()), CoreMatchers.nullValue()})));
    }

    @Test
    public void testIsValidShouldReturnWhetherUnderlyingConnectionIsValid() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.isValid(TIMEOUT), CoreMatchers.is((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).isValid(TIMEOUT)));
    }

    @Test
    public void testSetClientInfoShouldSetClientInfoInUnderlyingConnection() throws SQLClientInfoException {
        this.connectionWrapper.setClientInfo(null);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setClientInfo(null);
    }

    @Test
    public void testGetClientInfoShouldGetClientInfoFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.getClientInfo(CLIENT_INFO), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).getClientInfo(CLIENT_INFO)), CoreMatchers.nullValue()})));
        this.collector.checkThat((Object)this.connectionWrapper.getClientInfo(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).getClientInfo()), CoreMatchers.nullValue()})));
    }

    @Test
    public void testCreateArrayOfShouldCreateArrayFromUnderlyingConnection() throws SQLException {
        Object[] elements = IntStream.range(0, 100).boxed().toArray();
        this.collector.checkThat((Object)this.connectionWrapper.createArrayOf(TYPE_NAME, elements), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).createArrayOf(TYPE_NAME, elements)), CoreMatchers.nullValue()})));
    }

    @Test
    public void testCreateStructShouldCreateStructFromUnderlyingConnection() throws SQLException {
        Object[] attributes = IntStream.range(0, 120).boxed().toArray();
        this.collector.checkThat((Object)this.connectionWrapper.createStruct(TYPE_NAME, attributes), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).createStruct(TYPE_NAME, attributes)), CoreMatchers.nullValue()})));
    }

    @Test
    public void testSetSchemaShouldSetSchemaInUnderlyingConnection() throws SQLException {
        this.connectionWrapper.setSchema(SCHEMA_NAME);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setSchema(SCHEMA_NAME);
    }

    @Test
    public void testGetSchemaShouldGetSchemaFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.getSchema(), CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).getSchema()), CoreMatchers.nullValue()})));
    }

    @Test
    public void testAbortShouldAbortUnderlyingConnection() throws SQLException {
        this.connectionWrapper.abort(null);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).abort(null);
    }

    @Test
    public void testSetNetworkTimeoutShouldSetNetworkTimeoutInUnderlyingConnection() throws SQLException {
        this.connectionWrapper.setNetworkTimeout(null, TIMEOUT);
        ((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).setNetworkTimeout(null, TIMEOUT);
    }

    @Test
    public void testGetNetworkTimeoutShouldGetNetworkTimeoutFromUnderlyingConnection() throws SQLException {
        this.collector.checkThat((Object)this.connectionWrapper.getNetworkTimeout(), CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)((AvaticaConnection)Mockito.verify((Object)this.underlyingConnection, (VerificationMode)Mockito.times((int)1))).getNetworkTimeout())));
    }
}

