/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.apache.arrow.driver.jdbc.utils.ThrowableAssertionUtils;
import org.apache.arrow.util.AutoCloseables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=Parameterized.class)
public final class ArrowFlightConnectionPropertyTest {
    @Mock
    public Properties properties;
    private AutoCloseable mockitoResource;
    @Parameterized.Parameter
    public ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty arrowFlightConnectionProperty;

    @Before
    public void setUp() {
        this.mockitoResource = MockitoAnnotations.openMocks((Object)this);
    }

    @After
    public void tearDown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.mockitoResource});
    }

    @Test
    public void testWrapIsUnsupported() {
        ThrowableAssertionUtils.simpleAssertThrowableClass(UnsupportedOperationException.class, () -> this.arrowFlightConnectionProperty.wrap(this.properties));
    }

    @Test
    public void testRequiredPropertyThrows() {
        Assume.assumeTrue((boolean)this.arrowFlightConnectionProperty.required());
        ThrowableAssertionUtils.simpleAssertThrowableClass(IllegalStateException.class, () -> this.arrowFlightConnectionProperty.get(new Properties()));
    }

    @Test
    public void testOptionalPropertyReturnsDefault() {
        Assume.assumeTrue((!this.arrowFlightConnectionProperty.required() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.arrowFlightConnectionProperty.defaultValue(), (Object)this.arrowFlightConnectionProperty.get(new Properties()));
    }

    @Parameterized.Parameters
    public static List<Object[]> provideParameters() {
        ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty[] arrowFlightConnectionProperties = ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.values();
        ArrayList<Object[]> parameters = new ArrayList<Object[]>(arrowFlightConnectionProperties.length);
        for (ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty arrowFlightConnectionProperty : arrowFlightConnectionProperties) {
            parameters.add(new Object[]{arrowFlightConnectionProperty});
        }
        return parameters;
    }
}

