/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.function.Function;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.hamcrest.CoreMatchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ArrowFlightConnectionConfigImplTest {
    private static final Random RANDOM = new Random(12L);
    private final Properties properties = new Properties();
    private ArrowFlightConnectionConfigImpl arrowFlightConnectionConfig;
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    @Parameterized.Parameter
    public ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty property;
    @Parameterized.Parameter(value=1)
    public Object value;
    @Parameterized.Parameter(value=2)
    public Function<ArrowFlightConnectionConfigImpl, ?> arrowFlightConnectionConfigFunction;

    @Before
    public void setUp() {
        this.arrowFlightConnectionConfig = new ArrowFlightConnectionConfigImpl(this.properties);
        this.properties.put(this.property.camelName(), this.value);
    }

    @Test
    public void testGetProperty() {
        this.collector.checkThat(this.arrowFlightConnectionConfigFunction.apply(this.arrowFlightConnectionConfig), CoreMatchers.is((Object)this.value));
    }

    @Parameterized.Parameters(name="<{0}> as <{1}>")
    public static List<Object[]> provideParameters() {
        return Arrays.asList({ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.HOST, "host", ArrowFlightConnectionConfigImpl::getHost}, {ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PORT, RANDOM.nextInt(Short.toUnsignedInt((short)Short.MAX_VALUE)), ArrowFlightConnectionConfigImpl::getPort}, {ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER, "user", ArrowFlightConnectionConfigImpl::getUser}, {ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD, "password", ArrowFlightConnectionConfigImpl::getPassword}, {ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USE_ENCRYPTION, RANDOM.nextBoolean(), ArrowFlightConnectionConfigImpl::useEncryption}, {ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.THREAD_POOL_SIZE, RANDOM.nextInt(Runtime.getRuntime().availableProcessors()), ArrowFlightConnectionConfigImpl::threadPoolSize});
    }
}

