/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.utils.ThrowableAssertionUtils;
import org.apache.arrow.vector.ValueVector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.rules.ErrorCollector;

public class AccessorTestUtils {

    public static class AccessorIterator<T extends ArrowFlightJdbcAccessor> {
        private final ErrorCollector collector;
        private final AccessorSupplier<T> accessorSupplier;

        public AccessorIterator(ErrorCollector collector, AccessorSupplier<T> accessorSupplier) {
            this.collector = collector;
            this.accessorSupplier = accessorSupplier;
        }

        public void iterate(ValueVector vector, AccessorConsumer<T> accessorConsumer) throws Exception {
            int valueCount = vector.getValueCount();
            if (valueCount == 0) {
                throw new IllegalArgumentException("Vector is empty");
            }
            Cursor cursor = new Cursor(valueCount);
            T accessor = this.accessorSupplier.supply(vector, cursor::getCurrentRow);
            while (cursor.hasNext()) {
                accessorConsumer.accept(accessor, cursor.getCurrentRow());
                cursor.next();
            }
        }

        public void iterate(ValueVector vector, Consumer<T> accessorConsumer) throws Exception {
            this.iterate(vector, (T accessor, int currentRow) -> accessorConsumer.accept(accessor));
        }

        public List<Object> toList(ValueVector vector) throws Exception {
            ArrayList<Object> result = new ArrayList<Object>();
            this.iterate(vector, (T accessor, int currentRow) -> result.add(accessor.getObject()));
            return result;
        }

        public <R> void assertAccessorGetter(ValueVector vector, CheckedFunction<T, R> getter, MatcherGetter<T, R> matcherGetter) throws Exception {
            this.iterate(vector, (T accessor, int currentRow) -> {
                Object object = getter.apply(accessor);
                boolean wasNull = accessor.wasNull();
                this.collector.checkThat(object, matcherGetter.get(accessor, currentRow));
                this.collector.checkThat((Object)wasNull, CoreMatchers.is((Object)(accessor.getObject() == null ? 1 : 0)));
            });
        }

        public <R> void assertAccessorGetterThrowingException(ValueVector vector, CheckedFunction<T, R> getter) throws Exception {
            this.iterate(vector, (T accessor, int currentRow) -> ThrowableAssertionUtils.simpleAssertThrowableClass(SQLException.class, () -> getter.apply(accessor)));
        }

        public <R> void assertAccessorGetter(ValueVector vector, CheckedFunction<T, R> getter, Function<T, Matcher<R>> matcherGetter) throws Exception {
            this.assertAccessorGetter(vector, getter, (T accessor, int currentRow) -> (Matcher)matcherGetter.apply(accessor));
        }

        public <R> void assertAccessorGetter(ValueVector vector, CheckedFunction<T, R> getter, Supplier<Matcher<R>> matcherGetter) throws Exception {
            this.assertAccessorGetter(vector, getter, (T accessor, int currentRow) -> (Matcher)matcherGetter.get());
        }

        public <R> void assertAccessorGetter(ValueVector vector, CheckedFunction<T, R> getter, Matcher<R> matcher) throws Exception {
            this.assertAccessorGetter(vector, getter, (T accessor, int currentRow) -> matcher);
        }
    }

    public static class Cursor {
        int currentRow = 0;
        int limit;

        public Cursor(int limit) {
            this.limit = limit;
        }

        public void next() {
            ++this.currentRow;
        }

        boolean hasNext() {
            return this.currentRow < this.limit;
        }

        public int getCurrentRow() {
            return this.currentRow;
        }
    }

    public static interface MatcherGetter<T extends ArrowFlightJdbcAccessor, R> {
        public Matcher<R> get(T var1, int var2);
    }

    public static interface AccessorConsumer<T extends ArrowFlightJdbcAccessor> {
        public void accept(T var1, int var2) throws Exception;
    }

    public static interface AccessorSupplier<T extends ArrowFlightJdbcAccessor> {
        public T supply(ValueVector var1, IntSupplier var2);
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws SQLException;
    }
}

