/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.client.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.arrow.driver.jdbc.client.utils.ClientAuthenticationUtils;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ClientAuthenticationUtilsTest {
    @Mock
    KeyStore keyStoreMock;

    @Test
    public void testGetCertificatesInputStream() throws IOException, KeyStoreException {
        JcaPEMWriter pemWriterMock = (JcaPEMWriter)Mockito.mock(JcaPEMWriter.class);
        Certificate certificateMock = (Certificate)Mockito.mock(Certificate.class);
        Enumeration<String> alias = Collections.enumeration(Arrays.asList("test1", "test2"));
        Mockito.when(this.keyStoreMock.aliases()).thenReturn(alias);
        Mockito.when((Object)this.keyStoreMock.isCertificateEntry("test1")).thenReturn((Object)true);
        Mockito.when((Object)this.keyStoreMock.getCertificate("test1")).thenReturn((Object)certificateMock);
        ClientAuthenticationUtils.getCertificatesInputStream((KeyStore)this.keyStoreMock, (JcaPEMWriter)pemWriterMock);
        ((JcaPEMWriter)Mockito.verify((Object)pemWriterMock)).writeObject((Object)certificateMock);
        ((JcaPEMWriter)Mockito.verify((Object)pemWriterMock)).flush();
    }

    @Test
    public void testGetKeyStoreInstance() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try (MockedStatic keyStoreMockedStatic = Mockito.mockStatic(KeyStore.class);){
            keyStoreMockedStatic.when(() -> ClientAuthenticationUtils.getKeyStoreInstance((String)((String)Mockito.any()))).thenReturn((Object)this.keyStoreMock);
            KeyStore receiveKeyStore = ClientAuthenticationUtils.getKeyStoreInstance((String)"test1");
            ((KeyStore)Mockito.verify((Object)this.keyStoreMock)).load(null, null);
            Assert.assertEquals((Object)receiveKeyStore, (Object)this.keyStoreMock);
        }
    }

    @Test
    public void testGetDefaultKeyStoreInstancePassword() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try (MockedStatic keyStoreMockedStatic = Mockito.mockStatic(KeyStore.class);){
            keyStoreMockedStatic.when(() -> ClientAuthenticationUtils.getDefaultKeyStoreInstance((String)"changeit")).thenReturn((Object)this.keyStoreMock);
            KeyStore receiveKeyStore = ClientAuthenticationUtils.getDefaultKeyStoreInstance((String)"changeit");
            Assert.assertEquals((Object)receiveKeyStore, (Object)this.keyStoreMock);
        }
    }

    @Test
    public void testGetDefaultKeyStoreInstanceNoPassword() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try (MockedStatic keyStoreMockedStatic = Mockito.mockStatic(KeyStore.class);){
            keyStoreMockedStatic.when(() -> ClientAuthenticationUtils.getDefaultKeyStoreInstance(null)).thenReturn((Object)this.keyStoreMock);
            KeyStore receiveKeyStore = ClientAuthenticationUtils.getDefaultKeyStoreInstance(null);
            Assert.assertEquals((Object)receiveKeyStore, (Object)this.keyStoreMock);
        }
    }

    @Test
    public void testGetCertificateInputStreamFromMacSystem() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        InputStream mock = (InputStream)Mockito.mock(InputStream.class);
        try (MockedStatic<KeyStore> keyStoreMockedStatic = this.createKeyStoreStaticMock();
             MockedStatic<ClientAuthenticationUtils> clientAuthenticationUtilsMockedStatic = this.createClientAuthenticationUtilsStaticMock();){
            this.setOperatingSystemMock(clientAuthenticationUtilsMockedStatic, false, true);
            keyStoreMockedStatic.when(() -> ClientAuthenticationUtils.getKeyStoreInstance((String)"KeychainStore")).thenReturn((Object)this.keyStoreMock);
            keyStoreMockedStatic.when(() -> ClientAuthenticationUtils.getDefaultKeyStoreInstance((String)"changeit")).thenReturn((Object)this.keyStoreMock);
            clientAuthenticationUtilsMockedStatic.when(ClientAuthenticationUtils::getKeystoreInputStream).thenCallRealMethod();
            keyStoreMockedStatic.when(KeyStore::getDefaultType).thenCallRealMethod();
            keyStoreMockedStatic.when(() -> ClientAuthenticationUtils.getCertificatesInputStream((Collection)((Collection)Mockito.any()))).thenReturn((Object)mock);
            InputStream inputStream = ClientAuthenticationUtils.getCertificateInputStreamFromSystem((String)"changeit");
            Assert.assertEquals((Object)inputStream, (Object)mock);
        }
    }

    @Test
    public void testGetCertificateInputStreamFromWindowsSystem() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        InputStream mock = (InputStream)Mockito.mock(InputStream.class);
        try (MockedStatic<KeyStore> keyStoreMockedStatic = this.createKeyStoreStaticMock();
             MockedStatic<ClientAuthenticationUtils> clientAuthenticationUtilsMockedStatic = this.createClientAuthenticationUtilsStaticMock();){
            this.setOperatingSystemMock(clientAuthenticationUtilsMockedStatic, true, false);
            keyStoreMockedStatic.when(() -> ClientAuthenticationUtils.getKeyStoreInstance((String)"Windows-ROOT")).thenReturn((Object)this.keyStoreMock);
            keyStoreMockedStatic.when(() -> ClientAuthenticationUtils.getKeyStoreInstance((String)"Windows-MY")).thenReturn((Object)this.keyStoreMock);
            keyStoreMockedStatic.when(() -> ClientAuthenticationUtils.getCertificatesInputStream((Collection)((Collection)Mockito.any()))).thenReturn((Object)mock);
            InputStream inputStream = ClientAuthenticationUtils.getCertificateInputStreamFromSystem((String)"test");
            Assert.assertEquals((Object)inputStream, (Object)mock);
        }
    }

    @Test
    public void testGetCertificateInputStreamFromLinuxSystem() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        InputStream mock = (InputStream)Mockito.mock(InputStream.class);
        try (MockedStatic<KeyStore> keyStoreMockedStatic = this.createKeyStoreStaticMock();
             MockedStatic<ClientAuthenticationUtils> clientAuthenticationUtilsMockedStatic = this.createClientAuthenticationUtilsStaticMock();){
            this.setOperatingSystemMock(clientAuthenticationUtilsMockedStatic, false, false);
            keyStoreMockedStatic.when(() -> ClientAuthenticationUtils.getCertificatesInputStream((Collection)((Collection)Mockito.any()))).thenReturn((Object)mock);
            keyStoreMockedStatic.when(() -> ClientAuthenticationUtils.getDefaultKeyStoreInstance((String)((String)Mockito.any()))).thenReturn((Object)this.keyStoreMock);
            clientAuthenticationUtilsMockedStatic.when(ClientAuthenticationUtils::getKeystoreInputStream).thenCallRealMethod();
            keyStoreMockedStatic.when(KeyStore::getDefaultType).thenCallRealMethod();
            InputStream inputStream = ClientAuthenticationUtils.getCertificateInputStreamFromSystem((String)"changeit");
            Assert.assertEquals((Object)inputStream, (Object)mock);
            inputStream = ClientAuthenticationUtils.getCertificateInputStreamFromSystem(null);
            Assert.assertEquals((Object)inputStream, (Object)mock);
        }
    }

    private MockedStatic<KeyStore> createKeyStoreStaticMock() {
        return Mockito.mockStatic(KeyStore.class, invocationOnMock -> {
            Method method = invocationOnMock.getMethod();
            if (method.getName().equals("getInstance")) {
                return invocationOnMock.callRealMethod();
            }
            return method.invoke(invocationOnMock.getMock(), invocationOnMock.getArguments());
        });
    }

    private MockedStatic<ClientAuthenticationUtils> createClientAuthenticationUtilsStaticMock() {
        return Mockito.mockStatic(ClientAuthenticationUtils.class, invocationOnMock -> {
            Method method = invocationOnMock.getMethod();
            if (method.getName().equals("getCertificateInputStreamFromSystem")) {
                return invocationOnMock.callRealMethod();
            }
            return method.invoke(invocationOnMock.getMock(), invocationOnMock.getArguments());
        });
    }

    private void setOperatingSystemMock(MockedStatic<ClientAuthenticationUtils> clientAuthenticationUtilsMockedStatic, boolean isWindows, boolean isMac) {
        clientAuthenticationUtilsMockedStatic.when(ClientAuthenticationUtils::isMac).thenReturn((Object)isMac);
        Assert.assertEquals((Object)ClientAuthenticationUtils.isMac(), (Object)isMac);
        clientAuthenticationUtilsMockedStatic.when(ClientAuthenticationUtils::isWindows).thenReturn((Object)isWindows);
        Assert.assertEquals((Object)ClientAuthenticationUtils.isWindows(), (Object)isWindows);
    }
}

