/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.client;

import org.apache.arrow.driver.jdbc.FlightServerTestRule;
import org.apache.arrow.driver.jdbc.client.ArrowFlightSqlClientHandler;
import org.apache.arrow.driver.jdbc.utils.CoreMockedSqlProducers;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ArrowFlightSqlClientHandlerBuilderTest {
    @ClassRule
    public static final FlightServerTestRule FLIGHT_SERVER_TEST_RULE = FlightServerTestRule.createStandardTestRule(CoreMockedSqlProducers.getLegacyProducer());
    private static BufferAllocator allocator;

    @BeforeClass
    public static void setup() {
        allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @AfterClass
    public static void tearDown() {
        allocator.close();
    }

    @Test
    public void testRetainCookiesOnAuthOff() throws Exception {
        ArrowFlightSqlClientHandler.Builder rootBuilder = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withPort(FLIGHT_SERVER_TEST_RULE.getPort()).withBufferAllocator(allocator).withUsername("flight-test-user").withPassword("flight-test-password").withEncryption(false).withRetainCookies(true).withRetainAuth(false);
        try (ArrowFlightSqlClientHandler rootHandler = rootBuilder.build();){
            ArrowFlightSqlClientHandler.Builder testBuilder = new ArrowFlightSqlClientHandler.Builder(rootBuilder);
            Assert.assertSame((Object)rootBuilder.cookieFactory, (Object)testBuilder.cookieFactory);
            Assert.assertNotSame((Object)rootBuilder.authFactory, (Object)testBuilder.authFactory);
        }
    }

    @Test
    public void testRetainCookiesOffAuthOff() throws Exception {
        ArrowFlightSqlClientHandler.Builder rootBuilder = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withPort(FLIGHT_SERVER_TEST_RULE.getPort()).withBufferAllocator(allocator).withUsername("flight-test-user").withPassword("flight-test-password").withEncryption(false).withRetainCookies(false).withRetainAuth(false);
        try (ArrowFlightSqlClientHandler rootHandler = rootBuilder.build();){
            ArrowFlightSqlClientHandler.Builder testBuilder = new ArrowFlightSqlClientHandler.Builder(rootBuilder);
            Assert.assertNotSame((Object)rootBuilder.cookieFactory, (Object)testBuilder.cookieFactory);
            Assert.assertNotSame((Object)rootBuilder.authFactory, (Object)testBuilder.authFactory);
        }
    }

    @Test
    public void testRetainCookiesOnAuthOn() throws Exception {
        ArrowFlightSqlClientHandler.Builder rootBuilder = new ArrowFlightSqlClientHandler.Builder().withHost(FLIGHT_SERVER_TEST_RULE.getHost()).withPort(FLIGHT_SERVER_TEST_RULE.getPort()).withBufferAllocator(allocator).withUsername("flight-test-user").withPassword("flight-test-password").withEncryption(false).withRetainCookies(true).withRetainAuth(true);
        try (ArrowFlightSqlClientHandler rootHandler = rootBuilder.build();){
            ArrowFlightSqlClientHandler.Builder testBuilder = new ArrowFlightSqlClientHandler.Builder(rootBuilder);
            Assert.assertSame((Object)rootBuilder.cookieFactory, (Object)testBuilder.cookieFactory);
            Assert.assertSame((Object)rootBuilder.authFactory, (Object)testBuilder.authFactory);
        }
    }

    @Test
    public void testDefaults() {
        ArrowFlightSqlClientHandler.Builder builder = new ArrowFlightSqlClientHandler.Builder();
        Assert.assertNull((Object)builder.username);
        Assert.assertNull((Object)builder.password);
        Assert.assertTrue((boolean)builder.useEncryption);
        Assert.assertFalse((boolean)builder.disableCertificateVerification);
        Assert.assertNull((Object)builder.trustStorePath);
        Assert.assertNull((Object)builder.trustStorePassword);
        Assert.assertTrue((boolean)builder.useSystemTrustStore);
        Assert.assertNull((Object)builder.token);
        Assert.assertTrue((boolean)builder.retainAuth);
        Assert.assertTrue((boolean)builder.retainCookies);
        Assert.assertNull((Object)builder.tlsRootCertificatesPath);
        Assert.assertNull((Object)builder.clientCertificatePath);
        Assert.assertNull((Object)builder.clientKeyPath);
    }
}

