/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.authentication;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.arrow.driver.jdbc.authentication.Authentication;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.auth2.BasicCallHeaderAuthenticator;
import org.apache.arrow.flight.auth2.CallHeaderAuthenticator;
import org.apache.arrow.flight.auth2.GeneratedBearerTokenAuthenticator;

public class UserPasswordAuthentication
implements Authentication {
    private final Map<String, String> validCredentials;

    public UserPasswordAuthentication(Map<String, String> validCredentials) {
        this.validCredentials = validCredentials;
    }

    private String getCredentials(String key) {
        return this.validCredentials.getOrDefault(key, null);
    }

    @Override
    public CallHeaderAuthenticator authenticate() {
        return new GeneratedBearerTokenAuthenticator((CallHeaderAuthenticator)new BasicCallHeaderAuthenticator((username, password) -> {
            if (this.validCredentials.containsKey(username) && this.getCredentials(username).equals(password)) {
                return () -> username;
            }
            throw CallStatus.UNAUTHENTICATED.withDescription("Invalid credentials.").toRuntimeException();
        }));
    }

    @Override
    public void populateProperties(Properties properties) {
        this.validCredentials.forEach((key, value) -> {
            properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.USER.camelName(), key);
            properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.PASSWORD.camelName(), value);
        });
    }

    public static class Builder {
        Map<String, String> credentials = new HashMap<String, String>();

        public Builder user(String username, String password) {
            this.credentials.put(username, password);
            return this;
        }

        public UserPasswordAuthentication build() {
            return new UserPasswordAuthentication(this.credentials);
        }
    }
}

