/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.authentication;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.arrow.driver.jdbc.authentication.Authentication;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;
import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.auth2.CallHeaderAuthenticator;

public class TokenAuthentication
implements Authentication {
    private final List<String> validCredentials;

    public TokenAuthentication(List<String> validCredentials) {
        this.validCredentials = validCredentials;
    }

    @Override
    public CallHeaderAuthenticator authenticate() {
        return new CallHeaderAuthenticator(){

            public CallHeaderAuthenticator.AuthResult authenticate(CallHeaders incomingHeaders) {
                final String authorization = incomingHeaders.get("authorization");
                if (!TokenAuthentication.this.validCredentials.contains(authorization)) {
                    throw CallStatus.UNAUTHENTICATED.withDescription("Invalid credentials.").toRuntimeException();
                }
                return new CallHeaderAuthenticator.AuthResult(){

                    public String getPeerIdentity() {
                        return authorization;
                    }
                };
            }
        };
    }

    @Override
    public void populateProperties(Properties properties) {
        this.validCredentials.forEach(value -> properties.put(ArrowFlightConnectionConfigImpl.ArrowFlightConnectionProperty.TOKEN.camelName(), value));
    }

    public static final class Builder {
        private final List<String> tokenList = new ArrayList<String>();

        public Builder token(String token) {
            this.tokenList.add("Bearer " + token);
            return this;
        }

        public TokenAuthentication build() {
            return new TokenAuthentication(this.tokenList);
        }
    }
}

