/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.text;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcDateVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcTimeStampVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.calendar.ArrowFlightJdbcTimeVectorAccessor;
import org.apache.arrow.driver.jdbc.accessor.impl.text.ArrowFlightJdbcVarCharVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.driver.jdbc.utils.ThrowableAssertionUtils;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.util.Text;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArrowFlightJdbcVarCharVectorAccessorTest {
    private ArrowFlightJdbcVarCharVectorAccessor accessor;
    private final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSSXXX");
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Mock
    private ArrowFlightJdbcVarCharVectorAccessor.Getter getter;
    @Rule
    public ErrorCollector collector = new ErrorCollector();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        IntSupplier currentRowSupplier = () -> 0;
        this.accessor = new ArrowFlightJdbcVarCharVectorAccessor(this.getter, currentRowSupplier, wasNull -> {});
    }

    @Test
    public void testShouldGetStringFromNullReturnNull() {
        Mockito.when((Object)this.getter.get(0)).thenReturn(null);
        String result = this.accessor.getString();
        this.collector.checkThat((Object)result, CoreMatchers.equalTo(null));
    }

    @Test
    public void testShouldGetStringReturnValidString() {
        Text value = new Text("Value for Test.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        String result = this.accessor.getString();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(String.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)value.toString()));
    }

    @Test
    public void testShouldGetObjectReturnValidString() {
        Text value = new Text("Value for Test.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        String result = this.accessor.getObject();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(String.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)value.toString()));
    }

    @Test
    public void testShouldGetByteThrowsExceptionForNonNumericValue() throws Exception {
        Text value = new Text("Invalid value for byte.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getByte();
    }

    @Test
    public void testShouldGetByteThrowsExceptionForOutOfRangePositiveValue() throws Exception {
        Text value = new Text("128");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getByte();
    }

    @Test
    public void testShouldGetByteThrowsExceptionForOutOfRangeNegativeValue() throws Exception {
        Text value = new Text("-129");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getByte();
    }

    @Test
    public void testShouldGetByteReturnValidPositiveByte() throws Exception {
        Text value = new Text("127");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        byte result = this.accessor.getByte();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Byte.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)127));
    }

    @Test
    public void testShouldGetByteReturnValidNegativeByte() throws Exception {
        Text value = new Text("-128");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        byte result = this.accessor.getByte();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Byte.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)-128));
    }

    @Test
    public void testShouldGetShortThrowsExceptionForNonNumericValue() throws Exception {
        Text value = new Text("Invalid value for short.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getShort();
    }

    @Test
    public void testShouldGetShortThrowsExceptionForOutOfRangePositiveValue() throws Exception {
        Text value = new Text("32768");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getShort();
    }

    @Test
    public void testShouldGetShortThrowsExceptionForOutOfRangeNegativeValue() throws Exception {
        Text value = new Text("-32769");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getShort();
    }

    @Test
    public void testShouldGetShortReturnValidPositiveShort() throws Exception {
        Text value = new Text("32767");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        short result = this.accessor.getShort();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Short.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)Short.MAX_VALUE));
    }

    @Test
    public void testShouldGetShortReturnValidNegativeShort() throws Exception {
        Text value = new Text("-32768");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        short result = this.accessor.getShort();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Short.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)Short.MIN_VALUE));
    }

    @Test
    public void testShouldGetIntThrowsExceptionForNonNumericValue() throws Exception {
        Text value = new Text("Invalid value for int.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getInt();
    }

    @Test
    public void testShouldGetIntThrowsExceptionForOutOfRangePositiveValue() throws Exception {
        Text value = new Text("2147483648");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getInt();
    }

    @Test
    public void testShouldGetIntThrowsExceptionForOutOfRangeNegativeValue() throws Exception {
        Text value = new Text("-2147483649");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getInt();
    }

    @Test
    public void testShouldGetIntReturnValidPositiveInteger() throws Exception {
        Text value = new Text("2147483647");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        int result = this.accessor.getInt();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Integer.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)Integer.MAX_VALUE));
    }

    @Test
    public void testShouldGetIntReturnValidNegativeInteger() throws Exception {
        Text value = new Text("-2147483648");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        int result = this.accessor.getInt();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Integer.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)Integer.MIN_VALUE));
    }

    @Test
    public void testShouldGetLongThrowsExceptionForNonNumericValue() throws Exception {
        Text value = new Text("Invalid value for long.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getLong();
    }

    @Test
    public void testShouldGetLongThrowsExceptionForOutOfRangePositiveValue() throws Exception {
        Text value = new Text("9223372036854775808");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getLong();
    }

    @Test
    public void testShouldGetLongThrowsExceptionForOutOfRangeNegativeValue() throws Exception {
        Text value = new Text("-9223372036854775809");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getLong();
    }

    @Test
    public void testShouldGetLongReturnValidPositiveLong() throws Exception {
        Text value = new Text("9223372036854775807");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        long result = this.accessor.getLong();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Long.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)Long.MAX_VALUE));
    }

    @Test
    public void testShouldGetLongReturnValidNegativeLong() throws Exception {
        Text value = new Text("-9223372036854775808");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        long result = this.accessor.getLong();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Long.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)Long.MIN_VALUE));
    }

    @Test
    public void testShouldBigDecimalWithParametersThrowsExceptionForNonNumericValue() throws Exception {
        Text value = new Text("Invalid value for BigDecimal.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getBigDecimal(1);
    }

    @Test
    public void testShouldGetBigDecimalThrowsExceptionForNonNumericValue() throws Exception {
        Text value = new Text("Invalid value for BigDecimal.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getBigDecimal();
    }

    @Test
    public void testShouldGetBigDecimalReturnValidPositiveBigDecimal() throws Exception {
        Text value = new Text("9223372036854775807000.999");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        BigDecimal result = this.accessor.getBigDecimal();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(BigDecimal.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)new BigDecimal("9223372036854775807000.999")));
    }

    @Test
    public void testShouldGetBigDecimalReturnValidNegativeBigDecimal() throws Exception {
        Text value = new Text("-9223372036854775807000.999");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        BigDecimal result = this.accessor.getBigDecimal();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(BigDecimal.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)new BigDecimal("-9223372036854775807000.999")));
    }

    @Test
    public void testShouldGetDoubleThrowsExceptionForNonNumericValue() throws Exception {
        Text value = new Text("Invalid value for double.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getDouble();
    }

    @Test
    public void testShouldGetDoubleReturnValidPositiveDouble() throws Exception {
        Text value = new Text("1.7976931348623157E308D");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        double result = this.accessor.getDouble();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Double.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)Double.MAX_VALUE));
    }

    @Test
    public void testShouldGetDoubleReturnValidNegativeDouble() throws Exception {
        Text value = new Text("-1.7976931348623157E308D");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        double result = this.accessor.getDouble();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Double.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)-1.7976931348623157E308));
    }

    @Test
    public void testShouldGetDoubleWorkWithPositiveInfinity() throws Exception {
        Text value = new Text("Infinity");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        double result = this.accessor.getDouble();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Double.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)Double.POSITIVE_INFINITY));
    }

    @Test
    public void testShouldGetDoubleWorkWithNegativeInfinity() throws Exception {
        Text value = new Text("-Infinity");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        double result = this.accessor.getDouble();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Double.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)Double.NEGATIVE_INFINITY));
    }

    @Test
    public void testShouldGetDoubleWorkWithNaN() throws Exception {
        Text value = new Text("NaN");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        double result = this.accessor.getDouble();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Double.class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)Double.NaN));
    }

    @Test
    public void testShouldGetFloatThrowsExceptionForNonNumericValue() throws Exception {
        Text value = new Text("Invalid value for float.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getFloat();
    }

    @Test
    public void testShouldGetFloatReturnValidPositiveFloat() throws Exception {
        Text value = new Text("3.4028235E38F");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        float result = this.accessor.getFloat();
        this.collector.checkThat((Object)Float.valueOf(result), CoreMatchers.instanceOf(Float.class));
        this.collector.checkThat((Object)Float.valueOf(result), CoreMatchers.equalTo((Object)Float.valueOf(Float.MAX_VALUE)));
    }

    @Test
    public void testShouldGetFloatReturnValidNegativeFloat() throws Exception {
        Text value = new Text("-3.4028235E38F");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        float result = this.accessor.getFloat();
        this.collector.checkThat((Object)Float.valueOf(result), CoreMatchers.instanceOf(Float.class));
        this.collector.checkThat((Object)Float.valueOf(result), CoreMatchers.equalTo((Object)Float.valueOf(-3.4028235E38f)));
    }

    @Test
    public void testShouldGetFloatWorkWithPositiveInfinity() throws Exception {
        Text value = new Text("Infinity");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        float result = this.accessor.getFloat();
        this.collector.checkThat((Object)Float.valueOf(result), CoreMatchers.instanceOf(Float.class));
        this.collector.checkThat((Object)Float.valueOf(result), CoreMatchers.equalTo((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
    }

    @Test
    public void testShouldGetFloatWorkWithNegativeInfinity() throws Exception {
        Text value = new Text("-Infinity");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        float result = this.accessor.getFloat();
        this.collector.checkThat((Object)Float.valueOf(result), CoreMatchers.instanceOf(Float.class));
        this.collector.checkThat((Object)Float.valueOf(result), CoreMatchers.equalTo((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
    }

    @Test
    public void testShouldGetFloatWorkWithNaN() throws Exception {
        Text value = new Text("NaN");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        float result = this.accessor.getFloat();
        this.collector.checkThat((Object)Float.valueOf(result), CoreMatchers.instanceOf(Float.class));
        this.collector.checkThat((Object)Float.valueOf(result), CoreMatchers.equalTo((Object)Float.valueOf(Float.NaN)));
    }

    @Test
    public void testShouldGetDateThrowsExceptionForNonDateValue() throws Exception {
        Text value = new Text("Invalid value for date.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getDate(null);
    }

    @Test
    public void testShouldGetDateReturnValidDateWithoutCalendar() throws Exception {
        Text value = new Text("2021-07-02");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        Date result = this.accessor.getDate(null);
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(Date.class));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(result);
        this.collector.checkThat((Object)this.dateTimeFormat.format(calendar.getTime()), CoreMatchers.equalTo((Object)"2021-07-02T00:00:00.000Z"));
    }

    @Test
    public void testShouldGetDateReturnValidDateWithCalendar() throws Exception {
        Text value = new Text("2021-07-02");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("America/Sao_Paulo"));
        Date result = this.accessor.getDate(calendar);
        calendar = Calendar.getInstance(TimeZone.getTimeZone("Etc/UTC"));
        calendar.setTime(result);
        this.collector.checkThat((Object)this.dateTimeFormat.format(calendar.getTime()), CoreMatchers.equalTo((Object)"2021-07-02T03:00:00.000Z"));
    }

    @Test
    public void testShouldGetTimeThrowsExceptionForNonTimeValue() throws Exception {
        Text value = new Text("Invalid value for time.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getTime(null);
    }

    @Test
    public void testShouldGetTimeReturnValidDateWithoutCalendar() throws Exception {
        Text value = new Text("02:30:00");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        Time result = this.accessor.getTime(null);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(result);
        this.collector.checkThat((Object)this.timeFormat.format(calendar.getTime()), CoreMatchers.equalTo((Object)"02:30:00.000Z"));
    }

    @Test
    public void testShouldGetTimeReturnValidDateWithCalendar() throws Exception {
        Text value = new Text("02:30:00");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("America/Sao_Paulo"));
        Time result = this.accessor.getTime(calendar);
        calendar = Calendar.getInstance(TimeZone.getTimeZone("Etc/UTC"));
        calendar.setTime(result);
        this.collector.checkThat((Object)this.timeFormat.format(calendar.getTime()), CoreMatchers.equalTo((Object)"05:30:00.000Z"));
    }

    @Test
    public void testShouldGetTimestampThrowsExceptionForNonTimeValue() throws Exception {
        Text value = new Text("Invalid value for timestamp.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        this.thrown.expect(SQLException.class);
        this.accessor.getTimestamp(null);
    }

    @Test
    public void testShouldGetTimestampReturnValidDateWithoutCalendar() throws Exception {
        Text value = new Text("2021-07-02 02:30:00.000");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        Timestamp result = this.accessor.getTimestamp(null);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(result);
        this.collector.checkThat((Object)this.dateTimeFormat.format(calendar.getTime()), CoreMatchers.equalTo((Object)"2021-07-02T02:30:00.000Z"));
    }

    @Test
    public void testShouldGetTimestampReturnValidDateWithCalendar() throws Exception {
        Text value = new Text("2021-07-02 02:30:00.000");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("America/Sao_Paulo"));
        Timestamp result = this.accessor.getTimestamp(calendar);
        calendar = Calendar.getInstance(TimeZone.getTimeZone("Etc/UTC"));
        calendar.setTime(result);
        this.collector.checkThat((Object)this.dateTimeFormat.format(calendar.getTime()), CoreMatchers.equalTo((Object)"2021-07-02T05:30:00.000Z"));
    }

    private void assertGetBoolean(Text value, boolean expectedResult) throws SQLException {
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)(value == null ? null : value.copyBytes()));
        boolean result = this.accessor.getBoolean();
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)expectedResult));
    }

    private void assertGetBooleanForSQLException(Text value) {
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)(value == null ? null : value.copyBytes()));
        ThrowableAssertionUtils.simpleAssertThrowableClass(SQLException.class, () -> this.accessor.getBoolean());
    }

    @Test
    public void testShouldGetBooleanThrowsSQLExceptionForInvalidValue() {
        this.assertGetBooleanForSQLException(new Text("anything"));
    }

    @Test
    public void testShouldGetBooleanThrowsSQLExceptionForEmpty() {
        this.assertGetBooleanForSQLException(new Text(""));
    }

    @Test
    public void testShouldGetBooleanReturnFalseFor0() throws Exception {
        this.assertGetBoolean(new Text("0"), false);
    }

    @Test
    public void testShouldGetBooleanReturnFalseForFalseString() throws Exception {
        this.assertGetBoolean(new Text("false"), false);
    }

    @Test
    public void testShouldGetBooleanReturnFalseForNull() throws Exception {
        this.assertGetBoolean(null, false);
    }

    @Test
    public void testShouldGetBytesReturnValidByteArray() {
        Text value = new Text("Value for Test.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        byte[] result = this.accessor.getBytes();
        this.collector.checkThat((Object)result, CoreMatchers.instanceOf(byte[].class));
        this.collector.checkThat((Object)result, CoreMatchers.equalTo((Object)value.toString().getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testShouldGetUnicodeStreamReturnValidInputStream() throws Exception {
        Text value = new Text("Value for Test.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        try (InputStream result = this.accessor.getUnicodeStream();){
            byte[] resultBytes = IOUtils.toByteArray((InputStream)result);
            this.collector.checkThat((Object)new String(resultBytes, StandardCharsets.UTF_8), CoreMatchers.equalTo((Object)value.toString()));
        }
    }

    @Test
    public void testShouldGetAsciiStreamReturnValidInputStream() throws Exception {
        Text valueText = new Text("Value for Test.");
        byte[] valueAscii = valueText.toString().getBytes(StandardCharsets.US_ASCII);
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)valueText.copyBytes());
        try (InputStream result = this.accessor.getAsciiStream();){
            byte[] resultBytes = IOUtils.toByteArray((InputStream)result);
            Assert.assertArrayEquals((byte[])valueAscii, (byte[])resultBytes);
        }
    }

    @Test
    public void testShouldGetCharacterStreamReturnValidReader() throws Exception {
        Text value = new Text("Value for Test.");
        Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
        try (Reader result = this.accessor.getCharacterStream();){
            char[] resultChars = IOUtils.toCharArray((Reader)result);
            this.collector.checkThat((Object)new String(resultChars), CoreMatchers.equalTo((Object)value.toString()));
        }
    }

    @Test
    public void testShouldGetTimeStampBeConsistentWithTimeStampAccessor() throws Exception {
        try (TimeStampMilliVector timeStampVector = rootAllocatorTestRule.createTimeStampMilliVector();){
            ArrowFlightJdbcTimeStampVectorAccessor timeStampVectorAccessor = new ArrowFlightJdbcTimeStampVectorAccessor((TimeStampVector)timeStampVector, () -> 0, wasNull -> {});
            Text value = new Text(timeStampVectorAccessor.getString());
            Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
            Timestamp timestamp = this.accessor.getTimestamp(null);
            this.collector.checkThat((Object)timestamp, CoreMatchers.equalTo((Object)timeStampVectorAccessor.getTimestamp(null)));
        }
    }

    @Test
    public void testShouldGetTimeBeConsistentWithTimeAccessor() throws Exception {
        try (TimeMilliVector timeVector = rootAllocatorTestRule.createTimeMilliVector();){
            ArrowFlightJdbcTimeVectorAccessor timeVectorAccessor = new ArrowFlightJdbcTimeVectorAccessor(timeVector, () -> 0, wasNull -> {});
            Text value = new Text(timeVectorAccessor.getString());
            Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
            Time time = this.accessor.getTime(null);
            this.collector.checkThat((Object)time, CoreMatchers.equalTo((Object)timeVectorAccessor.getTime(null)));
        }
    }

    @Test
    public void testShouldGetDateBeConsistentWithDateAccessor() throws Exception {
        try (DateMilliVector dateVector = rootAllocatorTestRule.createDateMilliVector();){
            ArrowFlightJdbcDateVectorAccessor dateVectorAccessor = new ArrowFlightJdbcDateVectorAccessor(dateVector, () -> 0, wasNull -> {});
            Text value = new Text(dateVectorAccessor.getString());
            Mockito.when((Object)this.getter.get(0)).thenReturn((Object)value.copyBytes());
            Date date = this.accessor.getDate(null);
            this.collector.checkThat((Object)date, CoreMatchers.equalTo((Object)dateVectorAccessor.getDate(null)));
        }
    }

    @Test
    public void testShouldGetObjectClassReturnString() {
        Class clazz = this.accessor.getObjectClass();
        this.collector.checkThat((Object)clazz, CoreMatchers.equalTo(String.class));
    }
}

