/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcFloat8VectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.ValueVector;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.rules.ExpectedException;

public class ArrowFlightJdbcFloat8VectorAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    @Rule
    public ExpectedException exceptionCollector = ExpectedException.none();
    private Float8Vector vector;
    private Float8Vector vectorWithNull;
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcFloat8VectorAccessor> accessorSupplier = (vector, getCurrentRow) -> new ArrowFlightJdbcFloat8VectorAccessor((Float8Vector)vector, getCurrentRow, wasNull -> {});
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcFloat8VectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcFloat8VectorAccessor>(this.collector, this.accessorSupplier);

    @Before
    public void setup() {
        this.vector = rootAllocatorTestRule.createFloat8Vector();
        this.vectorWithNull = rootAllocatorTestRule.createFloat8VectorForNullTests();
    }

    @After
    public void tearDown() {
        this.vector.close();
        this.vectorWithNull.close();
    }

    @Test
    public void testShouldGetDoubleMethodFromFloat8Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat8VectorAccessor::getDouble, (accessor, currentRow) -> CoreMatchers.is((Object)this.vector.getValueAsDouble(currentRow)));
    }

    @Test
    public void testShouldGetObjectMethodFromFloat8Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat8VectorAccessor::getObject, accessor -> CoreMatchers.is((Object)accessor.getDouble()));
    }

    @Test
    public void testShouldGetStringMethodFromFloat8Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat8VectorAccessor::getString, accessor -> CoreMatchers.is((Object)Double.toString(accessor.getDouble())));
    }

    @Test
    public void testShouldGetBooleanMethodFromFloat8Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat8VectorAccessor::getBoolean, accessor -> CoreMatchers.is((Object)(accessor.getDouble() != 0.0 ? 1 : 0)));
    }

    @Test
    public void testShouldGetByteMethodFromFloat8Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat8VectorAccessor::getByte, accessor -> CoreMatchers.is((Object)((byte)accessor.getDouble())));
    }

    @Test
    public void testShouldGetShortMethodFromFloat8Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat8VectorAccessor::getShort, accessor -> CoreMatchers.is((Object)((short)accessor.getDouble())));
    }

    @Test
    public void testShouldGetIntMethodFromFloat8Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat8VectorAccessor::getInt, accessor -> CoreMatchers.is((Object)((int)accessor.getDouble())));
    }

    @Test
    public void testShouldGetLongMethodFromFloat8Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat8VectorAccessor::getLong, accessor -> CoreMatchers.is((Object)((long)accessor.getDouble())));
    }

    @Test
    public void testShouldGetFloatMethodFromFloat8Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat8VectorAccessor::getFloat, accessor -> CoreMatchers.is((Object)Float.valueOf((float)accessor.getDouble())));
    }

    @Test
    public void testShouldGetBigDecimalMethodFromFloat8Vector() throws Exception {
        this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
            double value = accessor.getDouble();
            if (Double.isInfinite(value) || Double.isNaN(value)) {
                this.exceptionCollector.expect(SQLException.class);
            }
            this.collector.checkThat((Object)accessor.getBigDecimal(), CoreMatchers.is((Object)BigDecimal.valueOf(value)));
        });
    }

    @Test
    public void testShouldGetObjectClass() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat8VectorAccessor::getObjectClass, CoreMatchers.equalTo(Double.class));
    }

    @Test
    public void testShouldGetStringMethodFromFloat8VectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vectorWithNull, ArrowFlightJdbcFloat8VectorAccessor::getString, CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetFloatMethodFromFloat8VectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vectorWithNull, ArrowFlightJdbcFloat8VectorAccessor::getFloat, CoreMatchers.is((Object)Float.valueOf(0.0f)));
    }

    @Test
    public void testShouldGetBigDecimalMethodFromFloat8VectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vectorWithNull, ArrowFlightJdbcFloat8VectorAccessor::getBigDecimal, CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetBigDecimalWithScaleMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
            double value = accessor.getDouble();
            if (Double.isInfinite(value) || Double.isNaN(value)) {
                this.exceptionCollector.expect(SQLException.class);
            }
            this.collector.checkThat((Object)accessor.getBigDecimal(9), CoreMatchers.is((Object)BigDecimal.valueOf(value).setScale(9, RoundingMode.HALF_UP)));
        });
    }

    @Test
    public void testShouldGetObjectMethodFromFloat8VectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vectorWithNull, ArrowFlightJdbcFloat8VectorAccessor::getObject, CoreMatchers.nullValue());
    }
}

