/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcFloat4VectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.ValueVector;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.rules.ExpectedException;

public class ArrowFlightJdbcFloat4VectorAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    @Rule
    public ExpectedException exceptionCollector = ExpectedException.none();
    private Float4Vector vector;
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcFloat4VectorAccessor> accessorSupplier = (vector, getCurrentRow) -> new ArrowFlightJdbcFloat4VectorAccessor((Float4Vector)vector, getCurrentRow, wasNull -> {});
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcFloat4VectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcFloat4VectorAccessor>(this.collector, this.accessorSupplier);

    @Before
    public void setup() {
        this.vector = rootAllocatorTestRule.createFloat4Vector();
    }

    @After
    public void tearDown() {
        this.vector.close();
    }

    @Test
    public void testShouldGetFloatMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat4VectorAccessor::getFloat, (accessor, currentRow) -> CoreMatchers.is((Object)Float.valueOf(this.vector.get(currentRow))));
    }

    @Test
    public void testShouldGetObjectMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat4VectorAccessor::getObject, accessor -> CoreMatchers.is((Object)Float.valueOf(accessor.getFloat())));
    }

    @Test
    public void testShouldGetStringMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat4VectorAccessor::getString, accessor -> CoreMatchers.is((Object)Float.toString(accessor.getFloat())));
    }

    @Test
    public void testShouldGetStringMethodFromFloat4VectorWithNull() throws Exception {
        try (Float4Vector float4Vector = new Float4Vector("ID", rootAllocatorTestRule.getRootAllocator());){
            float4Vector.setNull(0);
            float4Vector.setValueCount(1);
            this.accessorIterator.assertAccessorGetter((ValueVector)float4Vector, ArrowFlightJdbcFloat4VectorAccessor::getString, CoreMatchers.nullValue());
        }
    }

    @Test
    public void testShouldGetFloatMethodFromFloat4VectorWithNull() throws Exception {
        try (Float4Vector float4Vector = new Float4Vector("ID", rootAllocatorTestRule.getRootAllocator());){
            float4Vector.setNull(0);
            float4Vector.setValueCount(1);
            this.accessorIterator.assertAccessorGetter((ValueVector)float4Vector, ArrowFlightJdbcFloat4VectorAccessor::getFloat, CoreMatchers.is((Object)Float.valueOf(0.0f)));
        }
    }

    @Test
    public void testShouldGetBigDecimalMethodFromFloat4VectorWithNull() throws Exception {
        try (Float4Vector float4Vector = new Float4Vector("ID", rootAllocatorTestRule.getRootAllocator());){
            float4Vector.setNull(0);
            float4Vector.setValueCount(1);
            this.accessorIterator.assertAccessorGetter((ValueVector)float4Vector, ArrowFlightJdbcFloat4VectorAccessor::getBigDecimal, CoreMatchers.nullValue());
        }
    }

    @Test
    public void testShouldGetObjectMethodFromFloat4VectorWithNull() throws Exception {
        try (Float4Vector float4Vector = new Float4Vector("ID", rootAllocatorTestRule.getRootAllocator());){
            float4Vector.setNull(0);
            float4Vector.setValueCount(1);
            this.accessorIterator.assertAccessorGetter((ValueVector)float4Vector, ArrowFlightJdbcFloat4VectorAccessor::getObject, CoreMatchers.nullValue());
        }
    }

    @Test
    public void testShouldGetBooleanMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat4VectorAccessor::getBoolean, accessor -> CoreMatchers.is((Object)(accessor.getFloat() != 0.0f ? 1 : 0)));
    }

    @Test
    public void testShouldGetByteMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat4VectorAccessor::getByte, accessor -> CoreMatchers.is((Object)((byte)accessor.getFloat())));
    }

    @Test
    public void testShouldGetShortMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat4VectorAccessor::getShort, accessor -> CoreMatchers.is((Object)((short)accessor.getFloat())));
    }

    @Test
    public void testShouldGetIntMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat4VectorAccessor::getInt, accessor -> CoreMatchers.is((Object)((int)accessor.getFloat())));
    }

    @Test
    public void testShouldGetLongMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat4VectorAccessor::getLong, accessor -> CoreMatchers.is((Object)((long)accessor.getFloat())));
    }

    @Test
    public void testShouldGetDoubleMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat4VectorAccessor::getDouble, accessor -> CoreMatchers.is((Object)accessor.getFloat()));
    }

    @Test
    public void testShouldGetBigDecimalMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
            float value = accessor.getFloat();
            if (Float.isInfinite(value) || Float.isNaN(value)) {
                this.exceptionCollector.expect(SQLException.class);
            }
            this.collector.checkThat((Object)accessor.getBigDecimal(), CoreMatchers.is((Object)BigDecimal.valueOf(value)));
        });
    }

    @Test
    public void testShouldGetBigDecimalWithScaleMethodFromFloat4Vector() throws Exception {
        this.accessorIterator.iterate((ValueVector)this.vector, (accessor, currentRow) -> {
            float value = accessor.getFloat();
            if (Float.isInfinite(value) || Float.isNaN(value)) {
                this.exceptionCollector.expect(SQLException.class);
            }
            this.collector.checkThat((Object)accessor.getBigDecimal(9), CoreMatchers.is((Object)BigDecimal.valueOf(value).setScale(9, RoundingMode.HALF_UP)));
        });
    }

    @Test
    public void testShouldGetObjectClass() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcFloat4VectorAccessor::getObjectClass, accessor -> CoreMatchers.equalTo(Float.class));
    }
}

