/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcDecimalVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.ValueVector;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ArrowFlightJdbcDecimalVectorAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private final Supplier<ValueVector> vectorSupplier;
    private ValueVector vector;
    private ValueVector vectorWithNull;
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcDecimalVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> {
        ArrowFlightJdbcAccessorFactory.WasNullConsumer noOpWasNullConsumer = wasNull -> {};
        if (vector instanceof DecimalVector) {
            return new ArrowFlightJdbcDecimalVectorAccessor((DecimalVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof Decimal256Vector) {
            return new ArrowFlightJdbcDecimalVectorAccessor((Decimal256Vector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        return null;
    };
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcDecimalVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcDecimalVectorAccessor>(this.collector, this.accessorSupplier);

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({() -> rootAllocatorTestRule.createDecimalVector(), "DecimalVector"}, {() -> rootAllocatorTestRule.createDecimal256Vector(), "Decimal256Vector"});
    }

    public ArrowFlightJdbcDecimalVectorAccessorTest(Supplier<ValueVector> vectorSupplier, String vectorType) {
        this.vectorSupplier = vectorSupplier;
    }

    @Before
    public void setup() {
        this.vector = this.vectorSupplier.get();
        this.vectorWithNull = this.vectorSupplier.get();
        this.vectorWithNull.clear();
        this.vectorWithNull.setValueCount(5);
    }

    @After
    public void tearDown() {
        this.vector.close();
        this.vectorWithNull.close();
    }

    @Test
    public void testShouldGetBigDecimalFromDecimalVector() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcDecimalVectorAccessor::getBigDecimal, (accessor, currentRow) -> CoreMatchers.notNullValue());
    }

    @Test
    public void testShouldGetDoubleMethodFromDecimalVector() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcDecimalVectorAccessor::getDouble, (accessor, currentRow) -> CoreMatchers.equalTo((Object)accessor.getBigDecimal().doubleValue()));
    }

    @Test
    public void testShouldGetFloatMethodFromDecimalVector() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcDecimalVectorAccessor::getFloat, (accessor, currentRow) -> CoreMatchers.equalTo((Object)Float.valueOf(accessor.getBigDecimal().floatValue())));
    }

    @Test
    public void testShouldGetLongMethodFromDecimalVector() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcDecimalVectorAccessor::getLong, (accessor, currentRow) -> CoreMatchers.equalTo((Object)accessor.getBigDecimal().longValue()));
    }

    @Test
    public void testShouldGetIntMethodFromDecimalVector() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcDecimalVectorAccessor::getInt, (accessor, currentRow) -> CoreMatchers.equalTo((Object)accessor.getBigDecimal().intValue()));
    }

    @Test
    public void testShouldGetShortMethodFromDecimalVector() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcDecimalVectorAccessor::getShort, (accessor, currentRow) -> CoreMatchers.equalTo((Object)accessor.getBigDecimal().shortValue()));
    }

    @Test
    public void testShouldGetByteMethodFromDecimalVector() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcDecimalVectorAccessor::getByte, (accessor, currentRow) -> CoreMatchers.equalTo((Object)accessor.getBigDecimal().byteValue()));
    }

    @Test
    public void testShouldGetStringMethodFromDecimalVector() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcDecimalVectorAccessor::getString, (accessor, currentRow) -> CoreMatchers.equalTo((Object)accessor.getBigDecimal().toString()));
    }

    @Test
    public void testShouldGetBooleanMethodFromDecimalVector() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcDecimalVectorAccessor::getBoolean, (accessor, currentRow) -> CoreMatchers.equalTo((Object)(!accessor.getBigDecimal().equals(BigDecimal.ZERO) ? 1 : 0)));
    }

    @Test
    public void testShouldGetObjectMethodFromDecimalVector() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcDecimalVectorAccessor::getObject, (accessor, currentRow) -> CoreMatchers.equalTo((Object)accessor.getBigDecimal()));
    }

    @Test
    public void testShouldGetObjectClass() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vector, ArrowFlightJdbcDecimalVectorAccessor::getObjectClass, (accessor, currentRow) -> CoreMatchers.equalTo(BigDecimal.class));
    }

    @Test
    public void testShouldGetBigDecimalMethodFromDecimalVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vectorWithNull, ArrowFlightJdbcDecimalVectorAccessor::getBigDecimal, (accessor, currentRow) -> CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetObjectMethodFromDecimalVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vectorWithNull, ArrowFlightJdbcDecimalVectorAccessor::getObject, (accessor, currentRow) -> CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetStringMethodFromDecimalVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vectorWithNull, ArrowFlightJdbcDecimalVectorAccessor::getString, (accessor, currentRow) -> CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetByteMethodFromDecimalVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vectorWithNull, ArrowFlightJdbcDecimalVectorAccessor::getByte, (accessor, currentRow) -> CoreMatchers.is((Object)0));
    }

    @Test
    public void testShouldGetShortMethodFromDecimalVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vectorWithNull, ArrowFlightJdbcDecimalVectorAccessor::getShort, (accessor, currentRow) -> CoreMatchers.is((Object)0));
    }

    @Test
    public void testShouldGetIntMethodFromDecimalVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vectorWithNull, ArrowFlightJdbcDecimalVectorAccessor::getInt, (accessor, currentRow) -> CoreMatchers.is((Object)0));
    }

    @Test
    public void testShouldGetLongMethodFromDecimalVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vectorWithNull, ArrowFlightJdbcDecimalVectorAccessor::getLong, (accessor, currentRow) -> CoreMatchers.is((Object)0L));
    }

    @Test
    public void testShouldGetFloatMethodFromDecimalVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vectorWithNull, ArrowFlightJdbcDecimalVectorAccessor::getFloat, (accessor, currentRow) -> CoreMatchers.is((Object)Float.valueOf(0.0f)));
    }

    @Test
    public void testShouldGetDoubleMethodFromDecimalVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vectorWithNull, ArrowFlightJdbcDecimalVectorAccessor::getDouble, (accessor, currentRow) -> CoreMatchers.is((Object)0.0));
    }

    @Test
    public void testShouldGetBooleanMethodFromDecimalVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vectorWithNull, ArrowFlightJdbcDecimalVectorAccessor::getBoolean, (accessor, currentRow) -> CoreMatchers.is((Object)false));
    }

    @Test
    public void testShouldGetBigDecimalWithScaleMethodFromDecimalVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter(this.vectorWithNull, accessor -> accessor.getBigDecimal(2), (accessor, currentRow) -> CoreMatchers.nullValue());
    }
}

