/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import java.math.BigDecimal;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcBitVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.ValueVector;
import org.hamcrest.CoreMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class ArrowFlightJdbcBitVectorAccessorTest {
    @ClassRule
    public static RootAllocatorTestRule rootAllocatorTestRule = new RootAllocatorTestRule();
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcBitVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> new ArrowFlightJdbcBitVectorAccessor((BitVector)vector, getCurrentRow, wasNull -> {});
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcBitVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcBitVectorAccessor>(this.collector, this.accessorSupplier);
    private BitVector vector;
    private BitVector vectorWithNull;
    private boolean[] arrayToAssert;

    @Before
    public void setup() {
        this.arrayToAssert = new boolean[]{false, true};
        this.vector = rootAllocatorTestRule.createBitVector();
        this.vectorWithNull = rootAllocatorTestRule.createBitVectorForNullTests();
    }

    @After
    public void tearDown() {
        this.vector.close();
        this.vectorWithNull.close();
    }

    private <T> void iterate(AccessorTestUtils.CheckedFunction<ArrowFlightJdbcBitVectorAccessor, T> function, T result, T resultIfFalse, BitVector vector) throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)vector, function, (accessor, currentRow) -> CoreMatchers.is((Object)(this.arrayToAssert[currentRow] ? result : resultIfFalse)));
    }

    @Test
    public void testShouldGetBooleanMethodFromBitVector() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getBoolean, true, false, this.vector);
    }

    @Test
    public void testShouldGetByteMethodFromBitVector() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getByte, (byte)1, (byte)0, this.vector);
    }

    @Test
    public void testShouldGetShortMethodFromBitVector() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getShort, (short)1, (short)0, this.vector);
    }

    @Test
    public void testShouldGetIntMethodFromBitVector() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getInt, 1, 0, this.vector);
    }

    @Test
    public void testShouldGetLongMethodFromBitVector() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getLong, 1L, 0L, this.vector);
    }

    @Test
    public void testShouldGetFloatMethodFromBitVector() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getFloat, Float.valueOf(1.0f), Float.valueOf(0.0f), this.vector);
    }

    @Test
    public void testShouldGetDoubleMethodFromBitVector() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getDouble, 1.0, 0.0, this.vector);
    }

    @Test
    public void testShouldGetBigDecimalMethodFromBitVector() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getBigDecimal, BigDecimal.ONE, BigDecimal.ZERO, this.vector);
    }

    @Test
    public void testShouldGetBigDecimalMethodFromBitVectorFromNull() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getBigDecimal, null, null, this.vectorWithNull);
    }

    @Test
    public void testShouldGetObjectMethodFromBitVector() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getObject, true, false, this.vector);
    }

    @Test
    public void testShouldGetObjectMethodFromBitVectorFromNull() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getObject, null, null, this.vectorWithNull);
    }

    @Test
    public void testShouldGetStringMethodFromBitVector() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getString, "true", "false", this.vector);
    }

    @Test
    public void testShouldGetStringMethodFromBitVectorFromNull() throws Exception {
        this.iterate(ArrowFlightJdbcBitVectorAccessor::getString, null, null, this.vectorWithNull);
    }

    @Test
    public void testShouldGetObjectClass() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)this.vector, ArrowFlightJdbcBitVectorAccessor::getObjectClass, CoreMatchers.equalTo(Boolean.class));
    }
}

