/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.accessor.impl.numeric.ArrowFlightJdbcBaseIntVectorAccessor;
import org.apache.arrow.driver.jdbc.utils.AccessorTestUtils;
import org.apache.arrow.driver.jdbc.utils.RootAllocatorTestRule;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.hamcrest.CoreMatchers;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArrowFlightJdbcBaseIntVectorAccessorUnitTest {
    @ClassRule
    public static RootAllocatorTestRule rule = new RootAllocatorTestRule();
    private static UInt4Vector int4Vector;
    private static UInt8Vector int8Vector;
    private static IntVector intVectorWithNull;
    private static TinyIntVector tinyIntVector;
    private static SmallIntVector smallIntVector;
    private static IntVector intVector;
    private static BigIntVector bigIntVector;
    @Rule
    public final ErrorCollector collector = new ErrorCollector();
    private final AccessorTestUtils.AccessorSupplier<ArrowFlightJdbcBaseIntVectorAccessor> accessorSupplier = (vector, getCurrentRow) -> {
        ArrowFlightJdbcAccessorFactory.WasNullConsumer noOpWasNullConsumer = wasNull -> {};
        if (vector instanceof UInt1Vector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((UInt1Vector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof UInt2Vector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((UInt2Vector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof UInt4Vector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((UInt4Vector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof UInt8Vector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((UInt8Vector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof TinyIntVector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((TinyIntVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof SmallIntVector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((SmallIntVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof IntVector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((IntVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        if (vector instanceof BigIntVector) {
            return new ArrowFlightJdbcBaseIntVectorAccessor((BigIntVector)vector, getCurrentRow, noOpWasNullConsumer);
        }
        return null;
    };
    private final AccessorTestUtils.AccessorIterator<ArrowFlightJdbcBaseIntVectorAccessor> accessorIterator = new AccessorTestUtils.AccessorIterator<ArrowFlightJdbcBaseIntVectorAccessor>(this.collector, this.accessorSupplier);

    @BeforeClass
    public static void setup() {
        int4Vector = new UInt4Vector("ID", rule.getRootAllocator());
        int4Vector.setSafe(0, -2147483647);
        int4Vector.setValueCount(1);
        int8Vector = new UInt8Vector("ID", rule.getRootAllocator());
        int8Vector.setSafe(0, -1L);
        int8Vector.setValueCount(1);
        intVectorWithNull = new IntVector("ID", rule.getRootAllocator());
        intVectorWithNull.setNull(0);
        intVectorWithNull.setValueCount(1);
        tinyIntVector = new TinyIntVector("ID", rule.getRootAllocator());
        tinyIntVector.setSafe(0, 170);
        tinyIntVector.setValueCount(1);
        smallIntVector = new SmallIntVector("ID", rule.getRootAllocator());
        smallIntVector.setSafe(0, 43707);
        smallIntVector.setValueCount(1);
        intVector = new IntVector("ID", rule.getRootAllocator());
        intVector.setSafe(0, -1430532899);
        intVector.setValueCount(1);
        bigIntVector = new BigIntVector("ID", rule.getRootAllocator());
        bigIntVector.setSafe(0, -6144092013047338309L);
        bigIntVector.setValueCount(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{bigIntVector, intVector, smallIntVector, tinyIntVector, int4Vector, int8Vector, intVectorWithNull, rule});
    }

    @Test
    public void testShouldGetStringFromUnsignedValue() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)int8Vector, ArrowFlightJdbcBaseIntVectorAccessor::getString, CoreMatchers.equalTo((Object)"18446744073709551615"));
    }

    @Test
    public void testShouldGetBytesFromIntVectorThrowsSqlException() throws Exception {
        this.accessorIterator.assertAccessorGetterThrowingException((ValueVector)intVector, ArrowFlightJdbcAccessor::getBytes);
    }

    @Test
    public void testShouldGetStringFromIntVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)intVectorWithNull, ArrowFlightJdbcBaseIntVectorAccessor::getString, CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetObjectFromInt() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)intVector, ArrowFlightJdbcBaseIntVectorAccessor::getObject, CoreMatchers.equalTo((Object)-1430532899));
    }

    @Test
    public void testShouldGetObjectFromTinyInt() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)tinyIntVector, ArrowFlightJdbcBaseIntVectorAccessor::getObject, CoreMatchers.equalTo((Object)-86));
    }

    @Test
    public void testShouldGetObjectFromSmallInt() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)smallIntVector, ArrowFlightJdbcBaseIntVectorAccessor::getObject, CoreMatchers.equalTo((Object)-21829));
    }

    @Test
    public void testShouldGetObjectFromBigInt() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)bigIntVector, ArrowFlightJdbcBaseIntVectorAccessor::getObject, CoreMatchers.equalTo((Object)-6144092013047338309L));
    }

    @Test
    public void testShouldGetObjectFromUnsignedInt() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)int4Vector, ArrowFlightJdbcBaseIntVectorAccessor::getObject, CoreMatchers.equalTo((Object)-2147483647));
    }

    @Test
    public void testShouldGetObjectFromIntVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)intVectorWithNull, ArrowFlightJdbcBaseIntVectorAccessor::getObject, CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetBigDecimalFromIntVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)intVectorWithNull, ArrowFlightJdbcBaseIntVectorAccessor::getBigDecimal, CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetBigDecimalWithScaleFromIntVectorWithNull() throws Exception {
        this.accessorIterator.assertAccessorGetter((ValueVector)intVectorWithNull, accessor -> accessor.getBigDecimal(2), CoreMatchers.nullValue());
    }

    @Test
    public void testShouldGetBytesFromSmallVectorThrowsSqlException() throws Exception {
        this.accessorIterator.assertAccessorGetterThrowingException((ValueVector)smallIntVector, ArrowFlightJdbcAccessor::getBytes);
    }

    @Test
    public void testShouldGetBytesFromTinyIntVectorThrowsSqlException() throws Exception {
        this.accessorIterator.assertAccessorGetterThrowingException((ValueVector)tinyIntVector, ArrowFlightJdbcAccessor::getBytes);
    }

    @Test
    public void testShouldGetBytesFromBigIntVectorThrowsSqlException() throws Exception {
        this.accessorIterator.assertAccessorGetterThrowingException((ValueVector)bigIntVector, ArrowFlightJdbcAccessor::getBytes);
    }
}

